/**************************************************************************************
 * @file        : ProxyHandlerExt.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Used for Status bar and Launch bar activation
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hall_std_if.h"
//#include "gui_std_if.h"
#include "ProxyHandlerExt.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SXM_HALL
#include "trcGenProj/Header/ProxyHandlerExt.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl;

namespace hmi {
namespace apphmi_sxm {

void ProxyHandlerExt::onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< HMIAppCtrlProxy >& /*proxy*/, const ::boost::shared_ptr< EvDisplayStatusEvalSignal >& sig)
{
   int8 displayRegionStatus = sig->getData().getDisplayRegionStatus();
   if ((sig->getData().getDisplayRegion() == hmibase::FOOTER_LINE)  &&
         ((displayRegionStatus == hmibase::SURFACESTATE_VISIBLE) || (displayRegionStatus == hmibase::SURFACESTATE_INVISIBLE)))
   {
      POST_MSG((COURIER_MESSAGE_NEW(SxmLaunchBarActivationResponseUpdMsg)(displayRegionStatus)));
   }
   else if ((sig->getData().getDisplayRegion() == hmibase::STATUS_LINE)  &&
            ((displayRegionStatus == hmibase::SURFACESTATE_VISIBLE) || (displayRegionStatus == hmibase::SURFACESTATE_INVISIBLE)))
   {
      POST_MSG((COURIER_MESSAGE_NEW(SXMStatusBarActivationResponseUpdMsg)(displayRegionStatus)));
   }
}


}
}
