/**************************************************************************************
 * @file        : SXMVehicleServiceInterface.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM vehicle Interface to get vehicle data.
 * @copyright   : (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMVEHICLESERVICEINTERFACE_H_
#define _SXMVEHICLESERVICEINTERFACE_H_

namespace App {
namespace Core {
/**
 *
 * @class : SXMVehicleServiceInterface
 */
class SXMVehicleServiceInterface
{
   public:
      /**
       * Helper function to send SXM info.
       */
      static void sendXMInfoData(const int type, const std::string& dataInfo);

      /**
       * Helper function to send SXM Preset info.
       */
      static void updateXMPresetStatus(int presetId);
};


}  // namespace Core
}  // namespace App

#endif
