/**************************************************************************************
 * @file        : SXMVehicleServiceInterface.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM vehicle Interface to get vehicle data.
 * @copyright   : (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/

#include "hmi_trace_if.h"
#include "SXMVehicleService.h"
#include "SXMVehicleServiceInterface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::SXMVehicleServiceInterface::
#include "trcGenProj/Header/SXMVehicleServiceInterface.cpp.trc.h"
#endif

namespace App {
namespace Core {

/**
 * Helper function to send SXM info.
 */
void SXMVehicleServiceInterface::sendXMInfoData(const int type, const std::string& dataInfo)
{
   ETG_TRACE_USR1(("SXMVehicleServiceInterface SXMInfoData"));
   SXMVehicleService::instance()->sendXMInfoData(type, dataInfo);
}


/**
 * Helper function to send SXM Preset info.
 */
void SXMVehicleServiceInterface::updateXMPresetStatus(int presetId)
{
   ETG_TRACE_USR1(("SXMVehicleServiceInterface SXMPresetInfo"));
   SXMVehicleService::instance()->updateXMPresetStatus(presetId);
}


}  // namespace Core
}  // namespace App
