/**************************************************************************************
 * @file        : SXMClockServiceInterface.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM clock Interface to get clock data.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "hall_std_if.h"  //when other headers also needed, include hall_std_if and remove above two
#include "SXMClockServiceInterface.h"
#include "SXMClockService.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::SXMClockServiceInterface::
#include "trcGenProj/Header/SXMClockServiceInterface.cpp.trc.h"
#endif

namespace App {
namespace Core {
/**
 * Helper function to get Time format from  MIDW Clock fi.
 * @return : returns time format
 */
::clock_main_fi_types::VDCLK_TEN_TimeFormat SXMClockServiceInterface::GetCurrentTimeFormat()
{
   ETG_TRACE_USR4(("SXMClockServiceInterface GetCurrentTimeFormat"));
   return SXMClockService::instance()->GetCurrentTimeFormat();
}


/**
 * Helper function to get Date format from  MIDW Clock fi.
 * @return : returns Date format
 */
::clock_main_fi_types::VDCLK_TEN_NewDateFormat SXMClockServiceInterface::GetCurrentDateFormat()
{
   ETG_TRACE_USR4(("SXMClockServiceInterface GetCurrentDateFormat"));
   return SXMClockService::instance()->GetCurrentDateFormat();
}


/**
 * Helper function to get LocalTimedate  from  MIDW Clock fi.
 * @return : returns Date format
 */
LocalDateTimeType SXMClockServiceInterface::GetLocalTimeDate()
{
   ETG_TRACE_USR4(("SXMClockServiceInterface GetLocalTimeDate"));
   return SXMClockService::instance()->GetLocalTimeDate();
}


/**
 * Helper function to get current Time Zone.
 * @return : returns time zone.
 */
std::string SXMClockServiceInterface::GetTimeZone()
{
   ETG_TRACE_USR4(("SXMClockServiceInterface GetTimeZone"));
   return SXMClockService::instance()->GetTimeZone();
}


void SXMClockServiceInterface::registerTimeStatusNotification(ISxmClockService* _obsptr, enSXMServiceType enServiceType)
{
   SXMClockService::instance()->registerTimeStatusNotification(_obsptr, enServiceType);
}


void SXMClockServiceInterface::deregisterTimeStatusNotification(ISxmClockService* _obsptr, enSXMServiceType enServiceType)
{
   SXMClockService::instance()->deregisterTimeStatusNotification(_obsptr, enServiceType);
}


}  // namespace Core
}  // namespace App
