/********************************************************************
 * @file         : ISxmClockService.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Interface adapter to handle Clock Service state changes
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 ************************************************************************************/

#ifndef ISXMCLOCK_SERVICE_H_
#define ISXMCLOCK_SERVICE_H_


namespace App {
namespace Core {
/**
   @brief : SXM Interface to Notify Clock changes for functional class.
   @class : ISxmClockService
 */
class ISxmClockService
{
   public:
      virtual ~ISxmClockService() {};
      virtual void vNotifyTimeStatus(unsigned int) = 0;
      virtual void vNotifyDateStatus(unsigned int) = 0;
};


} //end of namespace Core
} //end of namespace App

#endif /* ISXMHMISERVICESTATEHANDLER_H_ */
