/**************************************************************************************
 * @file        : ApplicationSwitchClientHandler.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : DBus client for Application switch interface.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef APPLICATIONSWITCH_CLIENT_HANDLER
#define APPLICATIONSWITCH_CLIENT_HANDLER
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "App/Core/SxmUtils/SxmCommonTypes.h"
#include "AppHmi_SxmMessages.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"

namespace App {
namespace Core {

#define APPLICATIONSWITCH_NS ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

class ApplicationSwitchClientHandler
   : public SxmUtilsSingleton<ApplicationSwitchClientHandler>
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public Sig_ActivateContextCallbackIF
   , public ActiveRegionIdCallbackIF
{
   public:
      ApplicationSwitchClientHandler();
      virtual ~ApplicationSwitchClientHandler();

      /**
       * Utility function that registers for notifications updates from AudioSourceChange.
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from AudioSourceChange.
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                      const ::boost::shared_ptr< Sig_ActivateContextError >& /*error*/);
      void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< Sig_ActivateContextSignal >& /*signal*/);

      void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                 const ::boost::shared_ptr< ActiveRegionIdError >& /*error*/);
      void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                  const ::boost::shared_ptr< ActiveRegionIdUpdate >& /*update*/);

      bool onCourierMessage(const SxmContextSwitchScreenReqMsg& oMsg);
      void requestSendContext(uint8 sourceAppId, APPLICATIONSWITCH_NS::enActivityIDs sourceActivityId);
      void requestSxmSelfContext();
      void returnToPreviousSource();
      uint8 getActiveRegion();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SxmContextSwitchScreenReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      friend class SxmUtilsSingleton<ApplicationSwitchClientHandler>;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      ::boost::shared_ptr<ApplicationSwitchProxy> _sxmApplicationSwitchClientProxy;
      uint8 _activeRegion;
      bool _isInternalRequestContext;

      void displaySXMContextScene(APPLICATIONSWITCH_NS::enActivityIDs targetActivityID);
};


#undef APPLICATIONSWITCH_TYPES
}//Core
}//App

#endif //APPLICATIONSWITCH_CLIENT_HANDLER
