/**************************************************************************************
 * @file         : AppHmi_Sxm_Trace.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Defines SXM Trace classes
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef APPHMI_SXM_TRACE_H
#define APPHMI_SXM_TRACE_H

#ifndef HMI_TRACE_IF_INCLUDED
#error "Please include hmi_trace_if.h only"
#endif

// default trace set will be defined in Project_Trace.h by using the macro APPHMI_STANDARD_TRACE_SET
// define your own trace classe here, beginning with id TR_CLASSOFFSET_APPHMI_USER1 as offset to your base id,
// see hmi_trace_if.h
static const unsigned short  TR_CLASS_APPHMI_SXMAUDIO       				= (TR_COMP_UI_APP_HMI_14 + TR_CLASSOFFSET_APPHMI_USER1);
static const unsigned short  TR_CLASS_APPHMI_SXMFUEL        				= (TR_CLASS_APPHMI_SXMAUDIO + 1);
static const unsigned short  TR_CLASS_APPHMI_SXMMOVIES      				= (TR_CLASS_APPHMI_SXMAUDIO + 2);
static const unsigned short  TR_CLASS_APPHMI_SXMPARKING     				= (TR_CLASS_APPHMI_SXMAUDIO + 3);
static const unsigned short  TR_CLASS_APPHMI_SXMSPORTS      				= (TR_CLASS_APPHMI_SXMAUDIO + 4);
static const unsigned short  TR_CLASS_APPHMI_SXMTABWEATHER  				= (TR_CLASS_APPHMI_SXMAUDIO + 5);
static const unsigned short  TR_CLASS_APPHMI_SXMSTOCKS      				= (TR_CLASS_APPHMI_SXMAUDIO + 6);
static const unsigned short  TR_CLASS_APPHMI_SXMUTILS      					= (TR_CLASS_APPHMI_SXMAUDIO + 7);
static const unsigned short  TR_CLASS_APPHMI_SXMWSALERTS    				= (TR_CLASS_APPHMI_SXMAUDIO + 8);
static const unsigned short  TR_CLASS_APPHMI_SXMCOMMON      				= (TR_CLASS_APPHMI_SXMAUDIO + 9);
static const unsigned short  TR_CLASS_APPHMI_SXMDIAG	    				= (TR_CLASS_APPHMI_SXMAUDIO + 10);
static const unsigned short  TR_CLASS_APPHMI_SXM_USERINTERFACECONTROL	    = (TR_CLASS_APPHMI_SXMAUDIO + 11);

#endif // APPHMI_SXM_TRACE_H
