/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_SdsMessages.h"
// the views
#include "CGIAppViewController_Sds.h"


SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_GLO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_NAV_T4),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_S_AUD),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_S_PHO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_PHO_T1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_AUD_T1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_AUD),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_NAV_T5),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_NAV_T2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_PHO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_E_PHO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_S_NAV),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_TUNER),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_NAV_T1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_NAV_CONF),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SDS_LAYOUT_CV_AUD_CONF),
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}
