/**************************************************************************************
* @file         : <VehicleSrvClient.cpp>
* @author       : <ECG> <INF4CV>
* @addtogroup   : <AppHmi_Sds>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "VehicleSrvClient.h"
#include "AppHmi_SdsStateMachine.h"
//#include "App/datapool/SdsDataPoolConfig.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SDS
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SDS_"
#define ETG_I_FILE_PREFIX                 App::Core::VehicleSrvClient::
#include "trcGenProj/Header/VehicleSrvClient.cpp.trc.h"
#endif


using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;

#include <iostream>
using namespace std;


namespace App {
namespace Core {

struct LanguageTable
{
   int LangIndex;
   std::string LangString;
};


LanguageTable LanguageMappingTable[LANGNO] =
{
   { 12, "en_GB" },
   { 23, "de_DE" },
   { 10, "nl_NL" },
   { 21, "fr_FR" },
   { 29, "it_IT"},
   { 46, "es_ES"},
   { 39, "pt_PT" },
   { 27, "hu_HU" },
   { 42, "ru_RU" },
   { 8, "cs_CZ" },
   { 9, "da_DK" },
   { 35, "nb_NO" },
   { 38, "pl_PL" },
   { 49, "sv_SE" },
   { 13, "en_US" },
   { 24, "el_GR" },
   { 52, "tr_TR" },
   { 47, "es_MX" },
   { 22, "fr_CA" },
};


/**
 * @Constructor
 */

VehicleSrvClient::VehicleSrvClient(): _vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this))
{
   ETG_TRACE_USR4(("VehicleSrvClient Constructor is called"));
   if (_vehicleProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _vehicleProxy->getPortName());
      ETG_TRACE_USR4(("VehicleSrvClient Constructor after creating proxy"));
   }
}


/**
* @Destructor
*/

VehicleSrvClient::~VehicleSrvClient()
{
   ETG_TRACE_USR4(("VehicleSrvClient destructor is called"));
   _vehicleProxy.reset();
}


/**
 * @onAvailable
 */
void VehicleSrvClient::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onAvailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));

   _vehicleProxy->sendLanguageUpReg(*this);
   _vehicleProxy->sendVoiceRecgCommandUpReg(*this);
}


/**
 * @onUnavailable
 */
void VehicleSrvClient::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));
   _vehicleProxy->sendLanguageRelUpRegAll();
   _vehicleProxy->sendVoiceRecgCommandRelUpRegAll();
}


void VehicleSrvClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient register property is called"));
   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      ETG_TRACE_USR4(("VehicleSrvClient register property is called"));
      _vehicleProxy->sendLanguageUpReg(*this);
      _vehicleProxy->sendVoiceRecgCommandUpReg(*this);
   }
}


void VehicleSrvClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient deregister property is called"));
   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      _vehicleProxy->sendLanguageRelUpRegAll();
      _vehicleProxy->sendVoiceRecgCommandRelUpRegAll();
   }
}


/*
 * onSetLanguageResult - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] result
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< SetLanguageResult >& result)
{
   ETG_TRACE_USR4(("onSetLanguageResult received :  %d", result->getResult()));
}


/*
 * onSetLanguageError - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SetLanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onSetLanguageError"));
}


/*
 * onLanguageStatus - ASF framework callback which is triggered on every setLanguage()
 * @param[in] proxy
 * @param[in] status
 * @param[out] None
 * @return voidl
 * todo :check As of now, after setLanguage, onLanguageStatus() is received twice from the VD_Vehicle data.
 * First update represents, previously configured Language ID and the second one represents currently configured ID.*/

void VehicleSrvClient::onLanguageStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< LanguageStatus >& status)
{
   std::vector<T_Language_SourceTable> langTable = status->getLangTable();
   uint8 langIndex = status->getLanguage();
   ETG_TRACE_USR4(("onLanguageStatus langIndex=%d", langIndex));
   std::string langauge = getLanguageId(langIndex);
   //COURIER_MESSAGE_NEW(Courier::SetCultureReqMsg)(Courier::ItemId(langauge.c_str()))->Post();
   //SdsDataPoolConfig::getInstance()->setLanguage(langIndex);
}


std::string VehicleSrvClient::getLanguageId(int index)
{
   std::string langId = "";
   for (int i = 0; i < (sizeof(LanguageMappingTable) / sizeof(LanguageMappingTable[0])); i++)
   {
      if (LanguageMappingTable[i].LangIndex == index)
      {
         ETG_TRACE_USR4(("onLanguageStatus Language string=%s", LanguageMappingTable[i].LangString.c_str()));
         langId = LanguageMappingTable[i].LangString.c_str();
      }
   }
   return langId;
}


/**
* Description     : This method will be called on system startup for language translation
*
* @return         : uint8
*/
/* void VehicleSrvClient::readLanguageOnStartUp()
{
	uint8 languageIndex = SdsDataPoolConfig::getInstance()->getLanguage();
	ETG_TRACE_USR4(("SdsDataPoolConfig::setLanguageOnSystemLoad requested :%d", languageIndex));
	std::string textid = getLanguageId(languageIndex);
	//COURIER_MESSAGE_NEW(Courier::SetCultureReqMsg)(Courier::ItemId(textid.c_str()))->Post();
} */

/*
 * onLanguageError - ASF framework callback which is triggered if there is any error in setLanguage()
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< LanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("onLanguageError"));
}


void VehicleSrvClient::onVoiceRecgCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /* proxy */, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VoiceRecgCommandStatus >& status)
{
   ETG_TRACE_USR4(("onVoiceRecgCommandStatus %d", status->getVoiceRecgCommandValue()));
   if (status->getVoiceRecgCommandValue() == 1)
   {
      POST_MSG((COURIER_MESSAGE_NEW(StartVoiceRecognition)()));
   }
   else if (status->getVoiceRecgCommandValue() == 2)
   {
      POST_MSG((COURIER_MESSAGE_NEW(HKStatusChangedNotifyMsg)()));
   }
}


void VehicleSrvClient::onVoiceRecgCommandError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< VoiceRecgCommandError >& /*error*/)
{
   ETG_TRACE_USR4(("onVoiceRecgCommandError"));
}


//
// onCourierMessage - To Handle GUI startup message
// when the GUI is ready, request all clients to read language id from dp and then set culture message
// @param[in] GuiStartupFinishedUpdMsg
// @param[out] None
// @return bool
//

//bool VehicleSrvClient::onCourierMessage(const GuiStartupFinishedUpdMsg& /*msg*/)
//{
// ETG_TRACE_USR4(("VehicleSrvClient::onCourierMessage(const GuiStartupFinishedUpdMsg()"));


//readLanguageOnStartUp();

//return false;
//}
}


}
