/**************************************************************************//**
 * \file       SdsHall.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/


#ifndef SdsHall_h
#define SdsHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "App/Core/SdsAdapter/Proxy/provider/SdsAdapterProvider.h"
#include "App/DataModel/HMIModelComponent.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DefSetServiceBase/DefSetServiceBase.h" //Reset To Factory
//#include "Common/DataModel/ListRegistry.h"
#include "sds_gui_fi/SdsFocusServiceProxy.h"
#include "App/Core/SdsAdapter/Proxy/requestor/SdsAdapterRequestor.h"
#include "App/Core/VehicleSrvClient/VehicleSrvClient.h"
#include <Adapter/LanguageHandlerAdapter.h>


using namespace ::asf::core;
namespace App {
namespace Core {

class HmiDataServiceClientHandler;
class SdsTTfisTestCommandHandler;
class GuiUpdater;
class ListHandler;
class HmiVehicleHandler;
class SdsEventHandler;
class SettingsContextHandler;
class SdsConfigFlags;
class SdsKDSConfiguration;

class SdsHall
   : public HallComponentBase
   , public iDefSetServiceBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:

      SdsHall();
      virtual ~SdsHall();
      /**
       * onExpired - To indicate receiving onExpired timer signal from State Machine
       * @param[in] asf::core::Timer object reference
       * @param[in] none
       * @parm[out] boost::shared_ptr<asf::core::TimerPayload> Payload Data
       * @return void
       */
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      /**
       * registerProperties - Registers to CCA/DBus server properties by calling appropriate "Upreg/SendRegister" method calls.
       * @param[in] ::boost::shared_ptr< asf::core::Proxy >& proxy - GUI Proxy handler
       * @param[in] asf::core::ServiceStateChange& stateChange - Contains the current Service state
       * @pre - Gets called by GUI StateMachine when the GUI App is initialized and ready
       * @return void
       */
      /*       virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                            const asf::core::ServiceStateChange& stateChange); */
      /**
       * deregisterProperties - Deregisters  CCA/DBus server properties by calling appropriate "RelUpreg/SendDeRegister" method calls.
       * @param[in] ::boost::shared_ptr< asf::core::Proxy >& proxy - GUI Proxy handler
       * @param[in] asf::core::ServiceStateChange& stateChange - Contains the current Service state
       * @pre - Gets called by GUI StateMachine when the GUI App Shuts Down or quits
       * @return void
       */
      /*       virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                              const asf::core::ServiceStateChange& stateChange); */
   protected:
      // Reset To Factory ///////////
      ////////////////////// virtual methods from iDefSetServiceBase to handle restore factory settings //////////////////////////////////////////////////////////////////
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if 0
      ////////////////////////////////////////////////////////General Access Methods////////////////////////////////////////////////////////////////////////////////////////////////////////////
      unsigned int updateTestModeData(std::string _headerString1, std::string _headerString2, std::string _headerString3, std::string _headerString4, std::string _headerString5);
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
   private:

      ////////////////////////////////////////////// Courier Message Mapping with Traces classes ///////////////////////////////////////////////////////////////////////////////////
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SDS_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_pListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_pSdsAdapterProvider)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_DELEGATE_TO_OBJ(_pHMIModelComponent)
      COURIER_MSG_DELEGATE_TO_OBJ(_pVehicleSrvClient)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_MAP_DELEGATE_END()
      //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      ::boost::shared_ptr<SPM_CORE_FI::SPM_CORE_FIProxy> _spmCoreServiceProxy;
      ::boost::shared_ptr<sds_gui_fi::SdsGuiService::SdsGuiServiceProxy> _sdsGuiServiceProxy;
      SdsAdapterProvider* _pSdsAdapterProvider;
      SdsAdapterRequestor* _pSdsAdapterRequestor; //Reset Solve
      GuiUpdater* _pGuiUpdater;
      HMIModelComponent* _pHMIModelComponent;
      ListHandler* _pListHandler;
      VehicleSrvClient* _pVehicleSrvClient;

      std::vector<asf::core::ServiceAvailableIF*> _proxyAvailabilityObservers;
      void addServiceAvailableObservers(asf::core::ServiceAvailableIF* obs);
      void registerServiceAvailableObservers();
      DefSetServiceBase* _mdefSetServiceBase;
      bool bSdsRestoreFactorySetting();
      void registerObservers();
};


}
}


#endif
