/**************************************************************************//**
 * \file       SdsDefines.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/


#ifndef SDSDEFINES_HEADER
#define SDSDEFINES_HEADER

namespace App {
namespace Core {


#define MAX_LIST_ITEMS_LAYOUT_N 10
#define MAX_LIST_ITEMS_LAYOUT_R 4
#define MAX_LIST_ITEMS_LAYOUT_R2 3
#define MAX_LIST_ITEMS_VL_SUBCMD 7
#define MAX_LIST_ITEMS_LAYOUT_C 2
#define MAX_LIST_ITEMS_LAYOUT_L 5
#define MAX_LIST_ITEMS_LAYOUT_I 5
#define MAX_LIST_ITEMS_LAYOUT_M 5
#define MAX_LIST_ITEMS_LAYOUT_L2 5
#define MAX_LIST_ITEMS_LAYOUT_L3 5
#define MAX_LIST_ITEMS_LAYOUT_MAIL 4
#define MAX_LIST_ITEMS_LAYOUT_S 3
#define MAX_LIST_ITEMS_SDS_Settings_Main 6
#define MAX_LIST_ITEMS_LAYOUT_E 5
#define MAX_LIST_ITEMS_LAYOUT_T 3
#define MAX_LIST_ITEMS_LAYOUT_O 1
#define MAX_LIST_ITEMS_LAYOUT_Q 5
#define MAX_LIST_ITEMS_LAYOUT_B 5
#define MAX_LIST_ITEMS_LAYOUT_TileList 10
#define MAX_LIST_ITEMS_TAB_LAYOUT_B 4
#define KMPH_TO_MILES_CONVERSION_VALUE 161
#define MAX_VEHICLE_SPEED_IN_MILES 5
#define MAX_VEHICLE_SPEED_SMS_HEADER_VISIBILITY 65535

#define DELETE_AND_PURGE(member)    if(member) delete member; member = NULL
#define PURGE(member)    member = NULL
#define BEEPTYPE_ROGER 2


#define TAGNAME_CMD "cmd"
#define TAGNAME_CMD_SIZE 3
#define TAGNAME_TABCMD "tab_cmd"
#define TAGNAME_TABCMD_SIZE 7
#define TAGNAME_DESC "descr"
#define TAGNAME_DESC_SIZE 5
#define TAGNAME_SUBCMD "subCmd"
#define TAGNAME_SUBCMD_SIZE 6
#define TAGNAME_HELP "help"
#define TAGNAME_HELP_SIZE 4
#define TAGNAME_INFO "info"
#define TAGNAME_INFO_SIZE 4
#define TAGNAME_MESSAGE "msg"
#define TAGNAME_MESSAGE_SIZE 3
#define TAGNAME_TIME "time"
#define TAGNAME_TIME_SIZE 4
#define TAGNAME_ICON "icon"
#define TAGNAME_ICON_SIZE 4
#define TAGNAME_PHONE_ICON "calltype"
#define TAGNAME_PHONE_ICON_SIZE 8

#define TAGNAME_DIST "dist"
#define TAGNAME_DIST_SIZE 4
#define TAGNAME_DIR "dir"
#define TAGNAME_DIR_SIZE 3
#define TAGNAME_PRICE "price"
#define TAGNAME_PRICE_SIZE 5
#define TAGNAME_PRICE_AGE "priceU"
#define TAGNAME_PRICE_AGE_SIZE 6

#define MAX_MIC_LEVEL 14
#define MAX_MIC_LEVEL_RENAULT 11
#define MSG_SMS_SUPPORT          ((uint16)0x0001u)
#define MSG_SMS_SEND_SUPPORT     ((uint16)0x0001u)
#define SPEECH_RATE_MINIMUM_VALUE 90
#define SPEECH_RATE_MAXIMUM_VALUE 110
#define SPEECH_RATE_DEFAULT_VALUE 100
#define SETTINGS_VOLUME_DEFAULT_VALUE 16
#define SETTINGS_VOLUME_MAXIMUM_VALUE 40
#define SETTINGS_VOLUME_MINIMUM_VALUE 5
#define SETTINGS_VOLUME_DEFAULT_TEXT "16"
#define SETTINGS_CURRENT_ACTIVE_SOURCE 41
#define SPEECH_SOURCE 38
#define NAVI_SOURCE 37
#define SETTINGS_VOICEPREFERENCE_INDEX_0 0
#define SETTINGS_VOICEPREFERENCE_INDEX_1 1
#define SETTINGS_SLIDER_ON_TAP 3

#define SPEECH_RATE_STEP 5
#define SLIDER_RATE_STEP 1
#define INVALID_LIST_CURSOR_INDEX 50000
}


}

#endif //SSDDEFINES_HEADER
