/**************************************************************************//**
* \file       SdsAdapterProvider.h
*
* This file is part of the SDS HMI Application.
*
* \copyright  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*             The reproduction, distribution and utilization of this file
*             as well as the communication of its contents to others without
*             express authorization is prohibited. Offenders will be held
*             liable for the payment of damages. All rights reserved in the
*             event of the grant of a patent, utility model or design.
*****************************************************************************/

#ifndef SdsAdapterProvider_h
#define SdsAdapterProvider_h
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "App/Core/ListHandler/ListHandler.h"
#include "App/Core/SdsHallTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "sds_gui_fi/PopUpServiceProxy.h"
#include "sds_gui_fi/SettingsServiceProxy.h"
#include "sds_gui_fi/SdsPhoneServiceProxy.h"
#include "sds_gui_fi/SdsGuiService.h"
#include "sds_gui_fi/SdsGuiServiceProxy.h"
#include "sds_gui_fi/SdsFocusServiceProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchProxy.h" //AppSwitch
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h" // Context Switch Concept
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "SPM_CORE_FIProxy.h"
#else
#include "EnumData.h"
#include <string>
#endif

class StartupSync;

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class GuiUpdater;
class SdsAdapterRequestor;
class IHMIModelComponent;
class SdsAdapterProvider
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public sds_gui_fi::PopUpService::PopupRequestCloseCallbackIF
   , public sds_gui_fi::PopUpService::PopupRequestCallbackIF
   , public sds_gui_fi::PopUpService::ScreenIDCallbackIF
   , public sds_gui_fi::SdsGuiService::PttPressCallbackIF
   , public sds_gui_fi::SdsGuiService::ActivateAudioDeviceTagCallbackIF
   , public sds_gui_fi::SdsGuiService::ActivateAudioSourceCallbackIF
   , public bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::Sig_activate_deactivate_SpeechSessionCallbackIF
   , public bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::SpeechSession_activated_deactivatedCallbackIF
   , public ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusCallbackIF
   , public sds_gui_fi::SdsGuiService::EventCallbackIF
   , public sds_gui_fi::PopUpService::SdsStatusCallbackIF
   , public ::SPM_CORE_FI::HmiStateCallbackIF
#else
class SdsAdapterProvider
#endif
{
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      SdsAdapterProvider
      (

         GuiUpdater* pGuiUpdater,
         ListHandler* pListHandler,
         SdsAdapterRequestor* sdsAdapterRequestor
      );
#else
      SdsAdapterProvider();
#endif
      virtual ~SdsAdapterProvider();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);//TODO
      bool onCourierMessage(const HKStatusChangedNotifyMsg& oMsg);
      bool onCourierMessage(const StartVoiceRecognition& oMsg);
      //std::string Headerstring; //
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SDS_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(HKStatusChangedNotifyMsg)
      ON_COURIER_MESSAGE(StartVoiceRecognition)
      COURIER_MSG_MAP_END()
      //////////////////////////////////////////Callbacks from SDS_Adapter///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onPopupRequestSignal(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                        const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);

      virtual void onPopupRequestError(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                       const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestError >& error);

      ///Getting Responce after pressing PTT from Adapter/////////////////////
      virtual void onPttPressError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressError >& error);
      virtual void onPttPressResponse(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy, const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::PttPressResponse >& response);
      virtual void onEventError(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
                                const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::EventError >& error);

      virtual void onEventSignal(const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
                                 const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::EventSignal >& signal);
      void sendPttShortPress();
      bool isSDSActive();
      // Functions for PTT Triger //////////////////////////
      virtual void onSig_activate_deactivate_SpeechSessionError(const ::boost::shared_ptr< bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::ApplicationSwitchProxy >& proxy,
            const ::boost::shared_ptr<  bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::Sig_activate_deactivate_SpeechSessionError >& error);

      virtual void onSig_activate_deactivate_SpeechSessionSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::ApplicationSwitchProxy >& proxy,
            const ::boost::shared_ptr<  bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::Sig_activate_deactivate_SpeechSessionSignal >& signal);

      virtual void onSpeechSession_activated_deactivatedError(const ::boost::shared_ptr< bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::ApplicationSwitchProxy >& proxy,
            const ::boost::shared_ptr<  bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::SpeechSession_activated_deactivatedError >& error);

      virtual void onSpeechSession_activated_deactivatedResponse(const ::boost::shared_ptr< bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::ApplicationSwitchProxy >& proxy,
            const ::boost::shared_ptr<  bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::SpeechSession_activated_deactivatedResponse >& response);
      // Functions for PTT Triger //////////////////////////
      virtual void onPopupRequestCloseSignal(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                             const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestCloseSignal >& signal);

      virtual void onPopupRequestCloseError(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                            const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestCloseError >& error);

      virtual void onScreenIDError(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                   const ::boost::shared_ptr< sds_gui_fi::PopUpService::ScreenIDError >& error);

      virtual void onScreenIDUpdate(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                    const ::boost::shared_ptr< sds_gui_fi::PopUpService::ScreenIDUpdate >& update);
      // Context Switch Concept //////////////////////////////////////////////

      virtual void onActivateAudioDeviceTagError(
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ActivateAudioDeviceTagError >& error);

      virtual void onActivateAudioDeviceTagSignal(
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ActivateAudioDeviceTagSignal >& signal);

      virtual void onActivateAudioSourceError(
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ActivateAudioSourceError >& error);

      virtual void onActivateAudioSourceSignal(
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::SdsGuiServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_gui_fi::SdsGuiService::ActivateAudioSourceSignal >& signal);

      //HmiStateCallbackIF
      void onHmiStateError(
         const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
         const boost::shared_ptr< ::SPM_CORE_FI::HmiStateError >& /*error*/);
      void onHmiStateStatus(
         const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
         const boost::shared_ptr< ::SPM_CORE_FI::HmiStateStatus >& /*status*/);

      //RVCSignalStatusCallbackIF
      virtual void onRVCSignalStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
                                          const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusError >& error);
      virtual void onRVCSignalStatusUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& proxy,
                                           const ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::RVCSignalStatusUpdate >& update);

      virtual void onSdsStatusError(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                    const ::boost::shared_ptr< sds_gui_fi::PopUpService::SdsStatusError >& error);
      virtual void onSdsStatusUpdate(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopUpServiceProxy >& proxy,
                                     const ::boost::shared_ptr< sds_gui_fi::PopUpService::SdsStatusUpdate >& update);
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch
      //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   private:
      ::boost::shared_ptr<sds_gui_fi::PopUpService::PopUpServiceProxy> _popUpServiceProxy;
      ::boost::shared_ptr<bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::ApplicationSwitchProxy> _ApplicationSwitchProxy; //Applicationswitch proxy
      ::boost::shared_ptr<sds_gui_fi::SdsGuiService::SdsGuiServiceProxy> _sdsGuiServiceProxy; //PTT Implemantation

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoProxyClient;
      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy> _SPMSetproxy;
      unsigned int convertToTalkingHeadState(sds_gui_fi::PopUpService::SpeechInputState speechInputState);
      void processHeaderSpeakingIcon(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      unsigned int sdsSourceToHmiSource(sds_gui_fi::SdsGuiService::AudioSource audioSource);
      // ::boost::shared_ptr<sds_gui_fi::SettingsService::SettingsServiceProxy> _settingsServiceProxy;
      // ::boost::shared_ptr<sds_gui_fi::SdsPhoneService::SdsPhoneServiceProxy> _sdsPhoneServiceProxy;
      // ::boost::shared_ptr<sds_gui_fi::SdsFocusService::SdsFocusServiceProxy> _sdsFocusServiceProxy;
      /*       ::boost::shared_ptr<sds_gui_fi::PopUpService::PopUpServiceProxy> _popUpServiceProxy;
      		::boost::shared_ptr<sds_gui_fi::SettingsService::SettingsServiceProxy> _settingsServiceProxy;
      		::boost::shared_ptr<sds_gui_fi::SdsPhoneService::SdsPhoneServiceProxy> _sdsPhoneServiceProxy; */
      ListHandler* _pListhandler;
      GuiUpdater* _pGuiUpdater;

      unsigned int _talkingHeadState;
      unsigned int SRC_INVALID;
      unsigned int mPageNumber;
      float mNumberOfPages;
      bool mStatus;
      bool mPause;
      enum Pouup_State
      {
         INACTIVE,
         ACTIVE
      } _state;

      // Object of Signal Which is getting from Adapter
      sds_gui_fi::PopUpService::PopupRequestSignal _popupRequest;

      sds_gui_fi::SdsPhoneService::SmsContentSignal _smsContent;
      ::sds_gui_fi::PopUpService::SpeechInputState _sdsStatus;
      SdsAdapterRequestor* _pSdsAdapterRequestor;

      enSdsScreenLayoutType Current_LayoutType;
      enSdsScreenLayoutType Previous_LayoutType;

      void clearScreenData(std::string layoutType);
#endif
      enSdsScreenLayoutType getLayoutEnumValue(std::string layout) const;
      enSdsScreenLayoutType getLayoutEnumNavValue(std::string layout) const;
      enSdsScreenLayoutType getLayoutEnumAudioValue(std::string layout) const;
      enSdsScreenLayoutType getLayoutEnumPhoneValue(std::string layout) const;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      std::string getLayout(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal) const;
      void processListData(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      void processLayout(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      void processHeaderData(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      void processTextfieldData(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal, enSdsScreenLayoutType requestedLayoutType);
      void processGetCurrentPageNum(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      void listSliderDisplay(bool status);
      void processSliderData();
      // IHMIModelComponent* _pHMIModelComponent;
#else
      friend class SdsAdapterProvider_Test;
#endif
};


} // Namespace Core
} // Namespace App

#endif
