/**************************************************************************//**
 * \file       GuiUpdater.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef GuiUpdater_h
#define GuiUpdater_h

#include "App/Core/SdsHallTypes.h"
#include "Common/DataModel/ListRegistry.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/DataBindingItem.hpp"


#include "sds_gui_fi/PopUpServiceProxy.h"

using namespace Courier;

namespace App {
namespace Core {

class GuiUpdater
{
   public:
      GuiUpdater();
      virtual ~GuiUpdater();
      std::string toString(int value);
      //std::string Headerstring;
      // bool updateDynamicList(unsigned int listId);
      void updateHeaderSpeakingIconIndex(unsigned int index);

      void updateHeaderTextData(std::string headerString);
      void ClearHeaderTextData();

      void updatePopupTextfieldData(::std::vector< sds_gui_fi::PopUpService::TextField > processTextfieldvectorpass);
      void updatePopupNumberfieldData(const ::boost::shared_ptr< sds_gui_fi::PopUpService::PopupRequestSignal >& signal);
      void NextButtonEnableStatus(bool status);
      void PrevButtonEnableStatus(bool status);
      void updatePageNumber(::std::string pageNumberCount);
      void listSliderDisplay(bool status);
      void TimedStepMovementSlider(float index, float Slidervalue);
      void bargeInEnableStatus(bool status);
   private:

      DataItemContainer<SRStatusDataBindingSource> _SRStatusData;

      DataItemContainer<PopUpTextDataBindingSource> _PopUpTextData;
      DataItemContainer<PopUpSingleTextDataBindingSource> _PopUpSingleText;
      DataItemContainer<PopUpMultipleTextDataBindingSource> _PopUpMultipleText;

      DataItemContainer<ListSliderDisplayDataBindingSource> _ListSliderDisplay;
      DataItemContainer<MediaDeviceConnectedStatusDataBindingSource> _MediaDeviceConnectedStatus; //TODO
      DataItemContainer<NextButtonActiveStatusDataBindingSource> _NextButtonActiveStatus;
      DataItemContainer<PrevButtonActiveStatusDataBindingSource> _PrevButtonActiveStatus;
      DataItemContainer<ListPageNumberDataBindingSource> _listPageNumberData;
      DataItemContainer<TimedStepMovementSliderDataBindingSource>_TimedStepMovementSlider;
      DataItemContainer<BargeInEnableStatusDataBindingSource>_BargeInEnableStatus;
};


} // namespace Core
} // namespace App

#endif /* GuiUpdater_h */
