/**************************************************************************//**
 * \file       ListHandler.h
 *
 * This file is part of the SDS HMI Application.
 *
 * \copyright  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef ListHandler_h
#define ListHandler_h

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "App/Core/SdsHallTypes.h"
#include "Common/DataModel/ListRegistry.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"

#define AUDIOMAIN_LISTSIZE 8
#define STARTINDEX 0
#define LISTROWWITHCOL 3
#define COL_INDEX 5
#define TUNERMAIN_LISTROWWITHCOL 2
#define GLOMAIN_LISTROWWITHCOL 6
#define ENABLE 1
#define DISABLE 0

using namespace Courier;
#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "asf/core/Types.h"
#include "utest/stubs/EnumData.h"
#include "gtest/gtest_prod.h"
#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class GuiUpdater;
class VRSettingsHandler;
class SdsAdapterRequestor;
class EncoderFocusHandler;

class ListHandler : public ListImplementation
#else
class ListHandler
#endif
{
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      ListHandler(GuiUpdater* guiUpdater, SdsAdapterRequestor* sdsAdapterRequestor);
      void setShowScreenLayout(enSdsScreenLayoutType screenLayout, enSdsScreenLayoutType Previous_LayoutType);
#else
      ListHandler();
#endif
      virtual ~ListHandler();
      void setCurrentLayout(enSdsScreenLayoutType screenLayout, enSdsScreenLayoutType Previous_LayoutType);
      unsigned int getCurrentListType()const;//UpDated for INF4CV NDW5KOR
      enSdsScreenLayoutType getCurrentLayout();

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      std::vector <SelectableListItem>& getVectCmdString();

      bool updateDynamicList(unsigned int listId);

      void closeVRScreen(enSdsScreenLayoutType Previous_LayoutType);
      void setListsize(unsigned int pageNumber);
      void setCurrentSliderValue(float sliderValue);
#endif
   private:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      virtual bool onCourierMessage(const Courier::UpdateModelMsg& oMsg);
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg/* const ListDataInfo& _ListInfo */);

      tSharedPtrDataProvider getSDSList(int32_t List_StartIndex, uint32_t list_id);
      void getSDSAudioMain(ListDataProviderBuilder& listBuilder);
      void getSDSTunerMain(ListDataProviderBuilder& listBuilder);
      tSharedPtrDataProvider getListItemsLayoutNAV(uint32_t list_id);
      void showScreenLayout(enSdsScreenLayoutType screenLayout);
      tSharedPtrDataProvider getListItemsLayoutN(int32_t List_StartIndex, uint32_t list_id);
      tSharedPtrDataProvider getSDSAudioList(uint32_t list_id);
      tSharedPtrDataProvider getSDS_CV_S_PHOList(uint32_t list_id);
      tSharedPtrDataProvider getSDS_CV_PHOList(uint32_t list_id);
      tSharedPtrDataProvider getSDS_CV_S_AUDList(uint32_t list_id);
      tSharedPtrDataProvider getNAVPreviousDestinationList(uint32_t list_id);
      tSharedPtrDataProvider getSDSTunerList(uint32_t list_id);
      tSharedPtrDataProvider getNAVConfirmStopList(uint32_t list_id);
      void initializeMembers();
      unsigned int mPageNum;
      Float mCurrentSliderValue;
      Float mPrevSliderValue;

      ////////////////////////////////////////////// Courier Message Mapping with Traces classes ///////////////////////////////////////////////////////////////////////////////////
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SDS_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()
      GuiUpdater* _pGuiUpdater;
      SdsAdapterRequestor* _pSdsAdapterRequestor;
      std::vector <SelectableListItem> vecCommandString;
      DataItemContainer<PodcastAvailableStatusDataBindingSource> _PodcastAvailableStatus;
      DataItemContainer<SongAvailableStatusDataBindingSource> _SongAvailableStatus;
      DataItemContainer<AddressEntryStatusDataBindingSource> _AddressEntryStatus;
      DataItemContainer<NavigationAvailableStatusDataBindingSource> _NavigationAvailableStatus;
      DataItemContainer<RouteInProgressStatusDataBindingSource> _RouteInProgressStatus;
      DataItemContainer<TimedStepMovementSliderDataBindingSource>_TimedStepMovementSlider;
#endif
      enSdsScreenLayoutType _currentLayout;
      enSdsScreenLayoutType _PreviousLayoutType;
};


}//namespace App
}//namespace Core
#endif /* ListHandler_h */
