/**************************************************************************//**
* \file       ListHandler.cpp
*
* This file is part of the SDS HMI Application.
*
* \copyright  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*             The reproduction, distribution and utilization of this file
*             as well as the communication of its contents to others without
*             express authorization is prohibited. Offenders will be held
*             liable for the payment of damages. All rights reserved in the
*             event of the grant of a patent, utility model or design.
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "gui_std_if.h"
#include "App/Core/SdsAdapter/Proxy/requestor/SdsAdapterRequestor.h"
#include "App/Core/SdsAdapter/GuiUpdater.h"
#include "hmi_trace_if.h"
#include "App/Core/SdsAdapter/Proxy/provider/SdsAdapterProvider.h"
#include "CgiExtensions/ImageLoader.h"
#include "App/Core/SdsDefines.h"
#include "App/Core/SdsHallTypes.h"
#include <iostream>
using namespace std;
#endif

#include "ListHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SDS_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SDS
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SDS_"
#define ETG_I_FILE_PREFIX                 App::Core::ListHandler::
#include "trcGenProj/Header/ListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
ListHandler::ListHandler(GuiUpdater* guiUpdater, SdsAdapterRequestor* sdsAdapterRequestor)
   : _pGuiUpdater(guiUpdater), _pSdsAdapterRequestor(sdsAdapterRequestor),
     _currentLayout(SDS_LAYOUT_INVALID),
     _PreviousLayoutType(SDS_LAYOUT_INVALID),
     mPageNum(0),
     mCurrentSliderValue(0),
     mPrevSliderValue(0)
#else
ListHandler::ListHandler()
#endif
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   //#include "Common/ListHandler/LockoutRestrictionData.h"
   /////////////////////////////////////////////////Resgister SDS HMI List ID's////////////////////////////////////////////////////////////////////////////
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_GLO, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_Best_Match_List, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_NAV_T2, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_PHO, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_NAV_T4, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_AUD, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_LAYOUT_CV_NAV_T5, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_CV_S_AUD, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_LAYOUT_CV_S_PHO, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_LAYOUT_CV_S_NAV, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SDS_LAYOUT_CV_TUNER, this);
   ///////////////////Member Initializations/////////////////////////////////////////////////////////////////////////////////////////////////////////////
   initializeMembers();
#endif
}


ListHandler::~ListHandler()
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_GLO);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_Best_Match_List);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_NAV_T2);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_PHO);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_NAV_T4);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_AUD);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_CV_S_AUD);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_LAYOUT_CV_S_NAV);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_LAYOUT_CV_NAV_T5);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_LAYOUT_CV_S_PHO);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SDS_LAYOUT_CV_TUNER);
   DELETE_AND_PURGE(_pGuiUpdater);
   DELETE_AND_PURGE(_pSdsAdapterRequestor);
#endif
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
tSharedPtrDataProvider ListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg/* const ListDataInfo& listDataInfo */)
{
   uint32_t list_id = oMsg.GetListId();
   int32_t	List_StartIndex = oMsg.GetStartIndex();
   int32_t	Window_Element_Size = oMsg.GetWindowElementSize();
   tSharedPtrDataProvider ptr = Candera::MemoryManagement::SharedPointer<ListDataProvider>(NULL);

   unsigned int listType = getCurrentListType();
   ETG_TRACE_USR4(("ListHandler list_id %d", list_id));
   ETG_TRACE_USR4(("ListHandler List_StartIndex %d", List_StartIndex));
   ETG_TRACE_USR4(("ListHandler Window_Element_Size %d", Window_Element_Size));
   ETG_TRACE_USR4(("ListHandler listType %d", listType));

   for (int i = 0; i < vecCommandString.size(); i++)
   {
      ETG_TRACE_USR4(("ListHandler:: List Data: %s", vecCommandString.at(i).text.c_str()));
   }

   if (oMsg.GetListId() == listType)
   {
      switch (oMsg.GetListId())
      {
         case LIST_ID_SDS_CV_GLO:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_GLO"));
            ptr = getSDSList(List_StartIndex, list_id);
         }
         break;
         case LIST_ID_SDS_CV_AUD:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_AUD"));
            ptr = getSDSAudioList(list_id);
         }
         break;
         case LIST_ID_SDS_CV_NAV_T4:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_NAV_T4"));
            ETG_TRACE_USR4(("ListHandler LIST_ID_SDS_CV_NAV_T4 size ===== %d", Window_Element_Size));
            ptr = getListItemsLayoutN(List_StartIndex, list_id);
         }
         break;
         case LIST_ID_SDS_LAYOUT_CV_NAV_T5:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_LAYOUT_CV_NAV_T5"));
            ETG_TRACE_USR4(("ListHandler LIST_ID_SDS_LAYOUT_CV_NAV_T5 size ===== %d", Window_Element_Size));
            ptr = getListItemsLayoutNAV(list_id);
         }
         break;
         case LIST_ID_SDS_LAYOUT_CV_S_PHO:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_LAYOUT_CV_S_PHO"));
            ptr = getSDS_CV_S_PHOList(list_id);
         }
         break;
         case LIST_ID_SDS_CV_NAV_T2:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_NAV_T2"));
            ptr = getNAVConfirmStopList(list_id);
         }
         break;
         case LIST_ID_SDS_CV_PHO:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_PHO"));
            ptr = getSDS_CV_PHOList(list_id);
         }
         break;
         case LIST_ID_SDS_LAYOUT_CV_S_NAV:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_S_NAV"));
            ptr = getNAVPreviousDestinationList(list_id);
         }
         break;
         case LIST_ID_SDS_CV_S_AUD:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_CV_S_AUD"));
            ptr = getSDS_CV_S_AUDList(list_id);
         }
         break;
         case LIST_ID_SDS_LAYOUT_CV_TUNER:
         {
            ETG_TRACE_USR4((" Case LIST_ID_SDS_LAYOUT_CV_TUNER"));
            ptr = getSDSTunerList(list_id);
         }
         break;
         default:
         {
            tSharedPtrDataProvider();
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_USR4((" List_ID's are not same "));
   }
   ETG_TRACE_USR4((" ListHandler getListDataProvider Finished"));
   return ptr;
}


void ListHandler::getSDSAudioMain(ListDataProviderBuilder& listBuilder)
{
   unsigned int index;
   SongAvailableStatusData data;
   PodcastAvailableStatusData status;
   for (index = STARTINDEX; index < LISTROWWITHCOL; index++)
   {
      if (vecCommandString.at(index).isSelectable == DISABLE)
      {
         data.misEnable = DISABLE;
      }
      else
      {
         data.misEnable = ENABLE;
      }
      if (vecCommandString.at(index + COL_INDEX).isSelectable == DISABLE)
      {
         status.misEnable = DISABLE;
      }
      else
      {
         status.misEnable = ENABLE;
      }
      ETG_TRACE_USR4(("ListHandler:: getSDSAudioList= %s", vecCommandString.at(index).text.c_str()));
      ETG_TRACE_USR4(("ListHandler:: getSDSAudioList= %s", vecCommandString.at(index + COL_INDEX).text.c_str()));
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_AUD")
      .AddData(vecCommandString.at(index).text.c_str())
      .AddDataBindingUpdater<SongAvailableStatusDataBindingSource>(data)
      .AddData(vecCommandString.at(index + COL_INDEX).text.c_str())
      .AddDataBindingUpdater<PodcastAvailableStatusDataBindingSource>(status);
   }
   for (index = LISTROWWITHCOL; index < COL_INDEX; index++)
   {
      if (vecCommandString.at(index).isSelectable == DISABLE)
      {
         data.misEnable = DISABLE;
      }
      else
      {
         data.misEnable = ENABLE;
      }
      ETG_TRACE_USR4(("ListHandler::getSDSAudioList() - currentLayout getSDSAudioList= %s", vecCommandString.at(index).text.c_str()));
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_AUD_1")
      .AddData(vecCommandString.at(index).text.c_str())
      .AddDataBindingUpdater<SongAvailableStatusDataBindingSource>(data);
   }
}


void ListHandler::getSDSTunerMain(ListDataProviderBuilder& listBuilder)
{
   unsigned int index;
   SongAvailableStatusData data;
   PodcastAvailableStatusData status;
   for (index = STARTINDEX; index < TUNERMAIN_LISTROWWITHCOL; index++)
   {
      if (vecCommandString.at(index).isSelectable == DISABLE)
      {
         data.misEnable = DISABLE;
      }
      else
      {
         data.misEnable = ENABLE;
      }
      if (vecCommandString.at(index + COL_INDEX).isSelectable == DISABLE)
      {
         status.misEnable = DISABLE;
      }
      else
      {
         status.misEnable = ENABLE;
      }
      ETG_TRACE_USR4(("ListHandler::getSDSTunerList() - currentLayout getSDSAudioList= %s", vecCommandString.at(index).text.c_str()));
      ETG_TRACE_USR4(("ListHandler::getSDSTunerList() - currentLayout getSDSAudioList= %s", vecCommandString.at(index + 5).text.c_str()));
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_AUD")
      .AddData(vecCommandString.at(index).text.c_str())
      .AddDataBindingUpdater<SongAvailableStatusDataBindingSource>(data)
      .AddData(vecCommandString.at(index + COL_INDEX).text.c_str())
      .AddDataBindingUpdater<PodcastAvailableStatusDataBindingSource>(status);
   }
   for (index = TUNERMAIN_LISTROWWITHCOL; index < COL_INDEX; index++)
   {
      if (vecCommandString.at(index).isSelectable == DISABLE)
      {
         data.misEnable = DISABLE;
      }
      else
      {
         data.misEnable = ENABLE;
      }
      ETG_TRACE_USR4(("ListHandler::getSDSAudioList() - currentLayout getSDSAudioList= %s", vecCommandString.at(index).text.c_str()));
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_AUD_1")
      .AddData(vecCommandString.at(index).text.c_str())
      .AddDataBindingUpdater<SongAvailableStatusDataBindingSource>(data);
   }
}


// Filling list items for SR_AUD_Main screen
tSharedPtrDataProvider ListHandler::getSDSAudioList(uint32_t list_id)
{
   ETG_TRACE_USR4(("ListHandler::getSDSAudioList()"));

   ListDataProviderBuilder listBuilder(list_id);
   //Grayout changes.

   if (vecCommandString.size() == AUDIOMAIN_LISTSIZE)
   {
      getSDSAudioMain(listBuilder);
   }
   else
   {
      getSDSTunerMain(listBuilder);
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List getSDSAudioList POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List getSDSAudioList Not POSTED"));
   }
   return dataProvider;
}


// Filling list items for Tuner screen(CV_TUNER).
tSharedPtrDataProvider ListHandler::getSDSTunerList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);

   ETG_TRACE_USR4(("ListHandler::getSDSTunerList() - currentLayout LIST_ID_SDS_LAYOUT_CV_TUNER"));
   for (unsigned int i = 0; (i < vecCommandString.size()); i++)
   {
      listBuilder.AddItem(i, 0UL, "Lst_SDS_LAYOUT_CV_TUNER")
      .AddData(vecCommandString.at(i).text.c_str());
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List Lst_SDS_LAYOUT_CV_TUNER POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List Lst_SDS_LAYOUT_CV_TUNER Not POSTED"));
   }
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getListItemsLayoutN(int32_t List_StartIndex, uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);

   ETG_TRACE_USR4(("ListHandler::getListforLayoutN() - currentLayout LIST_ID_SDS_CV_NAV_T4"));
   for (unsigned int i = 0; (i < vecCommandString.size()); i++)
   {
      listBuilder.AddItem(i, 0UL, "Lst_SDS_LAYOUT_CV_NAV_T4")
      .AddData(vecCommandString.at(i).text.c_str());
      //.AddData("Janardhana");
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_SDS_CV_NAV_T4 POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_SDS_CV_NAV_T4 Not POSTED"));
   }
   //dataProvider->setCacheOnOff(false);
   return dataProvider;
}


// Filling list items for SR_NAV_Main screen
tSharedPtrDataProvider ListHandler::getListItemsLayoutNAV(uint32_t list_id)
{
   AddressEntryStatusData status;
   ListDataProviderBuilder listBuilder(list_id);

   ETG_TRACE_USR4(("ListHandler::getListItemsLayoutNAV() - currentLayout LAYOUT_CV_NAV_T5"));
   for (unsigned int i = STARTINDEX; (i < vecCommandString.size()); i++)
   {
      if (vecCommandString.at(i).isSelectable == DISABLE)
      {
         status.misVisible = DISABLE;
      }
      else
      {
         status.misVisible = ENABLE;
      }
      listBuilder.AddItem(i, 0UL, "Lst_SDS_LAYOUT_CV_NAV_T5")
      .AddData(vecCommandString.at(i).text.c_str())
      .AddDataBindingUpdater<AddressEntryStatusDataBindingSource>(status);
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::getListItemsLayoutNAV ListDateProviderResMsg for LAYOUT_CV_NAV_T5 POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::getListItemsLayoutNAV, dataProvider is NULL"));
   }
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getSDS_CV_S_PHOList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);
   unsigned int index;
   ETG_TRACE_USR4(("ListHandler::getPHOSelectPhoneNumberList() - currentLayout LAYOUT_CV_S_PHO: %d", vecCommandString.size()));

   //TODO
   for (index = 0; index < vecCommandString.size(); index++)
   {
      listBuilder.AddItem(index, 0UL, "Lst_LAYOUT_CV_S_PHO")
      .AddData(vecCommandString.at(index).text.c_str());
      //.AddData(vecCommandString.at(index).isSelectable);
      //.AddData(vecCommandString.at(index).isSelectable);
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_PHO POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_PHO Not POSTED"));
   }
   //dataProvider->setCacheOnOff(false);
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getSDS_CV_S_AUDList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);
   unsigned int index;
   ETG_TRACE_USR4(("ListHandler::getSDS_CV_S_AUDList() - currentLayout LAYOUT_CV_S_AUD: %d", vecCommandString.size()));
   for (index = 0; index < vecCommandString.size(); index++)
   {
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_S_AUD")
      .AddData(vecCommandString.at(index).text.c_str());
   }
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_AUD POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_AUD Not POSTED"));
   }
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getNAVPreviousDestinationList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);
   unsigned int index;
   ETG_TRACE_USR4(("ListHandler::getNAVPreviousDestinationList() - currentLayout LAYOUT_CV_S_NAV: %d", vecCommandString.size()));

   //TODO
   for (index = 0; index < vecCommandString.size(); index++)
   {
      listBuilder.AddItem(index, 0UL, "Lst_LAYOUT_CV_S_NAV")
      .AddData(vecCommandString.at(index).text.c_str());
      //.AddData(vecCommandString.at(index).isSelectable);
      //.AddData(vecCommandString.at(index).isSelectable);
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_NAV POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_S_NAV Not POSTED"));
   }
   //dataProvider->setCacheOnOff(false);
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getNAVConfirmStopList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);
   unsigned int index;
   ETG_TRACE_USR4(("ListHandler::getNAVConfirmStopList() - currentLayout LAYOUT_CV_NAV_T2: %d", vecCommandString.size()));

   for (index = 0; index < vecCommandString.size(); index++)
   {
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_NAV_T2")
      .AddData(vecCommandString.at(index).text.c_str());
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_NAV_T2 POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_NAV_T2 Not POSTED"));
   }
   //dataProvider->setCacheOnOff(false);
   return dataProvider;
}


tSharedPtrDataProvider ListHandler::getSDS_CV_PHOList(uint32_t list_id)
{
   ListDataProviderBuilder listBuilder(list_id);
   unsigned int index;
   ETG_TRACE_USR4(("ListHandler::getPHOEnterContactList() - currentLayout LAYOUT_CV_PHO: %d", vecCommandString.size()));

   //TODO
   for (index = 0; index < vecCommandString.size(); index++)
   {
      ETG_TRACE_USR4(("ListHandler::getPHOEnterContactList() %d", index));
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_PHO")
      .AddData(vecCommandString.at(index).text.c_str());
      //.AddData(vecCommandString.at(index).isSelectable);
      //.AddData(vecCommandString.at(index).isSelectable);
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_PHO POSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_LAYOUT_CV_PHO Not POSTED"));
   }
   //dataProvider->setCacheOnOff(false);
   return dataProvider;
}


/* ***********************************************************
* Function 		: onCourierMessage
* Description 	:
* Parameters 	: ListDateProviderReqMsg &oMsg
* Return value	: TRUE if it consumes the message else FALSE
* ***********************************************************/
bool ListHandler::onCourierMessage(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("ListHandler:: onCourierMessage updateList  "));
   return ListRegistry::s_getInstance().updateList(oMsg.GetListId(), oMsg.GetStartIndex(), oMsg.GetWindowElementSize());
}


/////////////////////////////////////////////////////////////////////////////
bool ListHandler::updateDynamicList(unsigned int list_Id)
{
   ETG_TRACE_USR4(("List ID - %d is updated", list_Id));
   ETG_TRACE_USR4(("ListHandler::updateDynamicList"));
   if ((ListRegistry::s_getInstance().updateList(list_Id)) == true)
   {
      ETG_TRACE_USR4(("List ID - %d is updated", list_Id));
      return true;
   }
   else
   {
      ETG_TRACE_USR4(("ERROR::List ID - %d Update Failed", list_Id));
      return false;
   }
}


/* ***********************************************************
* Function 		: ButtonReactionMsg
* Description 	: gets called whenever there is a list item selection
* Parameters 	: oMsg
* Return value	: void
* ***********************************************************/
bool ListHandler::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   ETG_TRACE_USR4(("ListHandler::onCourierMessage(ButtonReactionMsg)"));
   ListProviderEventInfo info;
   if (oMsg.GetEnReaction() == enRelease)
   {
      ETG_TRACE_USR4(("ListHandler::ButtonReactionMsg enRelease "));

      if ((oMsg.GetSender() == Courier::Identifier("Next_Button_Text_Image_Icon/ButtonWidget")))
      {
         ETG_TRACE_USR4(("BtnNextPage Pressed"));
         if (_pSdsAdapterRequestor)
         {
            _pSdsAdapterRequestor->requestNextPage();
            return true;
         }
      }
      if ((oMsg.GetSender() == Courier::Identifier("Previous_Button_Text_Image_Icon/ButtonWidget")))
      {
         ETG_TRACE_USR4(("BtnPrevPage Pressed"));
         if (_pSdsAdapterRequestor)
         {
            _pSdsAdapterRequestor->requestPrevPage();
            return true;
         }
      }
      if ((oMsg.GetSender() == Courier::Identifier("Speak_Icon/ButtonWidget")))
      {
         ETG_TRACE_USR4(("Speak_Icon Pressed"));
         if (_pSdsAdapterRequestor)
         {
            _pSdsAdapterRequestor->sendPttShortPress();
            return true;
         }
      }
      if ((oMsg.GetSender() == Courier::Identifier("Cancel_Button/ButtonWidget")))
      {
         ETG_TRACE_USR4(("Cancel_Button Pressed"));
         if (_pSdsAdapterRequestor)
         {
            _pSdsAdapterRequestor->sendStopSession();
            return true;
         }
      }
   }
   if (ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info) == true  && oMsg.GetEnReaction() == enRelease)
   {
      ETG_TRACE_USR4(("ListHandler::ButtonReactionMsg listId:%d", info.getListId()));
      ETG_TRACE_USR4(("ListHandler::ButtonReactionMsg getHdlRow:%d", info.getHdlRow()));
      if (_pSdsAdapterRequestor)
      {
         _pSdsAdapterRequestor->listItemSelected(info.getHdlRow());
         return true;
      }
   }
   return false;
}


bool ListHandler::onCourierMessage(const Courier::UpdateModelMsg& oMsg)
{
   bool msgConsumed;
   int GetNumberOfSteps = 0;
   ETG_TRACE_USR4(("ListHandler::OnCourierMessage UpdateModelMsg()"));
   for (UInt32 iBindingData = 0; iBindingData < oMsg.RequestCount(); ++iBindingData)
   {
      Request request(oMsg.GetRequest(iBindingData));
      switch (request.BindingSourceKey())
      {
         case ItemKey::TimedStepMovementSliderItem:
            _TimedStepMovementSlider.SetValue(request.ItemKey(), request.GetItemValue());
            //_TimedStepMovementSlider.MarkItemModified(ItemKey::TimedStepMovementSliderItem);
            //_TimedStepMovementSlider.SendUpdate();
            mPrevSliderValue = mCurrentSliderValue;
            mCurrentSliderValue = (*_TimedStepMovementSlider).mCurrentValue;
            GetNumberOfSteps = (*_TimedStepMovementSlider).mStepSize;
            ETG_TRACE_USR4(("ListHandler::OnCourierMessage UpdateModelMsg- (mStepSize)= %d %d", GetNumberOfSteps, mCurrentSliderValue));
            msgConsumed = true;
            break;
      }
   }

   ETG_TRACE_USR4(("ListHandler::OnCourierMessage UpdateModelMsg()= %d ,%d", mCurrentSliderValue, mPrevSliderValue));
   if (mPrevSliderValue < mCurrentSliderValue)
   {
      ETG_TRACE_USR4(("ListHandler::onCourierMessage _Going to nextpage"));
      _pSdsAdapterRequestor->requestNextPage();
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::onCourierMessage _Going to prevpage"));
      _pSdsAdapterRequestor->requestPrevPage();
   }
   return msgConsumed;

//return false;
}


tSharedPtrDataProvider ListHandler::getSDSList(int32_t List_StartIndex, uint32_t list_id)
{
   unsigned int index;

   NavigationAvailableStatusData Navigationstatus;
   RouteInProgressStatusData Routestatus;

   ListDataProviderBuilder listBuilder(list_id);
   ETG_TRACE_USR4(("ListHandler::getSDSList() - String_Size: %d", vecCommandString.size()));

   for (index = STARTINDEX; index < LISTROWWITHCOL; index++)  //TODO
   {
      if (vecCommandString.at(index).isSelectable == DISABLE)
      {
         Navigationstatus.misVisible = DISABLE;
      }
      else
      {
         Navigationstatus.misVisible = ENABLE;
      }
      listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_GLO")
      .AddData(vecCommandString.at(index).text.c_str())
      .AddDataBindingUpdater<NavigationAvailableStatusDataBindingSource>(Navigationstatus);
   }

//Checking list size to avoid apphmi crash in case of DA variant. Since navi commands are not required in list, no of list elements is only 3.
   if ((vecCommandString.size()) > 3)
   {
      for (index = LISTROWWITHCOL; index < COL_INDEX; index++)  //TODO
      {
         if (vecCommandString.at(index).isSelectable == DISABLE)
         {
            Navigationstatus.misVisible = DISABLE;
         }
         else
         {
            Navigationstatus.misVisible = ENABLE;
         }
         if (vecCommandString.at(index + LISTROWWITHCOL).isSelectable == DISABLE)
         {
            Routestatus.misVisible = DISABLE;
         }
         else
         {
            Routestatus.misVisible = ENABLE;
         }
         listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_GLO_1")
         .AddData(vecCommandString.at(index).text.c_str())
         .AddDataBindingUpdater<NavigationAvailableStatusDataBindingSource>(Navigationstatus)
         .AddData(vecCommandString.at(index + LISTROWWITHCOL).text.c_str())
         .AddDataBindingUpdater<RouteInProgressStatusDataBindingSource>(Routestatus);
      }
      for (index = COL_INDEX; index < GLOMAIN_LISTROWWITHCOL; index++)  //TODO
      {
         if (vecCommandString.at(index).isSelectable == DISABLE)
         {
            Navigationstatus.misVisible = DISABLE;
         }
         else
         {
            Navigationstatus.misVisible = ENABLE;
         }
         listBuilder.AddItem(index, 0UL, "Lst_SDS_LAYOUT_CV_GLO")
         .AddData(vecCommandString.at(index).text.c_str())
         .AddDataBindingUpdater<NavigationAvailableStatusDataBindingSource>(Navigationstatus);
      }
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if (dataProvider->listSize() > 0)
   {
      POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_SDS_CV_GLO POSTSTED"));
   }
   else
   {
      ETG_TRACE_USR4(("ListHandler::List LIST_ID_SDS_CV_GLO Not Posted "));
   }
   return dataProvider;
}


std::vector <SelectableListItem>& ListHandler::getVectCmdString()
{
   return vecCommandString;
}


void ListHandler::setShowScreenLayout(enSdsScreenLayoutType screenLayout, enSdsScreenLayoutType Previous_LayoutType)
{
   ETG_TRACE_USR4(("ListHandler setShowScreenLayout screenLayout = %d", screenLayout));

   setCurrentLayout(screenLayout, Previous_LayoutType);
   showScreenLayout(_currentLayout);
   closeVRScreen(Previous_LayoutType);
}


void ListHandler::showScreenLayout(enSdsScreenLayoutType screenLayout)
{
   ETG_TRACE_USR4(("POST_MSG( (COURIER_MESSAGE_NEW(ShowDomainScreen)()) )"));

   ETG_TRACE_USR4(("ScreenLayout = %d", screenLayout));
   switch (screenLayout)
   {
      case LAYOUT_CV_GLO:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_GLO_DisplayResp)()));//Updated for INF4CV
         ETG_TRACE_USR4(("Message Posted Sucessfull for GLO_Main"));
      }
      break;
      case LAYOUT_CV_NAV_T4:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_NAV_T4_DisplayResp)()));//Updated for Phone Screens
         ETG_TRACE_USR4(("Message Posted Sucessfull for NAV_EnterStreet"));
      }
      break;
      case LAYOUT_CV_AUD:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_AUD_DisplayResp)()));//Updated for SR_AUD_Main
         ETG_TRACE_USR4(("Message Posted Sucessfull for AUD_Main"));
      }
      break;
      case LAYOUT_CV_NAV_T5:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_NAV_T5Resp)()));//Updated for SpeechNAVMainResp
         ETG_TRACE_USR4(("Message Posted Sucessfull for SpeechNAVMainResp"));
      }
      break;
      case LAYOUT_CV_S_PHO:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_S_PHO_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_S_PHO"));
      }
      break;
      case LAYOUT_CV_NAV_T2:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_NAV_T2_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for NAV_ConfirmStop"));
      }
      break;
      case LAYOUT_CV_PHO:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_PHO_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_PHO"));
      }
      break;
      case LAYOUT_CV_PHO_T1:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_PHO_T1_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for SDS_LAYOUT_CV_PHO_T1_DisplayResp"));
      }
      break;
      case LAYOUT_CV_AUD_T1:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_AUD_T1_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for SDS_LAYOUT_CV_AUD_T1_DisplayResp"));
      }
      break;
      case LAYOUT_CV_S_NAV:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_S_NAV_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_S_NAV"));
      }
      break;
      case LAYOUT_CV_S_AUD:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_S_AUD_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_S_AUD"));
      }
      break;
      case LAYOUT_CV_E_PHO:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_E_PHO_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_E_PHO"));
      }
      break;
      case LAYOUT_CV_TUNER:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_TUNER_DisplayResp)()));//Updated for CV_TUNER
         ETG_TRACE_USR4(("Message Posted Sucessfull for LAYOUT_CV_TUNER"));
      }
      break;
      case LAYOUT_CV_NAV_T1:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_NAV_T1Resp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_NAV_T1"));
      }
      break;
      case LAYOUT_CV_NAV_CONF:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_NAV_CONF_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_NAV_CONF"));
      }
      break;
      case LAYOUT_CV_AUD_CONF:
      {
         POST_MSG((COURIER_MESSAGE_NEW(SDS_LAYOUT_CV_AUD_CONF_DisplayResp)()));
         ETG_TRACE_USR4(("Message posted successfull for LAYOUT_CV_AUD_CONF"));
      }
      break;
      default:
         ETG_TRACE_USR4(("No Message posted"));
         break;
   }
}


void ListHandler::closeVRScreen(enSdsScreenLayoutType Previous_LayoutType)
{
   ETG_TRACE_USR4(("SdsAdapterProvider::closeVRScreen"));

   ETG_TRACE_USR4(("Previous Layout = %d", Previous_LayoutType));
   ETG_TRACE_USR4(("Current Layout = %d", _currentLayout));

   ETG_TRACE_USR4(("Extern_PreviousLayout_SM = %d", Extern_PreviousLayout_SM));
   if (Previous_LayoutType != SDS_LAYOUT_INVALID)
   {
      Courier::Message* cpfoMsg = COURIER_MESSAGE_NEW(HidePreviousPopup)();
      if (cpfoMsg)
      {
         bool bRetVal = cpfoMsg->Post();
         ETG_TRACE_USR4(("ListHandler::HidePreviousPopup Post"));
         if (false == bRetVal)
         {
            ETG_TRACE_USR4(("ListHandler::HidePreviousPopup::Sending  Resp' = message failed"));
         }
      }
   }

   Previous_LayoutType = SDS_LAYOUT_INVALID;
   ETG_TRACE_USR4(("Previous_LayoutType = %d", Previous_LayoutType));
   ETG_TRACE_USR4(("Extern_PreviousLayout_SM = %d", Extern_PreviousLayout_SM));
}


void ListHandler::initializeMembers()
{
   SelectableListItem selItem = {"selItem", false};
   Candera::Color TextColor;
   vecCommandString = std::vector<SelectableListItem>(10, selItem);
}


void ListHandler::setListsize(unsigned int pageNumber)
{
   ETG_TRACE_USR4(("ListHandler::entered setliztsize"));
   mPageNum = pageNumber;
   if (mPageNum == 0)
   {
      mCurrentSliderValue = 0.0;
      mPrevSliderValue = 0.0;
   }
   ETG_TRACE_USR4(("ListHandler::setliztsize PageNum = %d", mPageNum));
}


void ListHandler::setCurrentSliderValue(float sliderValue)
{
   ETG_TRACE_USR4(("ListHandler::SetCurrentSliderValue= %d", sliderValue));
   mCurrentSliderValue = sliderValue;
}


#endif

void ListHandler::setCurrentLayout(enSdsScreenLayoutType screenLayout, enSdsScreenLayoutType Previous_LayoutType)
{
   _currentLayout = screenLayout;
   _PreviousLayoutType = Previous_LayoutType;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("ListHandler setShowScreenLayout _currentLayout = %d", _currentLayout));
   ETG_TRACE_USR4(("ListHandler setShowScreenLayout _PreviousLayoutType = %d", _PreviousLayoutType));
#endif
}


unsigned int ListHandler::getCurrentListType() const
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("ListHandler::getCurrentListType _currentLayout %d", _currentLayout));
#endif
   switch (_currentLayout)
   {
      case LAYOUT_CV_GLO:
         return LIST_ID_SDS_CV_GLO;
         break;
      case LAYOUT_CV_NAV_T4:
         return LIST_ID_SDS_CV_NAV_T4;
         break;
      case LAYOUT_CV_NAV_T2:
         return LIST_ID_SDS_CV_NAV_T2;
         break;
      case LAYOUT_CV_PHO:
         return LIST_ID_SDS_CV_PHO;
         break;
      case LAYOUT_CV_AUD:
         return LIST_ID_SDS_CV_AUD;
         break;
      case LAYOUT_CV_NAV_T5:
         return LIST_ID_SDS_LAYOUT_CV_NAV_T5;
         break;
      case LAYOUT_CV_S_PHO:
         return LIST_ID_SDS_LAYOUT_CV_S_PHO;
         break;
      case LAYOUT_CV_S_AUD:
         return LIST_ID_SDS_CV_S_AUD;
         break;
      case LAYOUT_CV_S_NAV:
         return LIST_ID_SDS_LAYOUT_CV_S_NAV;
         break;
      case LAYOUT_CV_TUNER:
         return LIST_ID_SDS_LAYOUT_CV_TUNER;
         break;
      default:
         return 0;
         break;
   }
}


enSdsScreenLayoutType ListHandler::getCurrentLayout()
{
   return _currentLayout;
}


} // Namespace Core
} // Namespace App
