/* ***************************************************************************************
* FILE:          CGIAppViewController_SPI.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_SPI.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_SPI_H)
#define _CGIAPPVIEWCONTROLLER_SPI_H

#include "CgiExtensions/ViewControllerBase.h"
#include "AppHmi_SPI_SimpleViewController.h"
#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
		{\
		private:\
		courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
		tController() {}\
		virtual ~tController() {}\
		static const char* _name;\
		static Courier::ViewController* createInstance()\
		{\
			return COURIER_NEW(tController)();\
		}\
		};

//SIMPLE_CONTROLLER(CGIAppViewController_S_ConnectSP)
SIMPLE_CONTROLLER(CGIAppViewController_S_FullScreen)
SIMPLE_CONTROLLER(CGIAppViewController_S_MySPIN)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_2ndDeviceConnectConfirmation)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_AAP_FRX_Disclaimer)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Connect_BT)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SPIMessage)

//New Scenes
SIMPLE_CONTROLLER(CGIAppViewController_mySPIN_AppView)
SIMPLE_CONTROLLER(CGIAppViewController_Phone_not_connected)
SIMPLE_CONTROLLER(CGIAppViewController_SPI_Gadget)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_1stDeviceConnection)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_ParkedCondition)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SPI_BT_Pairing)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SPI_Retry)
#endif // _CGIAPPVIEWCONTROLLER_SPI_H
