/**************************************************************************************
 * @file         : VehicleDataSpiClientHandler.h
 * @author       : Bruce Mario Savio Netto (RBEI/ECH2)
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *09.01.19 Rev. 0.1 Bruce Mario Savio Netto (RBEI/ECH2)
 * 		  			Initial Revision.
 **************************************************************************************/

#ifndef VEHICLEDATASPICLIENTHANDLER_H_
#define VEHICLEDATASPICLIENTHANDLER_H_

#include "App/Core/ConnectionClientHandler/ConnectionClientHandler.h"
#include "SPIDefines.h"
#ifdef DP_DATAPOOL_ID

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_10_if.h"

#include <ilm_client.h>
#include <ilm_control.h>
#include <algorithm>
#include <sstream>
#include <limits>
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataProxy.h"

class StartupSync;

namespace App {
namespace Core {
class ConnectionClientHandler;
class VehicleDataSpiClientHandler: public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF
   , public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF
   , public ::VEHICLE_MAIN_FI::LanguageCallbackIF
   , public ::VEHICLE_MAIN_FI::SpeedCallbackIF
//, public ::VEHICLE_MAIN_FI::GearCallbackIF
   , public ::midw_smartphoneint_fi::SetFeatureRestrictionsCallbackIF
   , public ::midw_smartphoneint_fi::SetVehicleMovementStateCallbackIF
   , public ::midw_smartphoneint_fi::SetVehicleConfigurationCallbackIF
   , public ::midw_smartphoneint_fi::VehicleMechanicalSpeedCallbackIF
   , public ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeCallbackIF

{
   private:
      static VehicleDataSpiClientHandler* _vehicleDataSpiClientHandler;
      ConnectionClientHandler* _connectionClientHandler;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;
      ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy> _hmiDataProxyClient;
      int32 m_speedvalue;
      int32 m_carplayDriveModeRestriction;
      int32 m_parkModeRestrictionInfo;
      int m_parkmode_decimal;
      int m_drivemode_decimal;
      uint16 m_GeneralRestriction;
      int m_gearvalue;

   public:
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      void setFeatureRestrictionsAAP();
//register for GUI ready msg
//GuiStartupFinishedUpdMsg has to be bind in all the hall component in order to reflect the language changes at the time of bootup/system start up
      COURIER_MSG_MAP_BEGIN(0)
      //COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SPI_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      COURIER_MSG_MAP_END()

      VehicleDataSpiClientHandler();
      virtual ~VehicleDataSpiClientHandler();

      static VehicleDataSpiClientHandler* getInstance()
      {
         if (NULL == _vehicleDataSpiClientHandler)
         {
            _vehicleDataSpiClientHandler = new VehicleDataSpiClientHandler();
         }
         return _vehicleDataSpiClientHandler;
      }

      virtual void registerProperties(const ::boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);
      virtual void deregisterProperties(const ::boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      /*Virtual Functions*/
//LanguageSyncSourceCallbackIF
      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}
      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}
//SetLanguageCallbackIF
      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);
      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);
//LanguageCallbackIF
      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);
//SetVehicleMovementStateCallbackIF
      virtual void onSetVehicleMovementStateResult(const ::boost::shared_ptr< midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, \
            const ::boost::shared_ptr< midw_smartphoneint_fi::SetVehicleMovementStateResult >& result);
      virtual void onSetVehicleMovementStateError(const ::boost::shared_ptr< midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, \
            const ::boost::shared_ptr< midw_smartphoneint_fi::SetVehicleMovementStateError >& error);
//SetVehicleConfigurationCallbackIF
      virtual void onSetVehicleConfigurationResult(const ::boost::shared_ptr< midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, \
            const ::boost::shared_ptr< midw_smartphoneint_fi::SetVehicleConfigurationResult >& result);
      virtual void onSetVehicleConfigurationError(const ::boost::shared_ptr< midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, \
            const ::boost::shared_ptr< midw_smartphoneint_fi::SetVehicleConfigurationError >& error);
//SpeedCallbackIF
      virtual void onSpeedError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedError >& error);
      virtual void onSpeedStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                 const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedStatus >& status);
//GearCallbackIF
      // virtual void onGearError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
      // const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GearError >& error);
      // virtual void onGearStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
      // const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GearStatus >& status);
//DimmingCallbackIF
      void onDimmingModeError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy,
                              const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeError >& error);
      void onDimmingModeUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy,
                               const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeUpdate >& update);

//SetFeatureRestrictionsCallbackIF
      virtual void onSetFeatureRestrictionsResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetFeatureRestrictionsResult>& result);

      virtual void onSetFeatureRestrictionsError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetFeatureRestrictionsError>& error);

//VehicleMechanicalSpeedCallbackIF
      virtual void onVehicleMechanicalSpeedResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::VehicleMechanicalSpeedResult>& result);

      virtual void onVehicleMechanicalSpeedError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::VehicleMechanicalSpeedError>& error);

      /*Local Functions*/
      std::string getNewLanguageID(int);
      void vInitialize();
      void onChangeLanguage(int);
      void setVehicleMovementState(::midw_smartphoneint_fi_types::T_e8_ParkBrake, ::midw_smartphoneint_fi_types::T_e8_GearState, ::midw_smartphoneint_fi_types::T_e8_VehicleState);
      void setVehicleConfiguration(::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration);
      void setParkBrakeInfo(uint8 State);
      uint32 getParkBrakeInfo();
      void getDimmingStatusInfo(uint8 State);
      midw_smartphoneint_fi_types::T_e8_GearState getGearStateInfo();
      void getVehicleStateInfo(uint8 State);

      void setFeatureRestrictions_Carplay();
      void getVehicleCondition();
      void setVehiclespeed(int32 m_speedvalue);
//GuiStartupFinishedUpdMsg has to be bind in all the hall component in order to reflect the language changes at the time of bootup/system start up
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);
      struct LanguageTable
      {
         int LangIndex;
         std::string LangString;
      };
      LanguageTable LanguageMappingTable[LANGNO] =
      {
         { 12, "en_GB" },
         { 23, "de_DE" },
         { 10, "nl_NL" },
         { 21, "fr_FR" },
         { 29, "it_IT"},
         { 46, "es_ES"},//es_SP previously
         { 39, "pt_PT" },
         { 27, "hu_HU" },
         { 42, "ru_RU" },
         { 8, "cs_CZ"},//cs_CS previously
         { 9, "da_DK" },//da_DA previously
         { 35, "nb_NO" },//nb_NB previously
         { 38, "pl_PL" },
         { 49, "sv_SE" },
         { 13, "en_US" },
         { 24, "el_GR" },
         { 52, "tr_TR" },
         { 47, "es_MX" },//es_LA previously
         { 22, "fr_CA" }
      };

//Latest Language Code Reference Table

//EUROPEAN VARIANT

      /*UK_English      	en_GB 	12
      German   			de_DE 	23
      Dutch   			nl_NL 	10
      EU_French   		fr_FR	21
      Italian   			it_IT 	29
      EuropeanSpanish   	es_ES 	46
      EuropeanPortugese   pt_PT 	39
      Hungarian   		hu_HU 	27
      Russian     		ru_RU	42
      Czech     			cs_CZ 	8
      Danish   			da_DK 	9
      Norwegian   		nb_NO	35
      Polish   			pl_PL	38
      Swedish   			sv_SE 	49
      US_English   		en_US	13
      Greek   			el_GR 	24
      Turkish   			tr_TR  	52*/

//NAFTA VARIANT

      /*UK_English		en_GB	12
      US_English			en_US	13
      Can_French			es_MX	47
      Latin American Spanish	fr_CA	22*/

      dp_tclAppHmi_SPIVDLanguageIndexSystem 						_dpVDLanguageIndexSystem;
      ::midw_smartphoneint_fi_types::T_e8_ParkBrake 				m_ParkBrakeInfo;
      ::midw_smartphoneint_fi_types::T_e8_GearState 				m_GearStateInfo;
      ::midw_smartphoneint_fi_types::T_e8_VehicleState 			m_VehicleStateInfo;
      ::midw_smartphoneint_fi_types::T_e8_Vehicle_Configuration 	m_DimmingStatusInfo;
};


}//namespace App
}//namespace Core
#endif /* DP_DATAPOOL_ID */
#endif /*VEHICLEDATASPICLIENTHANDLER_H_*/
