/* ***************************************************************************************
* FILE:          SPIHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SPIHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SPIHall_h
#define SPIHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"

#include "AppHmi_SPIMessages.h"

#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Core/AudioSourceClientHandler/AudioSourceClientHandler.h"
#include "Core/ContextSwitchClientHandler/ContextSwitchClientHandler.h"
#include "Core/ConnectionClientHandler/ConnectionClientHandler.h"
#include "Core/VehicleDataSpiClientHandler/VehicleDataSpiClientHandler.h"
#include "Core/SystemPowerModeClientHandler/SystemPowerModeClientHandler.h"
#include "Core/KeyClientHandler/KeyClientHandler.h"
#include "Core/DisplaySourceClientHandler/DisplaySourceClientHandler.h"
#include "Core/AccessoryAppStateHandler/AccessoryAppStateHandler.h"

#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include <Adapter/LanguageHandlerAdapter.h>


using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;


namespace App {
namespace Core {

class SPIHall
   : public HallComponentBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      SPIHall();
      SPIHall(const SPIHall&);
      SPIHall& operator=(const SPIHall&);
      virtual ~SPIHall();

   protected:
      bool onCourierMessage(const ApplicationStateUpdMsg&);
      bool onCourierMessage(const GuiStartupFinishedUpdMsg&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SPI_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_audioSourceClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_connectionClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_contextSwitchClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_keyClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_vehicleDataSpiClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_displaySourceClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_systemPowerModeClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_accessoryAppStateHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy> _audioSourceChangeProxy;
      ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy> _soundPropertiesProxy;
      ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy> _hmiDataProxyClient;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoProxyClient;

      ConnectionClientHandler* _connectionClientHandler;
      VehicleDataSpiClientHandler* _vehicleDataSpiClientHandler;
      AudioSourceClientHandler* _audioSourceClientHandler;
      ContextSwitchClientHandler* _contextSwitchClientHandler;
      KeyClientHandler* _keyClientHandler;
      DisplaySourceClientHandler* _displaySourceClientHandler;
      SystemPowerModeClientHandler* _systemPowerModeClientHandler;
      AccessoryAppStateHandler* _accessoryAppStateHandler;

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
