/* ***************************************************************************************
* FILE:          SPIHall.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SPIHall.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hall_std_if.h"
#include "App/Core/SPIHall.h"
#include "most_BTSet_fi_types.h"
#include "most_Tel_fi_types.h"
#include "vehicle_main_fi_types.h"
#include "VEHICLE_MAIN_FIProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include <ilm_client.h>
#include <ilm_control.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SPI_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SPI
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_SPI_"
#define ETG_I_FILE_PREFIX App::Core::SPIHall::
#include "trcGenProj/Header/SPIHall.cpp.trc.h"
#endif
#define VARIANT_S_FTR_ENABLE_SMART
using namespace ::App::Core;
using namespace ::CourierTunnelService::CourierMessageReceiver;
using namespace ::asf::core;
using namespace ::midw_smartphoneint_fi;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
using namespace ::MOST_BTSet_FI;
using namespace ::most_BTSet_fi_types;
using namespace ::MOST_Tel_FI;
using namespace ::most_Tel_fi_types;
using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;
using namespace ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange;
using namespace ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties;

namespace App {
namespace Core {

DEFINE_CLASS_LOGGER_AND_LEVEL("App/Core", SPIHall, Info);

/************************************************************************
*FUNCTION:		SPIHall
*DESCRIPTION:	Constructor
*PARAMETER:     None
*RETURNVALUE:	NA
*SWFL:          NA
*HISTORY:
*0.1     20.04.18      Athira Sreekumar       Initial Version
************************************************************************/
SPIHall::SPIHall()
   : HallComponentBase("", "App.Core.AppHmi_SPI", "/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_SPI")
{
   ETG_TRACE_USR4(("SPIHall::SPIHall"));
   ETG_I_REGISTER_FILE();
   _contextSwitchClientHandler = ContextSwitchClientHandler::poGetInstance();
   _connectionClientHandler = ConnectionClientHandler::getInstance();
   ETG_TRACE_USR4(("SPIHall::Connection Clienthandler Instance Created"));
   _vehicleDataSpiClientHandler = VehicleDataSpiClientHandler::getInstance();
   ETG_TRACE_USR4(("SPIHall::Vehicle Clienthandler Instance Created"));
   _systemPowerModeClientHandler = SystemPowerModeClientHandler::getInstance();
   ETG_TRACE_USR4(("SPIHall::SPM Clienthandler Instance Created"));
   if (_connectionClientHandler != NULL)
   {
      _keyClientHandler = KeyClientHandler::getInstance();
      ETG_TRACE_USR4(("SPIHall::Key Clienthandler Instance Created"));
      _audioSourceClientHandler = AudioSourceClientHandler::getInstance(_connectionClientHandler);
      ETG_TRACE_USR4(("SPIHall::Audio Source Clienthandler Instance Created"));
      _displaySourceClientHandler = DisplaySourceClientHandler::getInstance(_connectionClientHandler);
      ETG_TRACE_USR4(("SPIHall::Display Source Clienthandler Instance Created"));
      _accessoryAppStateHandler = AccessoryAppStateHandler::getInstance(_connectionClientHandler);
      ETG_TRACE_USR4(("SPIHall::Accessory AppStateHandler Instance Created"));
   }
   else
   {
      ETG_TRACE_USR4(("SPIHall::SPIHall else block : default initialization"));
      _keyClientHandler = NULL;
      _audioSourceClientHandler = NULL;
      _displaySourceClientHandler = NULL;
   }

//Getting vehicle type values from KDS
   /* #ifdef VARIANT_S_FTR_ENABLE_SMART
      sm_variant_smart = 1;
   #endif

   #ifndef VARIANT_S_FTR_ENABLE_SMART
      sm_variant_smart = 0;
   #endif */
}


/************************************************************************
*FUNCTION:		~SPIHall
*DESCRIPTION:	Destructor
*PARAMETER:     None
*RETURNVALUE:	NA
*SWFL:          NA
*HISTORY:
*0.1     20.04.18      Athira Sreekumar       Initial Version
************************************************************************/
SPIHall::~SPIHall()
{
   ETG_TRACE_USR4(("SPIHall::~SPIHall()"));
   if (NULL != _connectionClientHandler)
   {
      delete _connectionClientHandler;
      _connectionClientHandler = NULL;
   }
   if (NULL != _vehicleDataSpiClientHandler)
   {
      delete _vehicleDataSpiClientHandler;
      _vehicleDataSpiClientHandler = NULL;
   }
   if (NULL != _audioSourceClientHandler)
   {
      delete _audioSourceClientHandler;
      _audioSourceClientHandler = NULL;
   }
   if (_keyClientHandler)
   {
      delete _keyClientHandler;
      _keyClientHandler = NULL;
   }
   if (NULL != _contextSwitchClientHandler)
   {
      delete _contextSwitchClientHandler;
      _contextSwitchClientHandler = NULL;
   }
   if (NULL != _displaySourceClientHandler)
   {
      delete _displaySourceClientHandler;
      _displaySourceClientHandler = NULL;
   }
   if (_systemPowerModeClientHandler)
   {
      delete _systemPowerModeClientHandler;
      _systemPowerModeClientHandler = NULL;
   }
   if (NULL != _accessoryAppStateHandler)
   {
      delete _accessoryAppStateHandler;
      _accessoryAppStateHandler = NULL;
   }
}


/************************************************************************
*FUNCTION:		onCourierMessage
*DESCRIPTION:	Receive and update based on courier message
*PARAMETER:     oMsg
*RETURNVALUE:	bool
*SWFL:          1991, 1994, 2572, 2603, 2604
*HISTORY:
*0.1     20.04.18      Athira Sreekumar       Initial Version
************************************************************************/
bool SPIHall::onCourierMessage(const ApplicationStateUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("SPIHall::onCourierMessage ApplicationStateUpdMsg"));
   return true;
}


/************************************************************************
*FUNCTION:		onCourierMessage
*DESCRIPTION:	Receive and update based on courier message
*PARAMETER:     oMsg
*RETURNVALUE:	NA
*SWFL:          NA
*HISTORY:
*0.1     22.10.18      Athira Sreekumar       Initial Version
************************************************************************/
bool SPIHall::onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("SPIHall::GuiStartupFinishedUpdMsg"));
   bool isMsgConsumed = HallComponentBase::onCourierMessage(oMsg);
   ETG_TRACE_USR4(("SPIHall::GuiStartupFinishedUpdMsg Received isMsgConsumed = %d", isMsgConsumed));

   return false;
}


} // namespace Core
} // namespace App
