/* ***************************************************************************************
* FILE:          SPIGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SPIGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "hall_std_if.h"
#include "SPIGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "Trace/GuiInfo.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"
#include "ProjectBaseTypes.h"
#include "KeyMapping.h"

//#include "hmi_trace_if.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SPI_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SPI
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SPI_"
#define ETG_I_FILE_PREFIX                 App::Core::SPIGui::
#include "trcGenProj/Header/SPIGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////


//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_SPI), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_SPI), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_SPI))
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_SPI),
//
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_SPI),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_SPI)

                            APPSETTINGS_END()

                            using namespace ::hmi;

namespace App {
namespace Core {


SPIGui::SPIGui() : GuiComponentBase(hmi::apps::reference::appHmi_SPI, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_SPI_APPCTRL_PROXY);
   ETG_TRACE_USR4(("SPIGui_SYNCED_START"));
   // SPI_GADGET = 10; in ProjectBaseExchangingTextures
   SYNC_BLOCK_CONNECTION(765, SPI_GADGET);
   ETG_TRACE_USR4(("SPIGui_AppHmi_SPI"));
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_SPI, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_SPI, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_SPI, DisplayID_D1);
}


SPIGui::~SPIGui()
{
}


unsigned int SPIGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_SPI_MAIN;
}


void SPIGui::setupCgiInstance()
{
   ETG_TRACE_USR4(("SPIGui::setupCgiInstance"));
   //std::string assetFileName = SystemConfiguration::getAssetFileName();
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void SPIGui::preRun()
{
//   DP_vCreateDatapool();
   // PersistentValuesRead();
}


void SPIGui::postRun()
{
   //PersistentValuesWrite();
}


void SPIGui::PersistentValuesRead()
{
//   dp_tclhmiAppSPIPersMemVarsSPI dp;
//   _mvar = dp.tGetData();
}


void SPIGui::PersistentValuesWrite()
{
//   dp_tclhmiAppSPIPersMemVarsSPI dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void SPIGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_USR4(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
