/*********************************************************************************************************************************
 * @file         : KeyClientHandler.h
 * @author       : Sundeep Parvathikar (RBEI/ECH2)
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)
 * 		  			Initial Revision to handle Media Control Panel (MCP) keys and Steering Wheel Control (SWC) keys.
 *********************************************************************************************************************************/

#ifndef _KEY_CLIENT_HANDLER_H_
#define _KEY_CLIENT_HANDLER_H_

#include "SPIDefines.h"

namespace App {
namespace Core {
class KeyClientHandler
{
   private:
      static KeyClientHandler* _KeyClientHandler;
      ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;
      KeyClientHandler();

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(HKStatusChangedUpdMsg)
      COURIER_MSG_MAP_END()
      midw_smartphoneint_fi_types::T_e32_KeyCode KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_HOME;
      midw_smartphoneint_fi_types::T_e8_KeyMode KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
      midw_smartphoneint_fi_types::T_e8_DiPOAppType DipoMode;
      uint32 m_ActivateSiri;
      uint32 m_EndCallstate;
      uint32 m_AcceptCallstate;
      uint32 m_EndSiri;
      uint32 m_ActivateGoogleAssistant;
      uint32 m_EndGoogleAssistant;

   public:
      static KeyClientHandler* getInstance();
      virtual ~KeyClientHandler();

      virtual bool onCourierMessage(const HKStatusChangedUpdMsg& msg);
      void vHandleKeyEventActivateSiri(uint32 activateSiri);
      void vHandleKeyEventEndCall(uint32 endCallstate);
      void vHandleKeyEventAcceptCall(uint32 acceptCallstate);
      void vHandleKeyEventEndSiri(uint32 endSiri);
      void vHandleKeyEventActivateGoogleAssistant(uint32 activateGoogleAssistant);
      void vHandleKeyEventEndGoogleAssistant(uint32 endGoogleAssistant);
};


} // namespace Core
} // namespace App

#endif /*_KEY_CLIENT_HANDLER_H_*/
