/*********************************************************************************************************************************
 * @file         : KeyClientHandler.cpp
 * @author       : Sundeep Parvathikar (RBEI/ECH2)
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)
 * 		  			Initial Revision to handle Media Control Panel (MCP) keys and Steering Wheel Control (SWC) keys.
 *********************************************************************************************************************************/

#include "hall_std_if.h"
#include "Core/KeyClientHandler/KeyClientHandler.h"
#include "Core/ConnectionClientHandler/ConnectionClientHandler.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SPI_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SPI
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_SPI_"
#define ETG_I_FILE_PREFIX App::Core::KeyClientHandler::
#include "trcGenProj/Header/KeyClientHandler.cpp.trc.h"
#endif
#define VARIANT_S_FTR_ENABLE_SMART
using namespace ::midw_smartphoneint_fi;
using namespace ::midw_smartphoneint_fi_types;
namespace App {
namespace Core {

/*************************************
| static data members initialization
*************************************/
KeyClientHandler* KeyClientHandler::_KeyClientHandler = NULL;


/************************************************************************
*FUNCTION:		getInstance
*DESCRIPTION:	class instance create/return
*PARAMETER:     None
*RETURNVALUE:	pointer to the class object
*SWFL:          NA
*HISTORY:
*17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)      Initial Version
************************************************************************/
KeyClientHandler* KeyClientHandler::getInstance()
{
   if (!_KeyClientHandler)
   {
      _KeyClientHandler = new KeyClientHandler();
   }
   ETG_TRACE_USR4(("KeyClientHandler::getInstance()"));
   return _KeyClientHandler;
}


/************************************************************************
*FUNCTION:		KeyClientHandler
*DESCRIPTION:	Constructor
*PARAMETER:     None
*RETURNVALUE:	NA
*SWFL:          NA
*HISTORY:
*17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)      Initial Version
************************************************************************/
KeyClientHandler::KeyClientHandler()
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("KeyClientHandler::KeyClientHandler()"));
   DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_NOT_USED;
   m_ActivateSiri = 0;
   m_EndCallstate = 0;
   m_AcceptCallstate = 0;
   m_EndSiri = 0;
   m_ActivateGoogleAssistant = 0;
   m_EndGoogleAssistant = 0;
}


/************************************************************************
*FUNCTION:		~KeyClientHandler
*DESCRIPTION:	Destructor
*PARAMETER:     None
*RETURNVALUE:	NA
*SWFL:          NA
*HISTORY:
*17.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)      Initial Version
************************************************************************/
KeyClientHandler::~KeyClientHandler()
{
   ETG_TRACE_USR4(("KeyClientHandler::~KeyClientHandler()"));
   if (!_KeyClientHandler)
   {
      delete _KeyClientHandler;
   }
   _KeyClientHandler = NULL;
   ETG_I_UNREGISTER_FILE();
   DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_NOT_USED;
   m_ActivateSiri = 0;
   m_EndCallstate = 0;
   m_AcceptCallstate = 0;
   m_EndSiri = 0;
   m_ActivateGoogleAssistant = 0;
   m_EndGoogleAssistant = 0;
}


/************************************************************************
*FUNCTION:		onCourierMessage
*DESCRIPTION:	virtual function to handle message - HKStatusChangedUpdMsg
*PARAMETER:     HKStatusChangedUpdMsg&
*RETURNVALUE:	bool
*SWFL:          2598
*SYSFL:			5019
*HISTORY:
*22.04.2019 Rev. 0.1 Sundeep Parvathikar (RBEI/ECH2)      Initial Version
************************************************************************/
bool KeyClientHandler::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   bool handleMsgFlag = false;
   // midw_smartphoneint_fi_types::T_e32_KeyCode KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_HOME;
   // midw_smartphoneint_fi_types::T_e8_KeyMode KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;

   ETG_TRACE_USR4(("HKStatusChangedUpdMsg KeyCode = %d m_KeyMode = %d msg.GetHKCode() = %d  msg.GetHKState() = %d", KeyCode, KeyMode, msg.GetHKCode(), msg.GetHKState()));
   int mActiveDeviceCategory = ConnectionClientHandler::getInstance()->tGetActiveDeviceCategory();
   int mSessionStatus = ConnectionClientHandler::getInstance()->tGetSessionStatus();
   int mspeech = ConnectionClientHandler::getInstance()->tGetDiPOAppSpeechinfo();
   int mphonestate = ConnectionClientHandler::getInstance()->tGetDiPOAppPhoneStateinfo();
   //int mcallstate = AccessoryAppStateHandler::getInstance()


#ifndef VARIANT_S_FTR_ENABLE_SMART
   switch (mActiveDeviceCategory)
   {
      case ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_DIPO :
      {
         if (msg.GetHKCode() == HARDKEYCODE_SWC_PHONE_PICKUP)
         {
            if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_NOTACTIVE))
            {
               vHandleKeyEventActivateSiri(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_ACTIVE))
            {
               vHandleKeyEventEndCall(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_UNKNOWN))  //incoming call not proper
            {
               vHandleKeyEventAcceptCall(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && ((mspeech == midw_smartphoneint_fi_types::T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_SPEAKING) || (mspeech == midw_smartphoneint_fi_types::T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_RECOGNISING)))
            {
               vHandleKeyEventEndSiri(msg.GetHKState());
            }
         }

         break;
      }
      case ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO :
      {
         if (msg.GetHKCode() == HARDKEYCODE_SWC_PHONE_PICKUP)
         {
            if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_NOTACTIVE))
            {
               vHandleKeyEventActivateGoogleAssistant(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_ACTIVE))
            {
               vHandleKeyEventEndCall(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && (mphonestate == midw_smartphoneint_fi_types::T_e8_PhoneAppState__SPI_APP_STATE_PHONE_UNKNOWN)) //incoming call not proper
            {
               vHandleKeyEventAcceptCall(msg.GetHKState());
            }
            else if ((mSessionStatus == midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) && ((mspeech == midw_smartphoneint_fi_types::T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_SPEAKING) || (mspeech == midw_smartphoneint_fi_types::T_e8_SpeechAppState__SPI_APP_STATE_SPEECH_RECOGNISING)))
            {
               vHandleKeyEventEndGoogleAssistant(msg.GetHKState());
            }
         }
         break;
      }
   };
#endif
   return false;
}


//FUNCTION: 		vHandleKeyEventActivateSiri
void KeyClientHandler::vHandleKeyEventActivateSiri(uint32 activateSiri)
{
   m_ActivateSiri = activateSiri;
   switch (m_ActivateSiri)
   {
      case hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg ACTIVATE SIRI BUTTON DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break ;
      }
      case hmibase::HARDKEYSTATE_UP :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg ACTIVATE SIRI BUTTON UP"));
         KeyMode = midw_smartphoneint_fi_types ::T_e8_KeyMode__KEY_RELEASE;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONUP;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }
   };
}


//FUNCTION: 		vHandleKeyEventEndCall
void KeyClientHandler:: vHandleKeyEventEndCall(uint32 endCallstate)
{
   m_EndCallstate = endCallstate;
   switch (m_EndCallstate)
   {
      case hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_REJECT BUTTON DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
      case  hmibase::HARDKEYSTATE_LONG1 :
      case  hmibase::HARDKEYSTATE_LONG2 :
      case  hmibase::HARDKEYSTATE_LONG3 :
      case  hmibase::HARDKEYSTATE_LONG4 :
      case  hmibase::HARDKEYSTATE_LONG5 :
      case  hmibase::HARDKEYSTATE_LONG6 :
      case  hmibase::HARDKEYSTATE_LONG7 :
      case  hmibase::HARDKEYSTATE_LONG8 :
      case  hmibase::HARDKEYSTATE_LONG9 :
      case  hmibase::HARDKEYSTATE_LONG10 :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_REJECT BUTTON LONG"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_LONGPRESS;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
      case hmibase::HARDKEYSTATE_UP :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_REJECT BUTTON UP"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_RELEASE;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
   };
}


//FUNCTION: 		vHandleKeyEventAcceptCall
void KeyClientHandler:: vHandleKeyEventAcceptCall(uint32 acceptCallstate)
{
   m_AcceptCallstate = acceptCallstate;
   switch (m_AcceptCallstate)
   {
      case hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_ACCEPT_BUTTON DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
      case  hmibase::HARDKEYSTATE_LONG1 :
      case  hmibase::HARDKEYSTATE_LONG2 :
      case  hmibase::HARDKEYSTATE_LONG3 :
      case  hmibase::HARDKEYSTATE_LONG4 :
      case  hmibase::HARDKEYSTATE_LONG5 :
      case  hmibase::HARDKEYSTATE_LONG6 :
      case  hmibase::HARDKEYSTATE_LONG7 :
      case  hmibase::HARDKEYSTATE_LONG8 :
      case  hmibase::HARDKEYSTATE_LONG9 :
      case  hmibase::HARDKEYSTATE_LONG10 :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_ACCEPT BUTTON LONG"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_LONGPRESS;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
      case hmibase::HARDKEYSTATE_UP :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_ACCEPT BUTTON UP"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_RELEASE;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
   };
}


//FUNCTION: 		vHandleKeyEventEndSiri
void KeyClientHandler:: vHandleKeyEventEndSiri(uint32 endSiri)
{
   m_EndSiri = endSiri;
   switch (m_EndSiri)
   {
      case hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg END_SIRI_BUTTON_DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }

      case hmibase::HARDKEYSTATE_UP :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg END_SIRI_BUTTON_UP"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_RELEASE;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONUP;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }
   };
}


//FUNCTION: 		vHandleKeyEventActivateGoogleAssistant
void KeyClientHandler:: vHandleKeyEventActivateGoogleAssistant(uint32 activateGoogleAssistant)
{
   m_ActivateGoogleAssistant = activateGoogleAssistant;
   switch (m_ActivateGoogleAssistant)
   {
      case  hmibase::HARDKEYSTATE_LONG1 :
      case  hmibase::HARDKEYSTATE_LONG2 :
      case  hmibase::HARDKEYSTATE_LONG3 :
      case  hmibase::HARDKEYSTATE_LONG4 :
      case  hmibase::HARDKEYSTATE_LONG5 :
      case  hmibase::HARDKEYSTATE_LONG6 :
      case  hmibase::HARDKEYSTATE_LONG7 :
      case  hmibase::HARDKEYSTATE_LONG8 :
      case  hmibase::HARDKEYSTATE_LONG9 :
      case  hmibase::HARDKEYSTATE_LONG10 :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg ACTIVATE GOOGLE ASSISTANT BUTTON LONG"));
         KeyMode  =  midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_LONGPRESS;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }

      case hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_AA_PHONE_REJECT BUTTON DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_FLASH;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
         break;
      }
   };
}


//FUNCTION: 		vHandleKeyEventEndGoogleAssistant
void  KeyClientHandler::vHandleKeyEventEndGoogleAssistant(uint32 endGoogleAssistant)
{
   m_EndGoogleAssistant = endGoogleAssistant;
   switch (m_EndGoogleAssistant)
   {
      case  hmibase::HARDKEYSTATE_DOWN :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg END GOOGLE ASSISTANT BUTTON DOWN"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }
      case  hmibase::HARDKEYSTATE_LONG1 :
      case  hmibase::HARDKEYSTATE_LONG2 :
      case  hmibase::HARDKEYSTATE_LONG3 :
      case  hmibase::HARDKEYSTATE_LONG4 :
      case  hmibase::HARDKEYSTATE_LONG5 :
      case  hmibase::HARDKEYSTATE_LONG6 :
      case  hmibase::HARDKEYSTATE_LONG7 :
      case  hmibase::HARDKEYSTATE_LONG8 :
      case  hmibase::HARDKEYSTATE_LONG9 :
      case  hmibase::HARDKEYSTATE_LONG10 :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg RESTART GOOGLE ASSISTANT BUTTON LONG"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_LONGPRESS;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONDOWN;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }
      case hmibase::HARDKEYSTATE_UP :
      {
         ETG_TRACE_USR4(("HKStatusChangedUpdMsg KEY RELEASE"));
         KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_RELEASE;
         DipoMode = midw_smartphoneint_fi_types::T_e8_DiPOAppType__DIPO_SIRI_BUTTONUP;
         ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, (midw_smartphoneint_fi_types::T_e32_KeyCode)DipoMode);
         break;
      }
   };
}


// case HARDKEYCODE_SWC_PHONE_PICKUP:
// case HARDKEYCODE_HK_PHONE_ACCEPT:
// {
// //if ( KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_PRESS)
// //{
// ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_ACCEPT"));
// KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_CALL;
// handleMsgFlag = true;
// break;
// }
// case HARDKEYCODE_SWC_PHONE_REJECT:
// case HARDKEYCODE_HK_PHONE_REJECT:
// {
// ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_PHONE_REJECT"));
// KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_PHONE_END;
// handleMsgFlag = true;
// break;
// }
// case HARDKEYCODE_HK_NAV:
// {
// ETG_TRACE_USR4(("HKStatusChangedUpdMsg HARDKEYCODE_HK_NAV"));
// KeyCode = midw_smartphoneint_fi_types::T_e32_KeyCode__DEV_NAV;
// handleMsgFlag = true;
// break;
// }
// default:
// {
// ETG_TRACE_USR4(("HKStatusChangedUpdMsg default case"));
// handleMsgFlag = false;
// break;
// }

// ETG_TRACE_USR4(("HKStatusChangedUpdMsg KeyCode = %d KeyMode = %d msg.GetHKCode() = %d", KeyCode, KeyMode, msg.GetHKCode()));
//return handleMsgFlag;

// if (handleMsgFlag && ConnectionClientHandler::getInstance())
// {
// // ETG_TRACE_USR4(("HKStatusChangedUpdMsg KeyCode = %d KeyMode = %d msg.GetHKCode() = %d", KeyCode, KeyMode, msg.GetHKCode()));
// // ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);

// // KeyMode = midw_smartphoneint_fi_types::T_e8_KeyMode__KEY_RELEASE;

// ETG_TRACE_USR4(("HKStatusChangedUpdMsg KeyCode = %d KeyMode = %d msg.GetHKCode() = %d", KeyCode, KeyMode, msg.GetHKCode()));
// ConnectionClientHandler::getInstance()->vSendKeyEvent(KeyMode, KeyCode);
// }
// return handleMsgFlag;
// }
}// namespace Core
}// namespace App
