/**************************************************************************************
 * @file         : ConnectionClientHandler.h
 * @author       : Athira K Sreekumar
 * @addtogroup   : AppHmi_SPI
 * @brief        :
 * @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *20.04.18 Rev. 0.1 Athira K Sreekumar (RBEI/ECG2)
 * 		  			Initial Revision.
 *18.12.18 Rev. 0.2 Bruce Mario Savio Netto (RBEI/ECH2)
 *                  Bt Pairing and Spi Retry Popup implementation
 **************************************************************************************/

#ifndef _CONNECTION_CLIENT_HANDLER_H_
#define _CONNECTION_CLIENT_HANDLER_H_
#include "App/Core/VehicleDataSpiClientHandler/VehicleDataSpiClientHandler.h"
#include "Core/AccessoryAppStateHandler/AccessoryAppStateHandler.h"

#include "SPIDefines.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "App/Core/ContextSwitchClientHandler/ContextSwitchClientHandler.h"
#include "ApplicationSwitch.h"
#include <ilm_client.h>
#include <ilm_control.h>

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif
#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

class StartupSync;
namespace App {
namespace Core {
class ConnectionClientHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public midw_smartphoneint_fi::DeviceStatusInfoCallbackIF
   , public midw_smartphoneint_fi::GetDeviceInfoListCallbackIF
   , public midw_smartphoneint_fi::SetDisplayAttributesCallbackIF
   , public midw_smartphoneint_fi::DeviceDisplayContextCallbackIF
   , public midw_smartphoneint_fi::SessionStatusInfoCallbackIF
   , public midw_smartphoneint_fi::LaunchAppCallbackIF
   , public midw_smartphoneint_fi::SetDeviceUsagePreferenceCallbackIF
   , public midw_smartphoneint_fi::GetDeviceUsagePreferenceCallbackIF
   , public midw_smartphoneint_fi::SetTechnologyPreferenceCallbackIF
   , public midw_smartphoneint_fi::GetTechnologyPreferenceCallbackIF
   , public midw_smartphoneint_fi::ProjectionDeviceAuthorizationCallbackIF
   , public midw_smartphoneint_fi::SetAccessoryDisplayContextCallbackIF
   , public midw_smartphoneint_fi::SendKeyEventCallbackIF
   , public ::midw_smartphoneint_fi::SelectDeviceCallbackIF
   , public midw_smartphoneint_fi::BluetoothDeviceStatusCallbackIF
{
   private:
      static ConnectionClientHandler* _connectionClientHandler;
      ConnectionClientHandler();

      ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;

      ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType m_DeviceConnectionType;
      ::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo m_DeviceStatus;

      bool m_bIsDeviceAdded;
      uint32 m_DeviceHandle;
      bool m_IsActiveDeviceHandleValid;
      uint8 PairingStatus;
      bool m_bPairingReqd;
      //Used to monitor the BT pairing popup and accordingly display it (SPI BT PAIRING).
      //This is a limitation of MySPIN Protocol where session switches from Active to Suspended and vice versa when MYPSIN launcher app is not in the foreground.
      bool m_SPIBTPopupShow;
      bool m_retryFlag;
      bool m_DeviceAlreadyConnected;
      uint32 prevDeviceHandle;
      int m_HandSetInteraction;
      int m_phonestate;
      int m_speech;
      //int m_initialize;
      int m_status;
      int mParkBrakeInfo;
      bool mSleepContextFlag;
      int mVehicleParkState;
      uint8 _technologyMySpin;
      uint8 _technologyCP;
      uint8 _technologyAA;

   public:
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const LaunchMySpinAppMsg& oMsg);
      bool onCourierMessage(const LaunchAAPorCPAppMsg& oMsg);
      bool onCourierMessage(const SwitchToHomeScreenReq& oMsg);
      bool onCourierMessage(const SwitchToSPIHomeReq& oMsg);
      bool onCourierMessage(const DeviceConnectionMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(LaunchMySpinAppMsg)
      ON_COURIER_MESSAGE(LaunchAAPorCPAppMsg)
      ON_COURIER_MESSAGE(SwitchToHomeScreenReq)
      ON_COURIER_MESSAGE(SwitchToSPIHomeReq)
      ON_COURIER_MESSAGE(DeviceConnectionMsg)
      COURIER_MSG_MAP_END()

      virtual ~ConnectionClientHandler();
      bool ismySPINEnabled();
      bool isCarPlayEnabled();
      bool isAndroidAutoEnabled();

      static ConnectionClientHandler* getInstance()
      {
         if (NULL == _connectionClientHandler)
         {
            _connectionClientHandler = new ConnectionClientHandler();
         }

         return _connectionClientHandler;
      }

      //TODO: onAvailable vs registerProperties
      virtual void registerProperties(const ::boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);
      virtual void deregisterProperties(const ::boost::shared_ptr<asf::core::Proxy>&, const asf::core::ServiceStateChange&);

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      //DeviceStatusInfoCallbackIF
      virtual void onDeviceStatusInfoStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                            const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceStatusInfoStatus>&);
      virtual void onDeviceStatusInfoError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                           const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceStatusInfoError>&);

      //GetDeviceInfoListCallbackIF
      virtual void onGetDeviceInfoListResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                             const ::boost::shared_ptr<midw_smartphoneint_fi::GetDeviceInfoListResult>&);
      virtual void onGetDeviceInfoListError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                            const ::boost::shared_ptr<midw_smartphoneint_fi::GetDeviceInfoListError>&);

      //SetDisplayAttributesCallbackIF
      virtual void onSetDisplayAttributesResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetDisplayAttributesResult>&);
      virtual void onSetDisplayAttributesError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetDisplayAttributesError>&);

      //DeviceDisplayContextCallbackIF
      virtual void onDeviceDisplayContextStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceDisplayContextStatus>&);
      virtual void onDeviceDisplayContextError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::DeviceDisplayContextError>&);

      //SessionStatusInfoCallbackIF
      virtual void onSessionStatusInfoStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                             const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoStatus>&);
      virtual void onSessionStatusInfoError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                            const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoError>&);

      //LaunchAppCallbackIF
      virtual void onLaunchAppResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                     const ::boost::shared_ptr<midw_smartphoneint_fi::LaunchAppResult>&);
      virtual void onLaunchAppError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                    const ::boost::shared_ptr<midw_smartphoneint_fi::LaunchAppError>&);

      //SetDeviceUsagePreferenceCallbackIF
      virtual void onSetDeviceUsagePreferenceResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetDeviceUsagePreferenceResult>& result);

      virtual void onSetDeviceUsagePreferenceError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetDeviceUsagePreferenceError>& error);

      //GetDeviceUsagePreferenceCallbackIF
      virtual void onGetDeviceUsagePreferenceError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::GetDeviceUsagePreferenceError>& error);

      virtual void onGetDeviceUsagePreferenceResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::GetDeviceUsagePreferenceResult>& result);

      //SetTechnologyPreferenceCallbackIF
      virtual void onSetTechnologyPreferenceResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetTechnologyPreferenceResult>&);

      virtual void onSetTechnologyPreferenceError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetTechnologyPreferenceError>&);

      //GetTechnologyPreferenceCallbackIF
      virtual void onGetTechnologyPreferenceResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::GetTechnologyPreferenceResult>&);

      virtual void onGetTechnologyPreferenceError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::GetTechnologyPreferenceError>&);

      //ProjectionDeviceAuthorizationCallbackIF
      virtual void onProjectionDeviceAuthorizationStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy,
            const ::boost::shared_ptr<midw_smartphoneint_fi::ProjectionDeviceAuthorizationStatus>&);

      virtual void onProjectionDeviceAuthorizationError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::ProjectionDeviceAuthorizationError>&);

      //AccessoryDisplayContextCallbackIF
      virtual void onSetAccessoryDisplayContextResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetAccessoryDisplayContextResult>&);

      virtual void onSetAccessoryDisplayContextError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
            const ::boost::shared_ptr<midw_smartphoneint_fi::SetAccessoryDisplayContextError>&);

      //SendKeyEventCallbackIF
      virtual void onSendKeyEventError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                       const ::boost::shared_ptr<midw_smartphoneint_fi::SendKeyEventError>&);

      virtual void onSendKeyEventResult(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&,
                                        const ::boost::shared_ptr<midw_smartphoneint_fi::SendKeyEventResult>&);

      //Selectdevice
      virtual void onSelectDeviceError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::midw_smartphoneint_fi::SelectDeviceError >& error);

      virtual void onSelectDeviceResult(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::midw_smartphoneint_fi::SelectDeviceResult >& result);

      //BluetoothDeviceStatusCallbackIF
      virtual void onBluetoothDeviceStatusStatus(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
            const ::boost::shared_ptr< ::midw_smartphoneint_fi::BluetoothDeviceStatusStatus >& status);

      virtual void onBluetoothDeviceStatusError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
            const ::boost::shared_ptr< ::midw_smartphoneint_fi::BluetoothDeviceStatusError >& error);

      void vInitialize();
      void vOnDeviceInfoStatusDeviceAdded(uint32, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType);
      void vOnDeviceInfoStatusDeviceRemoved(uint32);
      void vOnDeviceRemovedPopupHandle();
      void vOnSessionActiveOperations(const bool& isBT_HFP_Active, const bool& isBT_A2DP_Active);
      void vOnDeviceInfoStatusDeviceChanged(uint32, ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType);
      void vHandleDeviceDetails(const ::midw_smartphoneint_fi_types::T_DeviceDetails&);
      bool bDeviceDetailsValidity(const ::midw_smartphoneint_fi_types::T_DeviceDetails&);

      void vSetActiveDeviceHandleValidity(bool);
      bool bGetActiveDeviceHandleValidity();

      void vSetActiveDeviceHandle(uint32 deviceHandle);
      uint32 tGetActiveDeviceHandle();

      void vSetActiveDeviceConnectionType(::midw_smartphoneint_fi_types::T_e8_DeviceConnectionType);
      midw_smartphoneint_fi_types::T_e8_DeviceConnectionType tGetActiveDeviceConnectionType();

      void vSetActiveDeviceCategory(::midw_smartphoneint_fi_types::T_e8_DeviceCategory);
      uint32 tGetActiveDeviceCategory();

      void vSetDeviceConnectionStatus(::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus);
      uint32 tGetDeviceConnectionStatus();

      void vSetSessionStatus(::midw_smartphoneint_fi_types::T_e8_SessionStatus);
      midw_smartphoneint_fi_types::T_e8_SessionStatus tGetSessionStatus();
      int tGetDiPOAppSpeechinfo();
      int tGetDiPOAppPhoneStateinfo();

      void vSetDisplayAttributes();
      void vSetAndroidDisplayAttributes();
      void vSetAppleDisplayAttributes();
      void vSetMySPINDisplayAttributesOnStartUp();

      void vCheckForeGroundNavi();

      void vHandleDisplayFlagTRUE();
      void vHandleDisplayFlagFALSE();

      void vEnableSPILayers();
      void vDisableSPILayers();
      void vParkedConditionPopup();

      void vLaunchApp(uint32, ::midw_smartphoneint_fi_types::T_e8_DeviceCategory, ::midw_smartphoneint_fi_types::T_e8_DiPOAppType);
      //void vLaunchFRXPopup(uint32 );

      void vSetDeviceUsagePreference(bool /*, midw_smartphoneint_fi_types::T_e8_DeviceCategory*/);
      void vGetDeviceUsagePreference();
      void vSetAppleDeviceUsagePreference(bool);
      void vSetAndroidDeviceUsagePreference(bool);

      void vSetTechnologyPreference();
      void vSetTechnologyApplePreference();
      void vSetTechnologyAndroidPreference();
      void vSetVehicleMovementParkBrake();

      void vGetTechnologyPreference(uint32, ::midw_smartphoneint_fi_types::T_e8_DeviceType);

      void vSetProjectionDeviceAuthorization(uint32, ::midw_smartphoneint_fi_types::T_e8_UserAuthorizationStatus);

      void vSetAccessoryDisplayContext(const SetAccessoryDisplayContextDetails&);

      void vSendKeyEvent(::midw_smartphoneint_fi_types::T_e8_KeyMode,
                         ::midw_smartphoneint_fi_types::T_e32_KeyCode);
      void vSendSelectDeviceStart();
      void readKdsForTechnology();
      int getKDSVehicleType();
      void AAPMySPinStandby();

      DataBindingItem<SPIGadgetInfoDataBindingSource> _SPIGadgetInfo;

      bool isBTConnectedProfilesActive_A2DP(const uint8&);
      bool isBTConnectedProfilesActive_HFP(const uint8&);
};


} // namespace Core
} // namespace App

#endif /*_CONNECTION_CLIENT_HANDLER_H_*/
