/************************************************************************
*FILE:         AccessoryAppStateHandler.h
*SW-COMPONENT:    SPI
*DESCRIPTION:  AccessoryAppStateHandler checks for the native app states
        and updates to CarPlay.
*AUTHORS:      ECG-vav6kor
*COPYRIGHT:    * Copyright (c) 2019-2019 Robert Bosch Car Multimedia GmbH
        * duplication and disclosure to third parties is prohibited.
*HISTORY:
*-----------------------------------------------------------------------
*03.10.16      Rev. 1.0 ECG-vav6kor
        * Initial Draft
*09.05.2017    Rev 1.1 Pratik Bhagwat
        * Send PPT SubState to SPM once Siri is activated and
          HMI is in user OFF mode.
*24.05.17      Rev. 1.2 Pratik Bhagwat
        * Implementation of Setter and Getter functions for
          Speech/Phone/Navigation Status
        * Implementation for AccessoryAppState to Update the
          app states to CarPlay whenever there is a change in
          Speech/Phone/Navigation Status.
*14.12.17      Rev. 1.3 Pratik Bhagwat
        * Implementation of ConflictsDetected Property from BTSettings
             to update BT service to proceed with CP in case of conflict
************************************************************************/
#ifndef _ACCESSORY_APPSTATE_HANDLER_H_
#define _ACCESSORY_APPSTATE_HANDLER_H_

#include "App/Core/ConnectionClientHandler/ConnectionClientHandler.h"
#include "App/Core/ContextSwitchClientHandler/ContextSwitchClientHandler.h"
#include "Core/DisplaySourceClientHandler/DisplaySourceClientHandler.h"
#include "MOST_Tel_FIProxy.h"
#include "SPIDefines.h"
#include "CgiExtensions/DataBindingItem.hpp"
//#include "Project.h"
//#include "HmiappdataserviceClientHandler.h"
//#include "SPM_ClientHandler.h"
//#include "MOST_BTSet_FIProxy.h"
//#include "most_BTSet_fi_types.h"
//#include "most_BTSet_fi_typesConst.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_10_if.h"
#include <ilm_client.h>
#include <ilm_control.h>
#include <algorithm>
#include <sstream>
#include <limits>


class StartupSync;
namespace App {
namespace Core {

class ConnectionClientHandler;
class AccessoryAppStateHandler:
   public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::midw_smartphoneint_fi::DiPOAppStatusInfoCallbackIF
   , public ::MOST_Tel_FI::CallStatusNoticeCallbackIF
   , public ::MOST_BTSet_FI::ConflictsDetectedCallbackIF
   , public ::MOST_BTSet_FI::ResolveConflictsCallbackIF
   , public ::midw_smartphoneint_fi::AccessoryAppStateCallbackIF
{
   public :
      virtual ~ AccessoryAppStateHandler();
      AccessoryAppStateHandler(ConnectionClientHandler* paraSpiConnectionHandling);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(SecondDeviceConnectConfirmationYesMsg)
      ON_COURIER_MESSAGE(SecondDeviceConnectConfirmationNOMsg)
      COURIER_MSG_MAP_END()

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onUnavailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);
      void onAvailable(const ::boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange&);

      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const SecondDeviceConnectConfirmationYesMsg& oMsg);
      bool onCourierMessage(const SecondDeviceConnectConfirmationNOMsg& oMsg);

      virtual void onDiPOAppStatusInfoError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::midw_smartphoneint_fi::DiPOAppStatusInfoError >& error);
      virtual void onDiPOAppStatusInfoStatus(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                             const ::boost::shared_ptr< ::midw_smartphoneint_fi::DiPOAppStatusInfoStatus >& status);

      virtual void onCallStatusNoticeError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
                                           const ::boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeError >& error);
      virtual void onCallStatusNoticeStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
                                            const ::boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeStatus >& status);

      virtual void onConflictsDetectedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
                                            const ::boost::shared_ptr< ::MOST_BTSet_FI::ConflictsDetectedError >& error);
      virtual void onConflictsDetectedStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
                                             const ::boost::shared_ptr< ::MOST_BTSet_FI::ConflictsDetectedStatus >& status);

      virtual void onResolveConflictsError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
                                           const ::boost::shared_ptr< ::MOST_BTSet_FI::ResolveConflictsError >& error);
      virtual void onResolveConflictsResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
                                            const ::boost::shared_ptr< ::MOST_BTSet_FI::ResolveConflictsResult >& result);

      virtual void onAccessoryAppStateError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::midw_smartphoneint_fi::AccessoryAppStateError >& error);
      virtual void onAccessoryAppStateResult(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy,
                                             const ::boost::shared_ptr< ::midw_smartphoneint_fi::AccessoryAppStateResult >& result);

      void vInitialize();
      DataBindingItem<SPI_PFO_2ndDev_Conf_PopupDataBindingSource> _SPI_PFO_2ndDev_Conf_Popup;

      static AccessoryAppStateHandler* getInstance(ConnectionClientHandler* pConnectionClientHandler)
      {
         if (NULL == _accessoryAppStateHandler)
         {
            _accessoryAppStateHandler = new AccessoryAppStateHandler(pConnectionClientHandler);
         }
         return _accessoryAppStateHandler;
      }

      struct DipoAppState
      {
         bool DipoAppPhoneState_Flag;  //Flag to check whether the phone is active or not
         bool DipoAppSpeechState_Flag; //Flag to check whether the siri is active or not
         bool isSPIState;  //Flag to check the target is in projection or not
      } DIPO_APP_STATE;

      void setAccessoryAppState();
      enSpeechAppState getDIPOSpeechStatus();
      enPhoneAppState  getDIPOPhoneStatus();
      enNavigationAppState getDIPONaviStatus();

      void setNativePhoneAppState(enPhoneAppState speechAppState);
      void setNativeSpeechAppState(enSpeechAppState speechAppState);
      void setNativeNaviAppState(enNavigationAppState naviAppState);
      enPhoneAppState getNativePhoneAppState();
      enSpeechAppState getNativeSpeechAppState();
      enNavigationAppState getNativeNaviAppState();

   private :

      enPhoneAppState evaluateBTTelCallStatus(const boost::shared_ptr< ::MOST_Tel_FI::CallStatusNoticeStatus >& status);
      enPhoneAppState evaluateCallInstance1(uint8 u8NewCallState1);
      enPhoneAppState evaluateCallInstance2(uint8 u8NewCallState2);
      ConnectionClientHandler* _connectionClientHandler;
      ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy> _smartphoneFIProxy;
      ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > _spiTelephoneProxy;
      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _spiBTSetProxy;
      static AccessoryAppStateHandler* _accessoryAppStateHandler;

      tU32 m_tU32ConflictTrigger;
      enSpeechAppState _meSpeechAppState;
      enSpeechAppState _meDIPOSpeechAppState; //iPhone Siri status
      enPhoneAppState  _mePhoneAppState;
      enPhoneAppState  _meDIPOPhoneAppState;  //iPhone Phone status
      enNavigationAppState _meNavigationAppState;
      enNavigationAppState _meDIPONaviAppState; //iPhone Navi status
};


} //namespace Core
} //namespace App

#endif  /* _ACCESSORY_APPSTATE_HANDLER_H_*/
