/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_PhoneMessages.h"
// the views
#include "CGIAppViewController_Phone.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            HMI::CGIComponents::CGIAppViewFactory::
#include "trcGenProj/Header/CGIAppViewFactory.cpp.trc.h"
#endif

SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_P_Layout),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_P_12_CHAR_LAYOUT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER__GADGET_PHONE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER__GADGET_PHONE_NON_NAVI),
//SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MyDummyScene),
// simple view controller from AppHmi_BTPhone_SimpleViewController.h have not to be added here
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   ETG_TRACE_USR4((" CGIAppViewFactory::Create1 %s", sViewName));
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   ETG_TRACE_USR4((" CGIAppViewFactory::Destroy %s", pView));
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   ETG_TRACE_USR4((" CGIAppViewFactory::Destroy %s", viewController));
   COURIER_UNUSED(viewController);
}
