/* ***************************************************************************************
* FILE:          CGIAppViewController_Phone.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_Phone.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_PHONE_H)
#define _CGIAPPVIEWCONTROLLER_PHONE_H

#include "CgiExtensions/ViewControllerBase.h"
#include "AppHmi_Phone_SimpleViewController.h"
#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
		{\
		private:\
		courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
		tController() {}\
		virtual ~tController() {}\
		static const char* _name;\
		static Courier::ViewController* createInstance()\
		{\
			return COURIER_NEW(tController)();\
		}\
		};


SIMPLE_CONTROLLER(CGIAppViewController_Pfo_IncomingCall)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PassiveDeviceIncomingCall)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceConnected)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceListFull)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_JustWorksPairing)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_JustWorksPairingWaiting)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_NumCompPairing)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_ConnectionFailed)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PairingInitiate)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceConnecting)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_WaitForConfirmation)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SMS)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PhonebookDLIncomplete)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SMSExpand)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceDisConnected)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PhonebookDLFailed)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeleteDeviceConfirmation)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceDeleted)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceDeleting)
SIMPLE_CONTROLLER(CGIAppViewController_P_Layout)
SIMPLE_CONTROLLER(CGIAppViewController_P_12_CHAR_LAYOUT)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER__GADGET_PHONE)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER__GADGET_PHONE_NON_NAVI)
SIMPLE_CONTROLLER(CGIAppViewController_SR_SIRI_Main)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Intercom_IncomingCall)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_Intercom_RTP_stream_failure)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MIC_CallHistory_Contacts)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MIC_IntercomCall)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MIC_PhoneCall)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_DeviceDisconnectConfirmation)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SIRI_EyeFree)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PriorityCall_BT)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PriorityCall_Intercom)

#endif // _CGIAPPVIEWCONTROLLER_PHONE_H
