/* ***************************************************************************************
* FILE:          CGIAppPopupTable.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppPopupTable.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"

#include "ProjectBaseTypes.h"
#include "CGIAppViewController_Phone.h"
#include "AppHmi_Phone_SimpleViewController.h"

POPUP_TABLE_BEGIN() // modality, prio, presTime, minTime, validityPeriod, closeOnSuperseded, bCloseOnAppLeave, surfaceID, _controllerClass_
POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_IncomingCall),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PassiveDeviceIncomingCall),
//POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 10, 0, 2000, 0, false, false, SURFACEID_NNN, CGIAppViewController_ABC")
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceListFull),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_JustWorksPairing),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_JustWorksPairingWaiting),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_NumCompPairing),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_ConnectionFailed),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceConnecting),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PairingInitiate),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_WaitForConfirmation),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 7, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_SMS),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PhonebookDLIncomplete),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 7, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_SMSExpand),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceDisConnected),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PhonebookDLFailed),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeleteDeviceConfirmation),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 3000, 2000, 0, true, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceDeleted),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 3000, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceDeleting),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceConnected),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_SR_SIRI_Main),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_Intercom_IncomingCall),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_Intercom_RTP_stream_failure),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_MIC_CallHistory_Contacts),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_MIC_IntercomCall),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 6, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_MIC_PhoneCall),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_DeviceDisconnectConfirmation),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_SIRI_EyeFree),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PriorityCall_BT),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_PHONE, CGIAppViewController_Pfo_PriorityCall_Intercom)

//POPUP_TABLE_ENTRY_DUMMY()
                  POPUP_TABLE_END()
