/************************************************************************
*FILE: 			 Apphmi_PhoneTtfisHmiCmdHandler.cpp
*SW-COMPONENT:  HMI
*DESCRIPTION: 	 Defines the class btphn_tclApphmiPhoneTtfisHmiCmdHandler which
*               handles TTFis input commands (that simulates HMI user actions)
*AUTHOR:        Supriya
*COPYRIGHT:     (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*HISTORY:
*03.22.2018 Rev. 0.1 Supriya Seshadri
* 		    Initial Revision.
************************************************************************/
/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "TTFisCmdHandler/Apphmi_PhoneTtfisHmiCmdHandler.h"
#include "../../../../../../../di_trace/components/etg/etg.h"
#include "App/datapool/PhoneDataPoolConfig.h"
#include "ServiceMsg.h"


#include <unistd.h>

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_PHONE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_PHONE_"
#define ETG_I_FILE_PREFIX                 App::Core::Apphmi_PhoneTtfisHmiCmdHandler::
#include "trcGenProj/Header/Apphmi_PhoneTtfisHmiCmdHandler.cpp.trc.h"
#endif

using namespace ::App::Core;

/*****************************************************************
| function implementation (scope: global)
|----------------------------------------------------------------*/

/************************************************************************
*FUNCTION:      Apphmi_Phone_TtfisHmiCmdHandler
*DESCRIPTION:   Constructor
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
************************************************************************/
namespace App {
namespace Core {

Apphmi_PhoneTtfisHmiCmdHandler::Apphmi_PhoneTtfisHmiCmdHandler()
{
   ETG_TRACE_USR4(("Apphmi_Phone_TtfisHmiCmdHandler()"));
}


/************************************************************************
*FUNCTION:      ~Apphmi_Phone_TtfisHmiCmdHandler
*DESCRIPTION:   Destructor
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
************************************************************************/

Apphmi_PhoneTtfisHmiCmdHandler::~Apphmi_PhoneTtfisHmiCmdHandler()
{
   ETG_TRACE_USR4(("~Apphmi_Phone_TtfisHmiCmdHandler()"));
}


/************************************************************************
*FUNCTION:      initialize
*DESCRIPTION:   Initialise fnction of tracehandler
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
************************************************************************/
void Apphmi_PhoneTtfisHmiCmdHandler::initialize()
{
   ETG_TRACE_COMP(("TraceCommandHandler::initialize() "));
   ETG_I_REGISTER_FILE();
}


/************************************************************************
*FUNCTION:      traceCmd_optionKeyRespCmd
*DESCRIPTION:   Handles TTFis command for Option Select
*PARAMETER:
*			       pu8Data:  (->I)
*                  TTFis input data (command parameters)
*
*RETURNVALUE:   tVoid
*
*HISTORY:
*Rev 0.1 Initial Revision.
************************************************************************/

ETG_I_CMD_DEFINE((traceCmd_settingsKey, "SettingsKey"))
void Apphmi_PhoneTtfisHmiCmdHandler::traceCmd_settingsKey()
{
   ETG_TRACE_COMP(("traceCmd_settingsKey()"));

   OptionKeyResp* poOptionKeyResp = COURIER_MESSAGE_NEW(OptionKeyResp)();
   if (NULL != poOptionKeyResp)
   {
      ETG_TRACE_COMP(("Sending 'OptionKeyResp' message"));

      tBool bRetVal = poOptionKeyResp->Post();
      if (FALSE == bRetVal)
      {
         ETG_TRACE_COMP(("Sending 'OptionKeyResp' message failed"));
      }
   }
}


ETG_I_CMD_DEFINE((traceCmd_ChangeMessageSettings, "ChangeMessageSettings"))
void Apphmi_PhoneTtfisHmiCmdHandler::traceCmd_ChangeMessageSettings()
{
   ETG_TRACE_COMP(("traceCmd_ChangeMessageSettings()"));
   ServiceMsg::poGetInstance()->vOnChangeSMSSettings();
}


ETG_I_CMD_DEFINE((traceCmd_ActivateBtVR, "ActivateBtVR"))
void Apphmi_PhoneTtfisHmiCmdHandler::traceCmd_ActivateBtVR()
{
   ETG_TRACE_COMP(("traceCmd_ActivateBtVR()"));
   SmartPhoneClient::getInstance()->vHandleKeyEvent();
//ServiceTel::poGetInstance()->vHandleKeyEvent();
}


ETG_I_CMD_DEFINE((traceCmd_StartBtVRSession, "StartBtVRSession"))
void Apphmi_PhoneTtfisHmiCmdHandler::traceCmd_StartBtVRSession()
{
   ETG_TRACE_COMP(("traceCmd_StartBtVRSession()"));
//	SmartPhoneClient::getInstance()->vHandleKeyEvent();
   ServiceTel::poGetInstance()->vStartBTVRSessionViaPTT();
}


}
}


/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
