/* ***************************************************************************************
* FILE:          HMIModelComponent.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIModelComponent.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_PHONEBOOK_MODEL_COMPONENT_H)
#define _PHONEBOOK_MODEL_COMPONENT_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "BTPhoneDefines.h"
#include "AppHmiPhone_Helper.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#include "PhoneBookDataTypes.h"
#include "App/datapool/PhoneDataPoolConfig.h"

using namespace Courier;

namespace App {
namespace Core {
class PhonebookModelComponent :  public ListImplementation
{
   private:
      PhonebookModelComponent();
      PhonebookModelComponent& operator=(const PhonebookModelComponent&);
      PhonebookModelComponent(const PhonebookModelComponent&);

      static PhonebookModelComponent* m_poPhonebookModelComponent;

      /*	Binding source to update the List Id */
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID;

      /*	Binding source to update the List Size */
      DataBindingItem<ListDataSizeDataBindingSource>m_ListDataSize;

      /*Binding source to update the Header contact name */
      DataItemContainer<ContactCallNameDataBindingSource> oContactCallName;

      /*Binding source to update List Status  */
      DataItemContainer<IsListNotemptyDataBindingSource> oIsListNotempty;

      DataItemContainer<SettingsDataBindingSource> oSettings;

      DataItemContainer<LoadingAnimationInfoDataBindingSource> oLoadingAnimation;
      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      FeatStd::UInt32	m_rotationEndValue_Phonebook;
      FeatStd::UInt32	m_rotationStartValue_Phonebook;
      FeatStd::UInt32	m_rotationEndValue_Calllist;
      FeatStd::UInt32	m_rotationStartValue_Calllist;

      bool m_isMessageSettingEnabled; //Flag to check if settings are enabled or disabled
      bool m_isRingtoneSettingsEnabled;//Flag to check if settings are enabled or disabled
      bool m_isSortOrderAvailable;//Flag to check if settings are enabled or disabled

   public:
      enPhoneSettingModeOption _currentPhoneValOption;
      Candera::String _currentPhoneModeOptionStr;

      /* for singleton implementation */
      static PhonebookModelComponent* poGetInstance()
      {
         if (NULL == m_poPhonebookModelComponent)
         {
            m_poPhonebookModelComponent = new PhonebookModelComponent();
         }
         return m_poPhonebookModelComponent;
      }

      virtual ~PhonebookModelComponent();
      bool Init();

      /*creates Phonebook list rows with valid data and updates it to GUI*///(SWFL - 706, SWFL - 1944)
      void OnUpdContactListSlice(std::vector<btphn_trContactInfo>& arContactListSlice, tU16 u16PBStartIndex,
                                 tU16 lastItemIndex_PBList, tU16 u16TotalListSize, tBool bLoadPersistent, tU32 m_U8ViewPortStartIndex);
      /*updates phonebook list size data binding property*///SWFL-706
      void OnUpdContactListSizeToModel(tU16 corfu16TotalListSize);
      /*creates detailed contact list rows with valid data and updates it to GUI*/
      //void OnUpdGetContactDetails(std::string copcFirstName, std::string copcLastName, std::string acopcContactNumbers[], tU8 ContactDetailType[]);
      void OnUpdGetContactDetails(std::string copcFirstName, std::string copcLastName, std::vector<btphn_trContactCallDetail>& arDetailedContactNum);// (SWFL - 1946)
      /*updates the header contact name in the detailed contact list scene to GUI*///(SWFL - 706, SWFL - 1944)
      void vUpdateHeaderContactName(std::string copcFirstName, std::string copcLastName);
      void OnUpdSortOrder();
      void OnUpdSettingsList();
      //void OnUpdChangeDropdown(Candera::String Sort);

      /*Setter age getter for Ring tone */
      void vSetUsePhoneRingtone(tU8 CheckBoxStatus);

      tU8 u8GetUsePhoneRingtone()
      {
         return (*oSettings).mUsePhoneRingtone_IsSelected;
      }

      void vSetSortOrder(std::string  strSortOrder, bool isLastName);

      std::string strGetSortOrder()
      {
         return ((*oSettings).mSortPhoneBookTypeText).GetCString();
      }

      /*setter and getter for band support info*/
      void vSetBandSupport(tBool value)
      {
         (*oSettings).mIsInBandSupported = value;
         oSettings.MarkItemModified(ItemKey::Settings::IsInBandSupportedItem);
         oSettings.SendUpdate(true);
      }

      tBool bGetBandSupport()
      {
         return (*oSettings).mIsInBandSupported;
      }

      /*setter and getter for incoming message*/
      void vSetShowIncomingMessage(tU8 value)
      {
         //if m_isMessageSettingEnabled is disabled, the checkboxes to be updated as checkeddisabled and uncheckeddisable
         if (!m_isMessageSettingEnabled)
         {
            if (BTPHN_C_CHECKED == value)
            {
               value = BTPHN_C_CHECKEDDISABLE;
            }
            else if (BTPHN_C_UNCHECKED == value)
            {
               value = BTPHN_C_UNCHECKEDDISABLE;
            }
         }
         (*oSettings).mShowIncomingText_IsSelected = value;
         oSettings.MarkItemModified(ItemKey::Settings::ShowIncomingText_IsSelectedItem);
         oSettings.SendUpdate(true);
      }

      tU8 bGetShowIncomingMessage()
      {
         return (*oSettings).mShowIncomingText_IsSelected;
      }

      void OnUpdChangeRingtoneStatus(tU16 corfu16RingtoneID);
      void vClearContactList();
      void OnUpdChannel1_PhonebookLoading();
      void OnUpdChannel1_CalllistLoading();

      //As part of new Phone settings implementation, to dynamically disable/enable the phone settings
      void vChangeActivationOfMessageSetting(bool bEnable);
      void vChangeActivationOfSortOrderSetting(bool bEnable);
      void vChangeActivationOfRingtoneSetting(bool bEnable);
      uint16 vReadVehicleVariant(); //Read the variant of the vehicle smart/inf4cv
};


}//Namespace Core
}//Namespace App

#endif // _PHONEBOOK_MODEL_COMPONENT_H
