/* ***************************************************************************************
* FILE:          PhoneGadgetModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PhoneGadgetModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_PHONEGADGET_MODEL_H)
#define _PHONEGADGET_MODEL_H
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"


using namespace Courier;

namespace App {
namespace Core {
class PhoneGadgetModel
{
   private:
      PhoneGadgetModel& operator=(const PhoneGadgetModel&);
      PhoneGadgetModel(const PhoneGadgetModel&);
      static PhoneGadgetModel* m_poPhoneGadgetModel;

      bool m_bIsBluetoothEnabled;
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      bool m_bIsIntercomAvailable;
#endif


      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      // For Future implemenation
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      // update Tile Status of Phone Component
      bool UpdatePhoneTileInfo();

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      // update Tile Status of Phone Component
      bool UpdateIntercomTileInfo();
#endif

      //Phone Gadget Data binding
      Courier::DataItemContainer<PhoneGadgetInfoDataBindingSource> _phoneGadgetInfoData;

   protected:
      PhoneGadgetModel();

   public:
      static PhoneGadgetModel* poGetInstance()
      {
         if (NULL == m_poPhoneGadgetModel)
         {
            m_poPhoneGadgetModel = new PhoneGadgetModel();
         }
         return m_poPhoneGadgetModel;
      }
      ~PhoneGadgetModel();

      bool UpdatePhoneGadgetInfo();

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      void SetIntercomStatus(bool bIsIntercomAvailable)
      {
         //if(m_bIsIntercomAvailable != bIsIntercomAvailable)
         //{
         m_bIsIntercomAvailable = bIsIntercomAvailable;
         UpdatePhoneGadgetInfo();
         // }
      }

      bool GetIntercomStatus()
      {
         return m_bIsIntercomAvailable;
      }
#endif

      bool SetPhoneStatus(bool bIsBluetoothEnabled)
      {
         m_bIsBluetoothEnabled = bIsBluetoothEnabled;
         return UpdatePhoneGadgetInfo();
      }
};


}//Namespace Core
}//Namespace App

#endif
