/* ***************************************************************************************
* FILE:          PhoneGadgetModel.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PhoneGadgetModel.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneConstants.h"
#include "PhoneGadgetModel.h"
#include "DeviceListModel.h"
#include "App/Core/BTSetting/ServiceBT.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "../Intercom/IntercomClienthandler.h"
#endif
#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::PhoneGadgetModel::
#include "trcGenProj/Header/PhoneGadgetModel.cpp.trc.h"
#endif

namespace App {
namespace Core {


PhoneGadgetModel* PhoneGadgetModel::m_poPhoneGadgetModel = NULL;

#define SM_ACTIVE_SRC_PHONE 0
#define SM_ACTIVE_SRC_INTERCOM 1
#define GADGET_PHONE_CONTENT 0
#define GADGET_INTERCOM_CONTENT 1
#define INTERCOM_NOT_AVAILABLE 0
#define INTERCOM_AVAILABLE 1
#define GADGET_BG_ENABLED 0
#define GADGET_BG_DISABLED 1
#define INTERCOM_PHONE_ICON 4
#define PHONE_INTERCOM_ICON 5
#define PHONE_SPI_SESSION_ICON 3
#define PHONE_ICON 1

/************************************************************************
*FUNCTION: 	   PhoneGadgetModel
*DESCRIPTION:  Constructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY: Vidya K

Initial Revision

************************************************************************/
PhoneGadgetModel::PhoneGadgetModel():
   m_bIsBluetoothEnabled(false)
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   , m_bIsIntercomAvailable(false)
#endif
{
}


/************************************************************************
*FUNCTION: 	   ~PhoneGadgetModel
*DESCRIPTION:  Destructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY:Vidya K
Initial Revision

************************************************************************/
PhoneGadgetModel::~PhoneGadgetModel()
{
}


/************************************************************************
* @brief   : Incomming message for HMI data model a message component
* @param   :
************************************************************************/

bool PhoneGadgetModel::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("PhoneGadgetModel::onCourierMessage(StartupMsg)"));

   return true;
}


bool PhoneGadgetModel::UpdatePhoneGadgetInfo()
{
   if (SM_ACTIVE_SRC_PHONE == Sm_ActiveSource)
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneGadgetInfo() - Active Source - Phone"));
      UpdatePhoneTileInfo();
   }
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   else if (SM_ACTIVE_SRC_INTERCOM == Sm_ActiveSource)
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneGadgetInfo() - Active Source - Intercom "));
      UpdateIntercomTileInfo();
   }
#endif
   else
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneGadgetInfo() - Invalid Active Source"));
   }
   return true;
}


bool PhoneGadgetModel::UpdatePhoneTileInfo()
{
   ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo()"));
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
   if (false == ServiceBT::poGetInstance()->GetBluetoothOnOffStatus())
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo() - BT is Turn OFF "));
      if (SM_ACTIVE_SRC_PHONE == Sm_ActiveSource)
      {
         ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo :: Active Source is BT now so BT Tile Disable"));
         DeviceListModel::poGetInstance()->OnUpdBTONOFFStatus(false);
      }
      (*_phoneGadgetInfoData).mIndexForGadgetBG = GADGET_BG_DISABLED;
   }
   else
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo() - BT is Turn ON "));
      if (SM_ACTIVE_SRC_PHONE == Sm_ActiveSource)
      {
         ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo :: Active Source is BT now so BT Tile Enable"));
         DeviceListModel::poGetInstance()->OnUpdBTONOFFStatus(true);
      }
      (*_phoneGadgetInfoData).mIndexForGadgetBG = GADGET_BG_ENABLED;
   }
#endif
   if ((g_SM_SpiSessionStatus == SPI_SESSION_ANDROID_AUTO_ACTIVE) || (g_SM_SpiSessionStatus == SPI_SESSION_CARPLAY_ACTIVE))
   {
      (*_phoneGadgetInfoData).mPhoneHandle = PHONE_SPI_SESSION_ICON;
   }
   else
   {
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      (*_phoneGadgetInfoData).mPhoneHandle = PHONE_INTERCOM_ICON; //m_u8PhoneCurrentHandle;

#else
      (*_phoneGadgetInfoData).mPhoneHandle = PHONE_ICON;
#endif
   }
   (*_phoneGadgetInfoData).mIndexForGadgetContent = GADGET_PHONE_CONTENT;
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::IndexForGadgetBGItem);
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::IndexForGadgetContentItem);
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::PhoneHandleItem);
   _phoneGadgetInfoData.SendUpdate(true);
   return true;
}


#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
bool PhoneGadgetModel::UpdateIntercomTileInfo()
{
   ETG_TRACE_USR4(("PhoneGadgetModel::UpdateIntercomTileInfo()"));
   if (false == m_bIsIntercomAvailable)
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo() - Intercom is Turn OFF "));
      DeviceListModel::poGetInstance()->OnUpdBTONOFFStatus(false);
      (*_phoneGadgetInfoData).mIndexForIntercomTextInfo = INTERCOM_NOT_AVAILABLE;
      (*_phoneGadgetInfoData).mIndexForGadgetBG = GADGET_BG_DISABLED;
   }
   else
   {
      ETG_TRACE_USR4(("PhoneGadgetModel::UpdatePhoneTileInfo() - Intercom is Turn ON "));
      DeviceListModel::poGetInstance()->OnUpdBTONOFFStatus(true);
      (*_phoneGadgetInfoData).mIndexForIntercomTextInfo = INTERCOM_AVAILABLE;
      (*_phoneGadgetInfoData).mIndexForGadgetBG = GADGET_BG_ENABLED;
   }
   (*_phoneGadgetInfoData).mIndexForGadgetContent = GADGET_INTERCOM_CONTENT;
   (*_phoneGadgetInfoData).mPhoneHandle = INTERCOM_PHONE_ICON;
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::IndexForIntercomTextInfoItem);
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::IndexForGadgetBGItem);
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::IndexForGadgetContentItem);
   _phoneGadgetInfoData.MarkItemModified(ItemKey::PhoneGadgetInfo::PhoneHandleItem);
   _phoneGadgetInfoData.SendUpdate(true);

   return true;
}


#endif
}


}
