#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
/* ***************************************************************************************
* FILE:          IntercomModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IntercomModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_INTERCOM_MODEL_H)
#define _INTERCOM_MODEL_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "PhoneBookDataTypes.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#include "../Intercom/IntercomDataTypes.h"

using namespace Courier;

namespace App {
namespace Core {
class IntercomModel : virtual public ListImplementation
{
   private:
      IntercomModel& operator=(const IntercomModel&);
      IntercomModel(const IntercomModel&);
      static IntercomModel* m_poIntercomModel;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      bool m_bInoPhoneConnectedStatus; //Variable to update the No Intercom phone connected status
      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);

      DataBindingItem<IntercomIncomingCallDataBindingSource>oIntercomIncomingCall;// Databinding to update the incoming call caller info
      DataBindingItem<IntercomCallProgressDataBindingSource>oIntercomCallProgress; // Databinding to update the ongoing call caller info
      DataItemContainer<NetworkOperatorDataBindingSource>oOperatorName; //Databinding to update the Intercom connection status
      DataBindingItem<PhoneStatusDataBindingSource> oPhoneStatus; //Databinding to block the BT phone connected information
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID; //Databinding to update the I_Contats list id
      DataBindingItem<ListDataSizeDataBindingSource>m_ListDataSize; //Databinding to update the I_Contats list size
      DataBindingItem<AddCallEnableDataBindingSource>oAddCallEnable; // Databinding to enable or disable conference call option
      DataItemContainer<CallProgressDataBindingSource> oCallProgress; //Databinding to update the ongoing call caller info
      DataBindingItem<IntercomMissedIncomingCallDataBindingSource>oIntercomMissedIncomingCall; //Databinding to update the Intercom missed call caller id
      DataBindingItem<PrivateModeStatusDataBindingSource>oPrivateModeStatus; // Databinding to update the Privatemode On or OFF status

   protected:
      IntercomModel();

   public:
      static IntercomModel* poGetInstance()
      {
         if (NULL == m_poIntercomModel)
         {
            m_poIntercomModel = new IntercomModel();
         }
         return m_poIntercomModel;
      }
      ~IntercomModel();

      bool Init();

      bool OnUpdIncomingCallStatus(Candera::String strCallerID, tU16 U16ContactType); // Function for updating the intercom incoming call details
      void OnUpdPrivatemode(bool bPrivatemodevalue); // Function for updating the private mode status
      bool OnUpdCallProgressStatus(Candera::String strCallProgressId, tU16 u16CallProgressContactType); // Function for updating the caller details of ongoing intercom call
      void vSetIntercomActive(); // Function to update the Intercom tile on toggle
      void OnUpdIntercomContactList(IntercomContactinfo arContactinfo[3], tU16 U16Isize); //Function to display the intercom contacts list
      void OnUpdIntercomConferenceCallListStatus(IntercomContactinfo arConfCalllist[3], tU16 U16Isize); //  Function to display the intercom conference caller info list
      void OnUpdMissedICallerId(Candera::String strMissedCallerID); // Function to display the intercom missed call info
      void OnUpdIntercomNoPhoneConnected(bool IntercomPhonestatus); //Function to display the intercom connection status
      std::string replaceInTranslationTextID(std::string, std::string, std::string); //Function to update the dynamic string in the text id
};


}//Namespace Core
}//Namespace App

#endif
#endif
