#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
/* ***************************************************************************************
* FILE:          IntercomModel.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IntercomModel.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneConstants.h"
#include "IntercomModel.h"
#include "../Intercom/IntercomClienthandler.h"
#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_PHONE_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::PhoneIntercomModel::
#include "trcGenProj/Header/IntercomModel.cpp.trc.h"
#endif

namespace App {
namespace Core {


IntercomModel* IntercomModel::m_poIntercomModel = NULL;
#define ONE "1"
#define TWO "2"
#define THREE "3"
/************************************************************************
*FUNCTION: 	   IntercomModel
*DESCRIPTION:  Constructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY: Vidya K

Initial Revision

************************************************************************/
IntercomModel::IntercomModel():
   m_bInoPhoneConnectedStatus(false)
{
}


/************************************************************************
*FUNCTION: 	   ~IntercomModel
*DESCRIPTION:  Destructor
*PARAMETER: NA
*
*RETURNVALUE: 	NA
*
*HISTORY:Vidya K
Initial Revision

************************************************************************/
IntercomModel::~IntercomModel()
{
}


bool IntercomModel::Init()
{
   return true;
}


/************************************************************************
* @brief   : Incomming message for HMI data model a message component
* @param   :
************************************************************************/

bool IntercomModel::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   ETG_TRACE_USR4(("IntercomModel::onCourierMessage(StartupMsg)"));
   (*m_ListDataSize).mIContactsSize = BTPHN_C_VALUE_ZERO;
   (*m_ListID).mIntercomContactsListId = LISTID_ICONTACTS;
   m_ListID.MarkItemModified(ItemKey::ListId_Flex::IntercomContactsListIdItem);
   m_ListID.SendUpdate(true);
   m_ListDataSize.MarkItemModified(ItemKey::ListDataSize::IContactsSizeItem);
   m_ListDataSize.SendUpdate(true);

   return true;
}


/************************************************************************
*FUNCTION:  : OnUpdIncomingCallStatus
*DESCRIPTION:  Updates intercom incoming call details to GUI
*PARAMETER :	caller id, contacttype
*RETURNVALUE: 	bool
************************************************************************/
bool IntercomModel::OnUpdIncomingCallStatus(Candera::String strCallerID, tU16 U16ContactType)
{
   ETG_TRACE_USR4(("IntercomModel::OnUpdIncomingCallStatus"));
   (*oIntercomIncomingCall).mCallerID = strCallerID;
   (*oIntercomIncomingCall).mContactType = U16ContactType;
   oIntercomIncomingCall.MarkAllItemsModified();
   oIntercomIncomingCall.SendUpdate(true);
   return true;
}


/************************************************************************
*FUNCTION:  : OnUpdCallProgressStatus
*DESCRIPTION:  Updates intercom ongoing call details to GUI
*PARAMETER :	caller id, contacttype
*RETURNVALUE: 	bool
************************************************************************/
bool IntercomModel::OnUpdCallProgressStatus(Candera::String strCallProgressId, tU16 u16CallProgressContactType)
{
   ETG_TRACE_USR4(("IntercomModel::OnUpdCallProgressStatus"));
   (*oIntercomCallProgress).mCallerID = strCallProgressId;
   (*oIntercomCallProgress).mContactType = u16CallProgressContactType;
   oIntercomCallProgress.MarkAllItemsModified();
   oIntercomCallProgress.SendUpdate(true);
   return true;
}


/************************************************************************
*FUNCTION:  : OnUpdIntercomNoPhoneConnected
*DESCRIPTION:  Updates intercom connection status to GUI
*PARAMETER :	IntercomPhonestatus
*RETURNVALUE: 	NA
************************************************************************/
void IntercomModel::OnUpdIntercomNoPhoneConnected(bool IntercomPhonestatus)
{
   ETG_TRACE_USR4(("IntercomModel::OnUpdIntercomNoPhoneConnected"));
   m_bInoPhoneConnectedStatus = IntercomPhonestatus;
   vSetIntercomActive();
}


/************************************************************************
*FUNCTION:  : vSetIntercomActive
*DESCRIPTION:  Updates intercom tile on toggle in homescreen
*PARAMETER :	NA
*RETURNVALUE: 	NA
************************************************************************/
void IntercomModel::vSetIntercomActive()
{
   ETG_TRACE_USR4(("IntercomModel::vSetIntercomActive"));
   /* Define vector values for extended "no phone connected/bluetooth off/Intercom" text node as to dynamically change the maximum size of text node */
   Candera::Vector2 textNodesizeExtended(DEVNAME_TEXTNODE_EXTENDED_MAXSIZE_X, DEVNAME_TEXTNODE_EXTENDED_MAXSIZE_Y);
   if (Sm_ActiveSource == 1)
   {
      ETG_TRACE_USR4(("IntercomModel :: Sm_ActiveSource == 1"));
      if (true == m_bInoPhoneConnectedStatus)
      {
         ETG_TRACE_USR4(("IntercomModel :: Intercom not Connected"));
         (*oOperatorName).mOperatorName = Candera::String(TextId_0x1A20);
      }
      else
      {
         ETG_TRACE_USR4(("IntercomModel :: Intercom Connected"));
         (*oOperatorName).mOperatorName = Candera::String(TextId_0x14B1);//"Intercom";
      }
      /* On Intercom connection, set the extended text node x-y maximum values*/
      (*oOperatorName).mTextNodeMaxSize = textNodesizeExtended;
      oOperatorName.MarkAllItemsModified();
      bool bRet = oOperatorName.SendUpdate(true);
      if (TRUE == bRet)
      {
         ETG_TRACE_USR4(("IntercomModel :: Data binding update successful"));
      }
      else
      {
         ETG_TRACE_USR4(("IntercomModel :: Data binding update failed"));
      }
   }
   else
   {
      ETG_TRACE_USR4(("Sm_ActiveSource == 0"));
   }
   (*oPhoneStatus).mMissedCallStatus = 0;
   (*oPhoneStatus).mBatteryStatus = 6;
   (*oPhoneStatus).mBatteryStatusinGadget = 6;
   (*oPhoneStatus).mSignalStatusinGadget = 6;

   oPhoneStatus.MarkAllItemsModified();
   bool bReturnValue = oPhoneStatus.SendUpdate(true);
   if (TRUE == bReturnValue)
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update successful"));
   }
   else
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update failed"));
   }
}


/************************************************************************
*FUNCTION:  : OnUpdPrivatemode
*DESCRIPTION:  Updates private mode status to GUI
*PARAMETER :	bPrivatemodevalue
*RETURNVALUE: 	NULL
************************************************************************/
void IntercomModel::OnUpdPrivatemode(bool bPrivatemodevalue)
{
   ETG_TRACE_USR4(("IntercomModel : OnUpdPrivatemode "));
   ETG_TRACE_USR4(("IntercomModel : OnUpdPrivatemode bPrivatemodevalue =%d", bPrivatemodevalue));
   (*oPrivateModeStatus).mIsSelected = bPrivatemodevalue;

   oPrivateModeStatus.MarkAllItemsModified();
   bool bReturnValue = oPrivateModeStatus.SendUpdate(true);
   if (true == bReturnValue)
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update successful"));
   }
   else
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update failed"));
   }
}


/************************************************************************
*FUNCTION:  : OnUpdMissedICallerId
*DESCRIPTION:  Updates intercom missed call details to GUI
*PARAMETER :	strMissedCallerID
*RETURNVALUE: 	NA
************************************************************************/
void IntercomModel::OnUpdMissedICallerId(Candera::String strMissedCallerID)
{
   ETG_TRACE_USR4(("IntercomModel : OnUpdMissedICallerId "));
   std::string strMissedCallInfo = Candera::String(TextId_0x1962).GetCString();
   std::string strMissedCallId = Candera::String(strMissedCallerID).GetCString();
   (*oIntercomMissedIncomingCall).mMissedCallerInfo = (replaceInTranslationTextID(strMissedCallInfo, strMissedCallId, "%1")).c_str();
   oIntercomMissedIncomingCall.MarkAllItemsModified();
   bool bReturnValue = oIntercomMissedIncomingCall.SendUpdate(true);
   if (true == bReturnValue)
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update successful"));
   }
   else
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update failed"));
   }
}


/************************************************************************
*FUNCTION:  : replaceInTranslationTextID
*DESCRIPTION:  searches the required string in the translation string and replaces with needed string
EX: to replace %1 in the given text id with the dynamic data coming from clienthandler
*PARAMETER :	TranslationStr, StrForReplace strToSearch
*RETURNVALUE: 	string
************************************************************************/
std::string IntercomModel::replaceInTranslationTextID(std::string TranslationStr, std::string StrForReplace, std::string strToSearch)
{
   if (TranslationStr.find(strToSearch) != std::string::npos)
   {
      TranslationStr.replace(TranslationStr.find(strToSearch), strToSearch.size(), StrForReplace);
   }
   return TranslationStr;
}


/************************************************************************
*FUNCTION:  : OnUpdIntercomContactList
*DESCRIPTION:  Updates the intercom contact list
*RETURNVALUE: 	NA
************************************************************************/

void IntercomModel::OnUpdIntercomContactList(IntercomContactinfo arContactinfo[3], tU16 U16Isize)
{
   ETG_TRACE_USR4(("OnUpdIntercomContactList : OnUpdIntercomContactList "));
   (*m_ListDataSize).mIContactsSize = U16Isize;
   m_ListDataSize.MarkItemModified(ItemKey::ListDataSize::IContactsSizeItem);
   m_ListDataSize.SendUpdate(true);

   tU8 rowVal = 0;

   ListDataProviderBuilder listBuilder(LISTID_ICONTACTS);
   IContactsList_ListItemData ListData[3];

   ETG_TRACE_USR4(("OnUpdIntercomContactList : OnUpdIntercomContactList inside if "));

   for (rowVal = BTPHN_C_DEFAULT_VALUE_ZERO; rowVal < U16Isize;  rowVal++)
   {
      ETG_TRACE_USR4(("OnUpdIntercomContactList : OnUpdIntercomContactList inside for"));

      ListData[rowVal].mIContactName = arContactinfo[rowVal].strCallerId;
      ListData[rowVal].mIContacttype = arContactinfo[rowVal].u16Contacttype;
      ListData[rowVal].mICallStatus = arContactinfo[rowVal].strCallStatus;

      /*adding each row into matched list */
      listBuilder.AddItem(rowVal, 0, "Layer_Intercom_1").AddDataBindingUpdater<IContactsList_ListItemDataBindingSource>(ListData[rowVal]);
   }//end of for loop

   /*Courier message to base class to update the list*/
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
}


/************************************************************************
*FUNCTION:  : OnUpdIntercomConferenceCallListStatus
*DESCRIPTION:  Updates the intercom conference call list
*RETURNVALUE: 	NA
************************************************************************/
void IntercomModel::OnUpdIntercomConferenceCallListStatus(IntercomContactinfo arConfCalllist[3], tU16 U16Isize)
{
   ETG_TRACE_USR4(("IntercomModel:: OnUpdIntercomConferenceCallListStatus"));
   (*m_ListDataSize).mIConfCallSize = U16Isize;
   m_ListDataSize.MarkItemModified(ItemKey::ListDataSize::IConfCallSizeItem);
   m_ListDataSize.SendUpdate(true);

   tU8 rowVal = 0;

   ListDataProviderBuilder listBuilder(LISTID_ICONFCALL);
   IntercomConfCallData ListData[3];

   for (rowVal = BTPHN_C_DEFAULT_VALUE_ZERO; rowVal < U16Isize;  rowVal++)
   {
      ETG_TRACE_USR4(("OnUpdIntercomConferenceCallListStatus inside for"));

      ListData[rowVal].mCallerID = arConfCalllist[rowVal].strCallerId;
      ListData[rowVal].mContactType = arConfCalllist[rowVal].u16Contacttype;
      ListData[rowVal].mCallStatus = arConfCalllist[rowVal].strCallStatus;

      /*adding each row into matched list */
      listBuilder.AddItem(rowVal, 0, "Layer_IntercomConf1").AddDataBindingUpdater<IntercomConfCallDataBindingSource>(ListData[rowVal]);
   }//end of for loop
   if ((*m_ListDataSize).mIContactsSize == (*m_ListDataSize).mIConfCallSize)
   {
      ETG_TRACE_USR4(("IntercomModel:: OnUpdIntercomConferenceCallListStatus Max size reached"));
      (*oAddCallEnable).mAddCallEnable = false ;
   }
   else
   {
      ETG_TRACE_USR4(("IntercomModel:: OnUpdIntercomConferenceCallListStatus Max size not reached"));
      (*oAddCallEnable).mAddCallEnable = true ;
   }
   oAddCallEnable.MarkAllItemsModified();
   bool bReturnValue = oAddCallEnable.SendUpdate(true);
   if (true == bReturnValue)
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update successful"));
   }
   else
   {
      ETG_TRACE_USR4(("IntercomModel :: Data binding update failed"));
   }

   /*Courier message to base class to update the list*/
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
}


}
}


#endif
