/* ***************************************************************************************
* FILE:          DeviceListModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DeviceListModel.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_DEVICELIST_MODEL_H)
#define _DEVICELIST_MODEL_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppHmi_PhoneMessages.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "BTPhoneDefines.h"
#include "AppUtils/HmiMacros.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#include "PhonebookModelComponent.h"
#ifdef WINDOWS_SIMULATION
#include "DeviceList_Stub.h"
#endif


using namespace Courier;

namespace App {
namespace Core {
class DeviceListModel : public ListImplementation
{
   protected:
      /* For singleton implementation*/
      DeviceListModel();
      DeviceListModel& operator=(const DeviceListModel&);
      DeviceListModel(const DeviceListModel&);
   private:
      /*	Binding source to update the List Id */
      DataBindingItem<ListId_FlexDataBindingSource>m_ListID;

      /*	Binding source to update the List Size */
      DataBindingItem<ListDataSizeDataBindingSource>m_ListDataSize;

      /*	Binding source to update the Connected Active BTDevice name */
      DataBindingItem<ConnectedActiveBTDeviceNameDataBindingSource>oConnectedActiveBTDeviceName;

      /*	Binding source to update the Connected BTDevice name */
      DataBindingItem<ConnectedBTDeviceNameDataBindingSource>oConnectedBTDeviceName;

      /*	Binding source to update the Pairing device info */
      DataBindingItem<PairingDeviceInfoDataBindingSource> oPairingDeviceInfo;

      DataBindingItem<Intercom_SupportStatusDataBindingSource> oIntercomSupportstatus;

      /*Binding source to update the Requested DeviceName */
      DataItemContainer<DeviceInfoDataBindingSource> oDeviceInfo;

      /*Binding source to update the disconnected DeviceName */
      DataItemContainer<DisconnectedBTDeviceNameDataBindingSource> oDisconnectedBTDeviceName;

      /*	Binding source to update the vehicle friendly name */
      DataBindingItem<FriendlyVehicleNameDataBindingSource> oFriendlyName;

      /*Binding source to update the Settings */
      DataItemContainer<SettingsDataBindingSource> oSettings;

#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      DataItemContainer<BTONOFFDataBindingSource> oBTONOFF;
#endif
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      //Phone Gadget Data binding
      Courier::DataItemContainer<PhoneGadgetInfoDataBindingSource> _phoneGadgetInfoData;
      Courier::DataItemContainer<PhoneButtonTextDataBindingSource> _PhoneButtonText;
      Courier::DataItemContainer<IntercomenableDataBindingSource> _Intercomenable;

#endif
      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
#ifdef WINDOWS_SIMULATION
      virtual bool onCourierMessage(const AddNewDeviceReq& corfoMsg);

      bool onCourierMessage(const DeviceListReq& corfoMsg);
      bool popupcheckflag;
#endif
      //bool bIsConnectTimerRunning;
      //static bool bIsDeviceConnectionTimerRunning;
//#ifndef WINDOWS_SIMULATION
//
//	OSAL_tTimerHandle hConnectTimer; // Timer that is set on device connection
//	static void vOnDeviceConnectionTimerExpiry(tPVoid pvObject); // Callback function on Timer Expiry
//	void vStopDeviceConnectionTimer(); // Stops DeviceConnection timer execution
//	OSAL_tTimerHandle hDeviceConnectionTimer; // DeviceConnection timer
//	 // Check deviceConnection timer state.
//#endif


      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
#ifdef WINDOWS_SIMULATION
      ON_COURIER_MESSAGE(AddNewDeviceReq)
      ON_COURIER_MESSAGE(DeviceListReq)
#endif
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      tBool m_bSLCStatus;//stores slc status in model
      tU8 u8BTLinkLost;//used to store link lost status
   public:
      /* for singleton implementation */
      static DeviceListModel* m_poDeviceListModel;
      static DeviceListModel* poGetInstance();
      static void vDeleteInstance();
      virtual ~DeviceListModel();

      bool Init();
      bool bRetVal;
      void OnUpdNewDeviceInfoResult(std::string copcDeviceName, std::string copcPin, btphn_tenBTPairingType const& corfenPairingType);
      void OnUpdVehicleBTFriendlyNameStatus(std::string copcVehicleBTName);
      void OnUpdPairingPinStatus(std::string copcPinNumber);

      /* sends device list to GUI*/
      void OnUpdCreateBTDeviceList(tU8& m_u8DeviceListSize, std::vector <DeviceListInformation>& m_arDeviceListInfo);

      /* sends connected device status to GUI*/
      void OnUpdDeviceConnected(const tU8& enDeviceStatus, const tU8& NoOfHfpDevices, const tU8& NoOfConnectedDevices);

      /*Updates connected BT device name to GUI*/
      void OnUpdConnectedDeviceName(const std::string& szDeviceName);

      /*Updates connected BT device name to GUI*/
      void OnUpdActPassiveDeviceName(const std::string& szDeviceName);

      /*updates devicename info databinding properties when unpairing is initiated*/
      void OnUpdDeviceName(const std::string& szDeviceName);

      /*updates devicename info databinding properties when unpairing is initiated*/
      void OnUpdDisconnectedDeviceName(const std::string& szDeviceName);

      /* stores SLC status in model*/
      void OnUpdSLCStatus(tBool& bCommandStatus);

      uint16 vReadVehicleVariant(); //Read the variant of the vehicle smart/inf4cv //PhoneSettings: varibale to store the vehicle variant. smart/inf4cv

      /* Enables all phone settings*/
      void vEnablePhoneSettings();

      /*Disables all the phone settings*/
      void vDisablePhoneSettings();

#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      void OnUpdBTONOFFStatus(bool BTstatus);
#endif
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      void OnUpdGadgetStatus(uint8 u8Active_Source);
#endif
      /* returns SLC status*/
      tBool bGetSLCStatus()
      {
         return m_bSLCStatus;
      }

      void OnUpdIntercomStatus(bool ISupported, bool INotSupported);

      /*returns correct device type icon index value*/
      UInt16 u16GetDeviceTypeIndex(tU8 u8nMajorDeviceClass, bool bConnectedStatus);
      /*returns correct icon profle index value*/
      UInt16 u16GetIconProfileIndex(bool bAudioStreamingSupport);
      void OnUpdDeviceListfull();
      //void OnUpdChangeRingtoneStatus(tU16 corfu16RingtoneID);
      tU16 OnUpdChangeRingtoneSettingsReq();
      tU8 u8FindSupportInfoIndex(tU8 u8PairedDeviceHandle, std::vector<btphn_trBTDeviceSupportInfo>& arDeviceSupportInfo);
};


}//Namespace Core
}//Namespace App

#endif // _HMI_MODEL_COMPONENT_H
