/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_Phone>
 */

#ifndef LANGUAGE_CLIENT_H
#define LANGUAGE_CLIENT_H

#define LANGNO  19

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/DataModel/ListRegistry.h"
#include "BTPhoneDefines.h"
#include "TeleDefines.h"
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataProxy.h" //Sys setting TBC

enum btphn_PhoneCallStatus_CAN
{
   BTPHN_CAN_IDLE = 0,
   BTPHN_CAN_INCOMMING = 1,
   BTPHN_CAN_OUTGOING = 2,
   BTPHN_CAN_ACTIVE = 3,
   BTPHN_CAN_PRIVATE_MODE = 4,
   BTPHN_CAN_DIALING_FAILED = 5,
   BTPHN_CAN_ERROR = 14,
   BTPHN_CAN_SNA = 15,
};


//#define ERROR_CODE_SNA 65;
static const tU8 CAN_ERROR = 14;
static const tU8 CAN_SNA = 15;
static const tU8 PHONEMW_SNA = 65;
static const tU8 CAN_SECONDARY_ERROR = 2;
static const tU8 CAN_SECONDARY_SNA = 3;
static const tU8 CAN_PHONEBOOK_INIT = 0;
static const tU8 CAN_PHONEBOOK_LOADING = 1;
static const tU8 CAN_PHONEBOOK_READY = 2;
static const tU8 BTPHN_EN_PRIVATE_MODE = 4;
static const tU8 BTPHN_EN_DIALING_FAILED = 5;

using namespace ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData; // sys settings TBC

namespace App {
namespace Core {

class VehicleSrvClient : public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::SpeedCallbackIF,
   public SpeedLockStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneCallCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::PhonePwrCmdCallbackIF,
   public ::VEHICLE_MAIN_FI::SMARTVRCallbackIF,
   public ::VEHICLE_MAIN_FI::GSMSignalStrengthCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneBatteryLevelStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::CallDurationCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneStatusRoamingCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneCallStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneBookSyncstatusCallbackIF,
   public ::VEHICLE_MAIN_FI::CallHistorySyncStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneBTLinkStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneAvailableStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusWifiAvailableCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusBTStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::PhoneVRAvailableCallbackIF,
   public ::VEHICLE_MAIN_FI::SendPhoneInfoCallbackIF,
   public ::VEHICLE_MAIN_FI::SendCallInfoCallbackIF

#if 0  // Enable on FI Implementation
   , public ::VEHICLE_MAIN_FI::CallStatusCallbackIF
   , public ::VEHICLE_MAIN_FI::CallDurationCallbackIF
   , public ::VEHICLE_MAIN_FI::Phone_AvailCallbackIF
   , public ::VEHICLE_MAIN_FI::GSMFieldstrengthCallbackIF
   , public ::VEHICLE_MAIN_FI::PhoneBatteryLevelCallbackIF
#endif
{
   private:
      VehicleSrvClient();
      static VehicleSrvClient* _VehicleSrvClient;

      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::boost::shared_ptr< HmiDataProxy> _hmiDataProxy; // sys settings TBC

   public :

      static VehicleSrvClient* poGetInstance()
      {
         if (NULL == _VehicleSrvClient)
         {
            _VehicleSrvClient = new VehicleSrvClient();
         }

         return _VehicleSrvClient;
      }

      virtual ~VehicleSrvClient();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);

      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);

      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}
      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}
      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);

      void onPhoneCallCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /* proxy */, \
                                   const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneCallCommandError >& /* error */);

      void onPhoneCallCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneCallCommandStatus >& status);
      //PhonePowerCommandCallbackIF
      void onPhonePwrCmdError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhonePwrCmdError >& error);
      void onPhonePwrCmdStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhonePwrCmdStatus >& status);

      //SMARTVRCallbackIF
      void onSMARTVRError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                          const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SMARTVRError >& error);
      void onSMARTVRStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SMARTVRStatus >& status);
      //GSMFieldstrengthCallbackIF
      void onGSMSignalStrengthError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GSMSignalStrengthError >& error);
      void onGSMSignalStrengthResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GSMSignalStrengthResult >& result);
      //PhoneBatteryLevelStatusCallbackIF
      void onPhoneBatteryLevelStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                          const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBatteryLevelStatusError >& error);
      void onPhoneBatteryLevelStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBatteryLevelStatusResult >& result);
      //CallDurationCallbackIF
      void onCallDurationError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallDurationError >& error);
      void onCallDurationResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallDurationResult >& result);
      //PhoneStatusRoamingCallbackIF
      void onPhoneStatusRoamingError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneStatusRoamingError >& error);
      void onPhoneStatusRoamingResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneStatusRoamingResult >& result);
      //PhoneCallStatusCallbackIF
      void onPhoneCallStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                  const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneCallStatusError >& error);
      void onPhoneCallStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                   const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneCallStatusResult >& result);
      //PhoneBookSyncstatusCallbackIF
      void onPhoneBookSyncstatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBookSyncstatusError >& error);
      void onPhoneBookSyncstatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                       const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBookSyncstatusResult >& result);
      //CallHistorySyncStatusCallbackIF
      void onCallHistorySyncStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                        const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallHistorySyncStatusError >& error);
      void onCallHistorySyncStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                         const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallHistorySyncStatusResult >& result);
      //BTLinkStatusCallbackIF
      void onPhoneBTLinkStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBTLinkStatusError >& error);
      void onPhoneBTLinkStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBTLinkStatusResult >& result);
      //PhoneAvailableStatusCallbackIF
      void onPhoneAvailableStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                       const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneAvailableStatusError >& error);
      void onPhoneAvailableStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                        const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneAvailableStatusResult >& result);
      //DeviceStatusWifiAvailableCallbackIF
      void onDeviceStatusWifiAvailableError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusWifiAvailableError >& error);
      void onDeviceStatusWifiAvailableResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                             const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusWifiAvailableResult >& result);
      //DeviceStatusBTStatusCallbackIF
      void onDeviceStatusBTStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                       const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusBTStatusError >& error);
      void onDeviceStatusBTStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                        const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusBTStatusResult >& result);
      //PhoneVRAvailableCallbackIF
      void onPhoneVRAvailableError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                   const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneVRAvailableError >& error);
      void onPhoneVRAvailableResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneVRAvailableResult >& result);
      //SendPhoneInfoCallbackIF
      void onSendPhoneInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendPhoneInfoError >& error);
      void onSendPhoneInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                 const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendPhoneInfoResult >& result);
      //SendCallInfoCallbackIF
      void onSendCallInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCallInfoError >& error);
      void onSendCallInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCallInfoResult >& result);
#if 0  // Enable on FI Implementation
      void onCallStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                             const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallStatusError >& error);
      void onCallStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallStatusResult >& result);

      void onCallDurationError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallDurationError >& error);
      void onCallDurationResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CallDurationResult >& result);

      void onPhone_AvailError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Phone_AvailError >& error);
      void onPhone_AvailResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Phone_AvailResult >& result);

      void onGSMFieldstrengthError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                   const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GSMFieldstrengthError >& error);
      void onGSMFieldstrengthResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::GSMFieldstrengthResult >& result);

      void onPhoneBatteryLevelError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                    const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBatteryLevelError >& error);
      void onPhoneBatteryLevelResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PhoneBatteryLevelResult >& result);
#endif
      void updatePhoneBatteryLevel(tU8 u8BatteryChargeStatus);
      void updateGSMSignalStrength(tU8 u8SignalstrengthStatus);
      void updateCallDuration(const btphn_trCallStatus& corfrCallStatus);
      void updatePhoneRoamingStatus(bool u8RoamingStatus);
      void updatePrivateDialFailMode(int statusType);
      void updatePhonebookDownloadSync(tU8 u8DownloadStatus);
      void updateBTLinkStatus(tU8 BTLinkState);
      void vCheckKDSFeaturesAvailable();
      void vInitGenericCanInterfaces();
      void vUpdateBTOnOffStatus(tU8 BTOnOff);
      void vUpdateCallInfo(int callLongDataType, std::string strlongDataCallNum);
      void vUpdatePhoneInfo(int phoneLongDataType, std::string strlongDataPhoneName);
      void vPrepareLongData(int longDataType, std::string longdatainfo);

      void updatePhoneBatteryLevelError(tU8 u8ChargeStatusErrorCode);
      void updateGSMSignalStrengthError(tU8 u8SignalStatusErrorCode);
      void updateCallDurationError(tU8 u8CallDurationErrorCode);
      void updatePhoneRoamingError(tU8 u8RoamingErrorCode);
      void updateCallStatusError(tU8 u8CallStatusErrorCode);
      void updatePhonebookDownloadError(tU8 u8DownloadErrorCode);
      void updateBTLinkStatusError(tU8 BTLinkStateErrorCode);

      void updateCallStatus();
      //Driver distraction Implementation:To capture the vehicle speed data .
      void onSpeedStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedStatus >& status);
      void onSpeedError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedError >& /*error*/);
      void onSpeedLockStatusUpdate(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< SpeedLockStatusUpdate >& update);
      void onSpeedLockStatusError(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< SpeedLockStatusError >& error);
      void setSpeedValue(tU16 u16SpeedValue);
      int getSpeedValue();

      void updateCallHistorySyncStatus(tU8 CallListDownloadState);
      void updateCallHistorySyncError(tU8 CallListDownloadErrorCode);
      uint16 m_u16SpeedValue;
      // bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      struct LanguageTable
      {
         int LangIndex;
         std::string LangString;
      };

      LanguageTable LanguageMappingTable[LANGNO] ;

      std::string getLanguageId(int index);
   private:
      // Data members
      tU8 m_U8BatteryStatus;
      tU8 m_U8CallDuraErrCode;
      tU8 m_U8SignalStatus;
      tU8 m_U8CallStatus;
      tU8 m_U8DownloadStatus;
      tU8 m_U8errorCodeSNA;
      tU16 m_u16CallDurationInSec;
      tU8 m_u8CallHistorySyncState;
      tU8 m_u8BTLinkState;
      bool m_bRoamStatus;
      bool m_bPhoneAvailable;
      bool m_bWifiAvailable;
      bool m_bSmartPhoneVRAvailable;
};


}
}


#endif
