/**************************************************************************************
 * @file         : SpeedLockStatusHandler.cpp
 * @addtogroup   : AppHmi_phone
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *29.07.20 Rev. 0.1 wut4kor(RBEI/EHM)
 * 		  			Initial Revision.
 **************************************************************************************/

#ifndef _SPEEDLOCK_STATUS_HANDLER_H_
#define _SPEEDLOCK_STATUS_HANDLER_H_

#include "BTPhoneDefines.h"
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
// Should contain on header for unittest build
#include "utest/stubs/EnumData.h"
#endif // End of unittest Macro


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "TeleDefines.h"
#include "AppHmi_PhoneStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_PhoneStateMachineData.h"
#include "AppHmi_PhoneDatabinding.h"
#include "AppHmi_PhoneMessages.h"
#endif // End of unit test bind

namespace App {
namespace Core {

class SpeedLockStatusHandler
{
   public:

      virtual ~SpeedLockStatusHandler();
      static SpeedLockStatusHandler& getInstance();

      void removeInstance();
      void updateSpeedValue(uint16 speedValue);
      void updateSysSettingSpeedLockStatus(bool speedLockStatus);
      void updatespeedlockenabledStatus();

      bool m_SpeedLockActive; // speedlock status value based on the vehicle speed
      bool m_SysSpeedlockEnable; //speedlock status value based on the system settings

      bool getSpeedLockStatus();
   private:

      SpeedLockStatusHandler();
      static  SpeedLockStatusHandler* _SpeedLockStatusHandler;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      Courier::DataItemContainer<SpeedLockDataBindingSource> speedlock;
#endif // End of unittest macro
};


}//end of Core
}//end of App


#endif // _SPEEDLOCK_STATUS_HANDLER_H_
