/***************************************************************************
* Copyright(c) 2018-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
* (c) Robert Bosch Car Multimedia GmbH
*
* Add details here
****************************************************************************/
#ifndef _SMARTPHONECLIENT_H_
#define _SMARTPHONECLIENT_H_

//#include <ilm_client.h>
//#include <ilm_control.h>

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

/* Defines for including the needed Smartphoneintegration Settings interface header files */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_SERVICEINFO

#include "AppUtils/HmiMacros.h"
#include "midw_smartphoneint_fiProxy.h"
#include "midw_smartphoneint_fi.h"
#include "AppHmi_PhoneStateMachine.h"
#include "AppUtils/HmiMacros.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Project_Trace.h"
#include "BTPhoneDefines.h"
#include "AppHmi_PhoneTypes.h"
#include "midw_fi_if.h"
#include "ServiceTel.h"
#include "CgiExtensions/DataBindingItem.hpp"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif

namespace App {
namespace Core {


class SmartPhoneClient : public hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public midw_smartphoneint_fi::DeviceStatusInfoCallbackIF,
   public midw_smartphoneint_fi::GetDeviceInfoListCallbackIF,
   public midw_smartphoneint_fi::SessionStatusInfoCallbackIF
{
   private:
      static SmartPhoneClient* _poSmartPhoneClientptr;
      SmartPhoneClient();
      SmartPhoneClient(const SmartPhoneClient&);
      SmartPhoneClient& operator=(const SmartPhoneClient&);
      ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy > spProxy;

      ::midw_smartphoneint_fi_types::T_e8_DeviceCategory m_DevCategory;
      tBool bDeviceConnected;
      /* To store CarPlay KDS parameter */
      uint8 _technologyCP;
      /* To store Android Auto KDS parameter */
      uint8 _technologyAA;
      /* To store device BT address of active android auto device */
      //std::string m_sAAPDeviceBtAddress;;
      /*	Binding source to update the Android Auto Session Info */
      DataBindingItem<AndroidAutoSessionInfoDataBindingSource>oAndroidAutoSessionInfo;

      DECLARE_CLASS_LOGGER();
   public:
      virtual ~SmartPhoneClient();
      static SmartPhoneClient* getInstance()
      {
         if (_poSmartPhoneClientptr == NULL)
         {
            _poSmartPhoneClientptr = new SmartPhoneClient();
         }
         return _poSmartPhoneClientptr;
      }

      /*inline std::string sGetAndroidAutoDevBtAddress()
       {
         return m_sAAPDeviceBtAddress;
       }*/

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onGetDeviceInfoListError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ::midw_smartphoneint_fi::GetDeviceInfoListError >& /*error*/);
      virtual void onGetDeviceInfoListResult(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ::midw_smartphoneint_fi::GetDeviceInfoListResult >& /*result*/);

      virtual void onDeviceStatusInfoError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ::midw_smartphoneint_fi::DeviceStatusInfoError >& /*error*/);
      virtual void onDeviceStatusInfoStatus(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ::midw_smartphoneint_fi::DeviceStatusInfoStatus >& status);
      virtual void onSessionStatusInfoStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&, const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoStatus>&);
      virtual void onSessionStatusInfoError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>&, const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoError>&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)

      COURIER_MSG_MAP_END()

      tVoid vHandleKeyEvent();
      void readKdsForTechnology();
};


}  // namespace Core
}  // namespace App

#endif
