/***************************************************************************
* Copyright(c) 2018-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
* (c) Robert Bosch Car Multimedia GmbH
*
* Add details here
****************************************************************************/
#include "hall_std_if.h"
#include "SmartPhoneClient.h"
#include "AppHmi_PhoneTypes.h"

namespace App {
namespace Core {

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::SmartPhoneClient::
#include "trcGenProj/Header/SmartPhoneClient.cpp.trc.h"
#endif

/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
SmartPhoneClient* SmartPhoneClient::_poSmartPhoneClientptr = NULL;


SmartPhoneClient::SmartPhoneClient():
   spProxy(::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy::createProxy("midwspiPort", *this)),
   m_DevCategory(::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_UNKNOWN),
   _technologyCP(0),
   _technologyAA(0),
   bDeviceConnected(FALSE)/*,
m_sAAPDeviceBtAddress("")*/
{
   g_SM_SpiSessionStatus = SPI_SESSION_INACTIVE; // Using SPI_SESSION_INACTIVE, instead of UNKNOWN For optimization
   readKdsForTechnology();
   if (spProxy.get())
   {
      ETG_TRACE_USR2(("SmartPhoneClient spProxy.get is TRUE"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, spProxy->getPortName());
   }
   else
   {
      ETG_TRACE_FATAL(("SmartPhoneClient spProxy.get is FALSE"));
   }
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
SmartPhoneClient::~SmartPhoneClient()
{
   //Add your code here
}


void SmartPhoneClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void SmartPhoneClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void SmartPhoneClient::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("SmartPhoneClient onAvailable(spProxy)"));
   if ((proxy == spProxy) && (spProxy.get()))
   {
      spProxy->sendDeviceStatusInfoUpReg(*this);
      spProxy->sendSessionStatusInfoUpReg(*this);
   }
   else
   {
      if (proxy != spProxy)
      {
         ETG_TRACE_FATAL(("ServiceBT registerProperties(_btSetProxy != proxy)"));
      }
   }
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void SmartPhoneClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("SmartPhoneClient onUnavailable(spProxy)"));
   //Add your code here
   if (proxy == spProxy && (spProxy.get()))
   {
      spProxy->sendDeviceStatusInfoRelUpRegAll();
      spProxy->sendSessionStatusInfoRelUpRegAll();
      ETG_TRACE_USR2(("SmartPhoneClient deregisterProperties"));
   }
}


void SmartPhoneClient::onGetDeviceInfoListError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, const ::boost::shared_ptr< ::midw_smartphoneint_fi::GetDeviceInfoListError >& error)
{
}


void SmartPhoneClient::onGetDeviceInfoListResult(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, const ::boost::shared_ptr< ::midw_smartphoneint_fi::GetDeviceInfoListResult >& result)
{
   ETG_TRACE_USR2(("SmartPhoneClient::onGetDeviceInfoListResult devicelist size %d", result->getDeviceInfoList().size()));
   bDeviceConnected = FALSE;
   for (int i = 0; i < result->getDeviceInfoList().size(); i++)
   {
      /*if(result->getDeviceInfoList().at(i).getEnDeviceCategory() == ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO)*/
      if (result->getDeviceInfoList().at(i).getEnDeviceConnectionStatus()
            == ::midw_smartphoneint_fi_types::T_e8_DeviceConnectionStatus__DEV_CONNECTED)
      {
         bDeviceConnected = TRUE;
         m_DevCategory = result->getDeviceInfoList().at(i).getEnDeviceCategory();
         //m_sAAPDeviceBtAddress = result->getDeviceInfoList().at(i).getSzBTAddress();
         ETG_TRACE_USR2(("SmartPhoneClient::onGetDeviceInfoListResult: m_DevCategory: %d", m_DevCategory));
         //ETG_TRACE_USR2(("SmartPhoneClient::onGetDeviceInfoListResult bt device address = %s", m_sAAPDeviceBtAddress.c_str()));
      }
   }
}


void SmartPhoneClient::onDeviceStatusInfoError(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, const ::boost::shared_ptr< ::midw_smartphoneint_fi::DeviceStatusInfoError >& error)
{
}


void SmartPhoneClient::onDeviceStatusInfoStatus(const ::boost::shared_ptr< ::midw_smartphoneint_fi::Midw_smartphoneint_fiProxy >& proxy, const ::boost::shared_ptr< ::midw_smartphoneint_fi::DeviceStatusInfoStatus >& status)
{
   ETG_TRACE_USR2(("SmartPhoneClient::onDeviceStatusInfoStatus device status = %d", status->getDeviceStatus()));
   if ((::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo__DEVICE_CHANGED == status->getDeviceStatus()) ||
         (::midw_smartphoneint_fi_types::T_e8_DeviceStatusInfo__DEVICE_ADDED == status->getDeviceStatus()))
   {
      if (spProxy != NULL)
      {
         spProxy->sendGetDeviceInfoListStart(*this);
      }
   }
}


/************************************************************************
*FUNCTION:		onSessionStatusInfoStatus
*DESCRIPTION:	Function shall notify the sessionstatus info status
*PARAMETER:     proxy, status
*RETURNVALUE:	NA
************************************************************************/
void SmartPhoneClient::onSessionStatusInfoStatus(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy, const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoStatus>& status)
{
   ETG_TRACE_USR4(("SmartPhoneClient::onSessionStatusInfoStatus()"));
   ETG_TRACE_USR4(("SmartPhoneClient::onSessionStatusInfoStatus() CarPlay = %d", _technologyCP));
   ETG_TRACE_USR4(("SmartPhoneClient::onSessionStatusInfoStatus() AndroidAuto = %d", _technologyAA));
   if (spProxy)
   {
      ::midw_smartphoneint_fi_types::T_e8_SessionStatus dev_SessionStatus = status->getSessionStatus();
      ::midw_smartphoneint_fi_types::T_e8_DeviceCategory dev_Category = status->getDeviceCategory();
      ETG_TRACE_USR4(("SmartPhoneClient::onSessionStatusInfoStatus dev_SessionStatus = %d dev_Handle = %d", dev_SessionStatus, status->getDeviceHandle()));

      /* Evaluate the android auto session or carplay based on current device session and device category */
      if ((dev_SessionStatus == ::midw_smartphoneint_fi_types::T_e8_SessionStatus__SESSION_ACTIVE) &&
            ((dev_Category == ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO) || (dev_Category == ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_DIPO)))
      {
         if ((dev_Category == ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO) && (_technologyAA == true))
         {
            g_SM_SpiSessionStatus = SPI_SESSION_ANDROID_AUTO_ACTIVE;
            (*oAndroidAutoSessionInfo).mSessionStatus = false;
            (*oAndroidAutoSessionInfo).mSessionStatusIndex = 1;
         }
         else if ((dev_Category == ::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_DIPO) && (_technologyCP == true))
         {
            g_SM_SpiSessionStatus = SPI_SESSION_CARPLAY_ACTIVE;
            (*oAndroidAutoSessionInfo).mSessionStatus = false;
            (*oAndroidAutoSessionInfo).mSessionStatusIndex = 1;
         }
         else
         {
         }
      }
      else
      {
         g_SM_SpiSessionStatus = SPI_SESSION_INACTIVE;
         (*oAndroidAutoSessionInfo).mSessionStatus = true;
         (*oAndroidAutoSessionInfo).mSessionStatusIndex = 0;
      }
      /* Post the courier message to controller and model*/
      POST_MSG((COURIER_MESSAGE_NEW(SpiSessionMsg)()));
      /* Refresh device list status as to reflect the list properties based on android auto session status */
      ServiceBT::poGetInstance()->vUpdateDevicelistStatusOnAndroidAutoSessionChange();
      /* Data binding update */
      oAndroidAutoSessionInfo.MarkAllItemsModified();
      oAndroidAutoSessionInfo.SendUpdate(true);
   }
}


/************************************************************************
*FUNCTION:		onSessionStatusInfoError
*DESCRIPTION:	Function shall notify the sessionstatus info error
*PARAMETER:     proxy, error
*RETURNVALUE:	NA
************************************************************************/
void SmartPhoneClient::onSessionStatusInfoError(const ::boost::shared_ptr<midw_smartphoneint_fi::Midw_smartphoneint_fiProxy>& proxy, const ::boost::shared_ptr<midw_smartphoneint_fi::SessionStatusInfoError>& error)
{
   ETG_TRACE_USR4(("SmartPhoneClient::onSessionStatusInfoError()"));
}


tVoid SmartPhoneClient::vHandleKeyEvent()
{
   ETG_TRACE_USR2(("SmartPhoneClient::vHandleKeyEvent() "));

   if (bDeviceConnected == TRUE && ((::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_DIPO == bDeviceConnected) || (::midw_smartphoneint_fi_types::T_e8_DeviceCategory__DEV_TYPE_ANDROIDAUTO == bDeviceConnected)))
   {
      ETG_TRACE_USR2(("SmartPhoneClient::vHandleKeyEvent()-> smart phone connected - no bt vr "));
   }
   else
   {
      ETG_TRACE_USR2(("SmartPhoneClient::vHandleKeyEvent()-Start BT VR"));
      ServiceTel::poGetInstance()->vSwitchToBTVRView();
   }
}


/************************************************************************
*FUNCTION:		readKdsForTechnology
*DESCRIPTION:	Function to get the KDS value based on Technology
*PARAMETER:     NA
*RETURNVALUE:	NA
************************************************************************/
void SmartPhoneClient::readKdsForTechnology()
{
   dp_tclKdsSystemConfiguration1 _KdsSystemConfigurationInst;
   _KdsSystemConfigurationInst.u8GetCarPlay(_technologyCP);
   _KdsSystemConfigurationInst.u8GetAndroidAuto(_technologyAA);

   ETG_TRACE_USR4(("SmartPhoneClient::readKdsForTechnology() CarPlay = %d", _technologyCP));
   ETG_TRACE_USR4(("SmartPhoneClient::readKdsForTechnology() AndroidAuto = %d", _technologyAA));
}


}
}
