/* ***************************************************************************************
* FILE:          PhoneHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PhoneHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef PhoneHall_h
#define PhoneHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "MOST_PhonBk_FI.h"
#include "MOST_PhonBk_FIProxy.h"
#include "MOST_Tel_FI.h"
#include "MOST_Tel_FIProxy.h"

#include "MOST_Msg_FI.h"
#include "MOST_Msg_FIProxy.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "App/Core/Intercom/IntercomClienthandler.h"
#include "DeviceListModel.h"
#endif
#include "App/Core/BTSetting/ServiceBT.h"
#include "App/Core/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/Telephone/ServiceTel.h"
#include "App/Core/ClockSrvClient/ClockSrvClient.h"
#include "App/Core/SmartPhone/SmartPhoneClient.h"
#include "App/Core/Microphone/MicClientHandler.h"

#include "App/Core/Message/ServiceMsg.h"
#include "App/Core/PhoneBook/ServicePhonebook.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/DefSetServiceBase/DefSetServiceBase.h" //Reset To Factory
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "App/Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include <Adapter/LanguageHandlerAdapter.h>
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "ProjectPluginMsgs.h"
#endif
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;    //Change this

namespace App {
namespace Core {

class PhoneHall
   : public HallComponentBase
   , public iDefSetServiceBase   // for factory reset
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      PhoneHall();
      virtual ~PhoneHall();

      // TimerCallbackIF
      //virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

   protected:
      bool onCourierMessage(const ApplicationStateUpdMsg& msg);
      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
      virtual bool onCourierMessage(const PhoneGadgetRequestMsg& oMsg);
      virtual bool onCourierMessage(const RequestCallConnectingMsg& oMsg);
      virtual bool onCourierMessage(const TriggerSceneTransitionMsg& oMsg);
      bool onCourierMessage(const OnIncomingCallRespMsg& oMsg);
      bool onCourierMessage(const OnCallEndRespMsg& oMsg);
      bool onCourierMessage(const OnBackButtonPressMsg& oMsg);
      bool onCourierMessage(const CallStatusResp& oMsg);
      bool onCourierMessage(const MultipleCallStatusResp& oMsg);
      virtual bool onCourierMessage(const onHardKeyPress& msg);
      virtual bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);
      virtual bool onCourierMessage(const SpiSessionMsg& msg);
      virtual bool onCourierMessage(const OnContextSwitchOnExitOfBTVRMsg& msg);
      virtual bool onCourierMessage(const ControlPanelButtonPressInfo&);
      virtual bool onCourierMessage(const GenericCANBTVRReq&);

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      bool onCourierMessage(const PhoneAppflyinReq& oMsg);
      bool onCourierMessage(const OnIntercomIncomingCallRespMsg& oMsg);
      bool onCourierMessage(const OnIntercomCallEndRespMsg& oMsg);
      bool onCourierMessage(const OnIntercomIncomingConfCallRespMsg& oMsg);
      bool onCourierMessage(const OnIntercomConfCallEndRespMsg& oMsg);
      //Removed Pluginendstaion update as it is depreciated from avdec plugin
#endif
      void sendRequestForBTVRFunctionHandling(void);
      // For requesting Context switching
      bool sendRequestForContextSwitching(const int requestType);
      bool sendRequestForContextSwitching_internal(const int requestType);

      // for factory reset
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(SwitchApplicationReq)
      ON_COURIER_MESSAGE(PhoneGadgetRequestMsg)
      ON_COURIER_MESSAGE(TriggerSceneTransitionMsg)
      ON_COURIER_MESSAGE(OnIncomingCallRespMsg)
      ON_COURIER_MESSAGE(OnCallEndRespMsg)
      ON_COURIER_MESSAGE(onHardKeyPress)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(SpiSessionMsg)
      ON_COURIER_MESSAGE(OnContextSwitchOnExitOfBTVRMsg)
      ON_COURIER_MESSAGE(RequestCallConnectingMsg)
      ON_COURIER_MESSAGE(CallStatusResp)
      ON_COURIER_MESSAGE(OnBackButtonPressMsg)
      ON_COURIER_MESSAGE(ControlPanelButtonPressInfo)
      ON_COURIER_MESSAGE(GenericCANBTVRReq)
      ON_COURIER_MESSAGE(MultipleCallStatusResp)
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      ON_COURIER_MESSAGE(OnIntercomIncomingCallRespMsg)
      ON_COURIER_MESSAGE(PhoneAppflyinReq)
      ON_COURIER_MESSAGE(OnIntercomCallEndRespMsg)
      //Removed Pluginendstaion update as it is depreciated from avdec plugin
      ON_COURIER_MESSAGE(OnIntercomIncomingConfCallRespMsg)
      ON_COURIER_MESSAGE(OnIntercomConfCallEndRespMsg)
#endif

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_ServiceBT)
      COURIER_MSG_DELEGATE_TO_OBJ(_ServicePhoneBook)
      COURIER_MSG_DELEGATE_TO_OBJ(_ServiceTel)
      COURIER_MSG_DELEGATE_TO_OBJ(_ServiceMsg)
      COURIER_MSG_DELEGATE_TO_OBJ(_SmartPhoneClient)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_DELEGATE_TO_OBJ(_VehicleSrvClient)
      COURIER_MSG_DELEGATE_TO_OBJ(_applicationSwitchClientHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_OBJ(_MicClientHandler)
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      COURIER_MSG_DELEGATE_TO_OBJ(_IntercomClienthandler)
#endif
      COURIER_MSG_MAP_DELEGATE_END()

      uint16 getKDSVehicleType()
      {
         return u16VehicleType;
      }

   private:
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeSPIProxy;

      PhoneHall(const PhoneHall&);
      PhoneHall& operator=(const PhoneHall&);
      ServiceBT* _ServiceBT;
      VehicleSrvClient* _VehicleSrvClient;
      ServicePhoneBook* _ServicePhoneBook;
      ServiceTel* _ServiceTel;
      ClockSrvClient* _phClock;
      ServiceMsg* _ServiceMsg;
      SmartPhoneClient* _SmartPhoneClient;
      ApplicationSwitchClientHandler* _applicationSwitchClientHandler;
      MicClientHandler* _MicClientHandler;
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      IntercomClienthandler* _IntercomClienthandler;
      tU8 u8ActiveSource;
      bool _isIntercomIncomingCallPopupActive;
      bool _isIntercomCallDialingInProgress;
      bool _isThereAnActiveIntercomCall;
      bool _isThereConfIntercomCall;
      void OnUpdAppFlyinContextSwitch();
      //Courier::DataItemContainer<PhoneButtonTextDataBindingSource> _PhoneButtonText;
      Courier::DataItemContainer<IntercomenableDataBindingSource> _Intercomenable;
      /* Data Bining source used for handling Call Status provided by the application */
#endif
      Courier::DataItemContainer<PhoneButtonTextDataBindingSource> _PhoneButtonText;
      // HardKey Handling
      bool _isIncomingCallPopupActive;
      bool _isCallDialingInProgress;
      bool _isThereAnActiveCall;
      bool _isPhonceContextActive;
      /* To store the index of device handle as to update to the datamodel on device toggle as well as on single device connection */
      tU8 m_u8PhoneCurrentHandle;
      btphn_tenPhoneCallStatus _enPreviousCallStatus;
      btphn_tenPhoneCallStatus _enPreviousFirstCallStatus;
      btphn_tenPhoneCallStatus _enPreviousSecondCallStatus;

      bool HandleSWCPickupKeyPress(const int hardkeyState);
      bool HandleSWCRejectKeyPress(const int hardkeyState);
      bool HandleMCPAcceptKeyPress(const int hardkeyState);
      bool HandleMCPRejectKeyPress(const int hardkeyState);

      // Implemented for SMART SWC handling - contains one once SWC Key
      bool HandleSWCShortPress(const int hardkeyState);
      bool HandleSWCLongPress(const int hardkeyState);

      void SendContextSwitchRequestForVR(bool bIsLongKeyPress);
      tBool bPhoneRestoreFactorySetting();
      bool handleBTVRViaControlPanel();
      bool HandleHKRemoteControlPhoneKeyPress(const int hardkeyState);
      bool HandleHKRemoteControlDialPadKeyPress(const int hardkeyCode);

      /** Instance for the DefSetServiceBase */
      DefSetServiceBase* _mdefSetServiceBase;

      //Phone Gadget Data binding
      Courier::DataItemContainer<PhoneGadgetInfoDataBindingSource> _phoneGadgetInfoData;

      // ::boost::shared_ptr<	::MOST_Msg_FI::MOST_Msg_FIProxy > _msgProxy;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch

      // VehicleType info from KDS
      uint16 u16VehicleType;

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
