/***************************************************************************
* Copyright(c) 2017-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#ifndef PHONEBOOK_H
#define PHONEBOOK_H

//Add include files here
#define GENERIC_FI_INTERFACE
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_ERRORCODES
#include "most_fi_if.h"
//#include "../../PhoneDataTypes.h"

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#include "mplay_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#include "midw_fi_if.h"
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "MOST_PhonBk_FI.h"
#include "MOST_PhonBk_FIProxy.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
//#include "sds_gui_fi/SdsPhoneServiceProxy.h"
#include "BTPhoneDefines.h"
#include "PhonebookModelComponent.h"
#include "CallHistoryModel.h"
#include "SpellerModel.h"
#include "ServiceBT.h"
#include "ServiceTel.h"
#include "ServiceMsg.h"
#include "DeviceListModel.h"
//#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/DataModel/ListModel.h"
#include "Common/DataModel/ListRegistry.h"
#include "List/Data/ListDataProviderDistributor.h"
using namespace asf::core;
using namespace ::MOST_PhonBk_FI;
using namespace ::most_PhonBk_fi_types;
using namespace ::MOST_BTSet_FI;

//Forward Declarartions
class PhonebookModelComponent;
class CallHistoryModel;

namespace App {
namespace Core {
class ServicePhoneBook : public ListImplementation,
   public  hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public ::MOST_PhonBk_FI::SearchPhoneBookCallbackIF,
   public ::MOST_PhonBk_FI::AutocompletePhoneNumberEntryCallbackIF,
   public ::MOST_PhonBk_FI::CreateCallHistoryListCallbackIF,
   public ::MOST_PhonBk_FI::ReleaseCallHistoryListCallbackIF,
   public ::MOST_PhonBk_FI::RequestSliceCallHistoryListCallbackIF,
   public ::MOST_PhonBk_FI::RequestSliceCallHistoryListExtendedCallbackIF,
   public ::MOST_PhonBk_FI::CreatePhoneBookListCallbackIF,
   public ::MOST_PhonBk_FI::ReleasePhoneBookListCallbackIF,
   public ::MOST_PhonBk_FI::RequestPhoneBookListSliceCallbackIF,
   public ::MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedCallbackIF,
   public ::MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF,
   public ::MOST_PhonBk_FI::SearchKeyboardPhoneBookListCallbackIF,
   public ::MOST_PhonBk_FI::GetDeviceCallHistorySupportCallbackIF,
//  public ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportCallbackIF,
   public ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportExtendedCallbackIF,
   public ::MOST_PhonBk_FI::ListChangeCallbackIF,
   public ::MOST_PhonBk_FI::DownloadStateExtendedCallbackIF,
   public ::MOST_PhonBk_FI::PreferredPhoneBookSortOrderCallbackIF,
   public ::MOST_PhonBk_FI::MissedCallIndicatorCallbackIF,
   public ::MOST_PhonBk_FI::ClearMissedCallIndicatorCallbackIF

{
   private:
      ServicePhoneBook();
   public:
      //ServicePhoneBook(::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > _PhoneBookProxy);

      virtual ~ServicePhoneBook();

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onSearchPhoneBookResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchPhoneBookResult >& result);
      virtual void onSearchPhoneBookError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchPhoneBookError >& /*error*/);

      //(SWFL-278, SWFL-279, SWFL-285, SWFL-292, SWFL-1953, SWFL-1961, SWFL-270, SWFL-283, SWFL-299)
      virtual void onAutocompletePhoneNumberEntryError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::AutocompletePhoneNumberEntryError >& /* error*/);
      virtual void onAutocompletePhoneNumberEntryResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::AutocompletePhoneNumberEntryResult >& result);

      //(SWFL-305, SWFL-306)
      virtual void onCreateCallHistoryListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreateCallHistoryListResult >& result);
      virtual void onCreateCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreateCallHistoryListError >& /*error*/);

      virtual void onReleaseCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleaseCallHistoryListError >& /*error*/);
      virtual void onReleaseCallHistoryListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleaseCallHistoryListResult >& result);

      virtual void onRequestSliceCallHistoryListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListError >& /*error*/);
      virtual void onRequestSliceCallHistoryListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListResult >& result);

      //(SWFL-305, SWFL-306)
      virtual void onRequestSliceCallHistoryListExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListExtendedError >& /*error*/);
      virtual void onRequestSliceCallHistoryListExtendedResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestSliceCallHistoryListExtendedResult >& result);

      //(SWFL - 706, SWFL - 1944)
      virtual void onCreatePhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreatePhoneBookListError >& /*error*/);
      virtual void onCreatePhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::CreatePhoneBookListResult >& result);

      virtual void onReleasePhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleasePhoneBookListError >& /*error*/);
      virtual void onReleasePhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ReleasePhoneBookListResult >& result);

      virtual void onRequestPhoneBookListSliceError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceError >& /*error*/);
      virtual void onRequestPhoneBookListSliceResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceResult >& result);

      //(SWFL - 706, SWFL - 1944)
      virtual void onRequestPhoneBookListSliceExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedError >& /*error*/);
      virtual void onRequestPhoneBookListSliceExtendedResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedResult >& result);
      // (SWFL - 1946)
      //virtual void onGetContactDetailsError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::GetContactDetailsError >& error);
      //virtual void onGetContactDetailsResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::GetContactDetailsResult >& result);

      virtual void onSearchKeyboardPhoneBookListError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchKeyboardPhoneBookListError >& error);
      virtual void onSearchKeyboardPhoneBookListResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::SearchKeyboardPhoneBookListResult >& result);

      virtual void onClearMissedCallIndicatorError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ClearMissedCallIndicatorError >& /*error*/);
      virtual void onClearMissedCallIndicatorResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_PhonBk_FI::ClearMissedCallIndicatorResult >& result);

      virtual void onGetDeviceCallHistorySupportError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::GetDeviceCallHistorySupportError >& /*error*/);
      virtual void onGetDeviceCallHistorySupportResult(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::GetDeviceCallHistorySupportResult >& result);

      //(SWFL-305, SWFL-306),SWFL-302,//(SWFL - 706, SWFL - 1944),SWFL-706
      // virtual void onDevicePhoneBookFeatureSupportStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportStatus >& status);
      // virtual void onDevicePhoneBookFeatureSupportError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportError >& /*error*/);

      virtual void onDevicePhoneBookFeatureSupportExtendedStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportExtendedStatus >& status);
      virtual void onDevicePhoneBookFeatureSupportExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::DevicePhoneBookFeatureSupportExtendedError >& /*error*/);

      virtual void onListChangeStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::ListChangeStatus >& status);
      virtual void onListChangeError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::ListChangeError >& /*error*/);

      //SWFL-1943 (SWFL-1945, SWFL-1972, SWFL-1973)
      virtual void onDownloadStateExtendedError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::DownloadStateExtendedError >& error);
      virtual void onDownloadStateExtendedStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::DownloadStateExtendedStatus >& status);

      virtual void onPreferredPhoneBookSortOrderError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::PreferredPhoneBookSortOrderError >& error);
      virtual void onPreferredPhoneBookSortOrderStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_PhonBk_FI::PreferredPhoneBookSortOrderStatus >& status);

      virtual void onMissedCallIndicatorError(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::MissedCallIndicatorError >& /*error*/);
      virtual void onMissedCallIndicatorStatus(const ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_PhonBk_FI::MissedCallIndicatorStatus >& status);

      // Callback 'GetContactDetailsExtendedCallbackIF'
      virtual void onGetContactDetailsExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedError >& error);
      virtual void onGetContactDetailsExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< GetContactDetailsExtendedResult >& result);

      tBool vGetContactInfo(std::string strTelphoneno);

      most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder enGetSortOrder()
      {
         return enCurrSortOrder;
      }
      void vSetSortOrder(most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder enSortOrder);

   private:
      ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > _most_phonbk_fi;
      CallHistoryModel& rfoCallHistoryModel;
      SpellerModel& rfoSpellerModel;
      PhonebookModelComponent& rfoPhonebookModelComponent;

      /* vector in which the information of the matched phone number entries are populated */
      std::vector<btphn_trPhnBkMatchListEntry> arMatchList;
      /*to store All the List supported states*/
      btphn_trPhnBkListSupport rListSupport;
      /*to store call list download status*/
      most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended enCallListDownloadState;
      /*to store Phonebook list download status*/
      most_PhonBk_fi_types_Extended::T_e8_PhonBkPhoneBookDownloadStateExtended enPhnBkDownloadState;
      /*To store the Dialed Number in DialPad*/
      std::string strEditInfo;

      /* Set to TRUE if the phone type of the preferred number has to be determined */
      tBool bContactInfoRequired;

      //Storing telephone no for  search phone book
      std::string strTelephoneNumber;

      /*to store call list supported satus*/
      bool bCallListSupportStatus;
      int mContacthandle;
      /* Maintains the current sort order in which the list entries are
      displayed */
      most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder enCurrSortOrder;
      most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType enSortType;
      /*structure to store created list information such as list handle, list size and list sort type for Phonebook list*/
      btphn_trContactListData  rContactListData;

      /*to store start index and window size of Phonebook*/
      tU32 m_PBStartIndex;
      tU32 m_PBWindowSize;
      tU32 m_lastItemIndex_PBList;

      //Checks if the Contacts list needs to be loaded with History or from Start index 0
      tBool bLoadPersistent;

      tU32 m_U8ViewPortStartIndex;

      //******************///
      /*structure to store created list information such as list handle, list size and list sort type*/
      btphn_trCallListData rCallListData;
      tU16 m_StartIndex_CallList;
      tU16 m_WindowSize_CallList;
      tU16 m_lastItemIndex_CallList;

      //To check if a Dial is initated from CallList
      tBool bReqCallListDialInfo;

      /* Allocating memory for 7 contact numbers + Preferred number */
      std::string acopcContactNumbers[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER + 1];

      tU32 u32NumOfMissedCall;

      std::string  KeyPressed;

      tU8 activeDevIndex;

      /* binding for Dialpad input text */
      DataBindingItem<PhoneDialPadInputTextDataBindingSource> oDialPadInputText;

      DECLARE_CLASS_LOGGER();
      bool onCourierMessage(const CallListReq& oMsg); //(SWFL-305, SWFL-306),SWFL-302
      bool onCourierMessage(const ContactListReq& oMsg); //(SWFL - 706, SWFL - 1944),SWFL-706
      bool onCourierMessage(const DialCall_ModelReq& oMsg);
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      virtual bool onCourierMessage(const ContactDetailsReq& oMsg);// (SWFL - 1946)
      virtual bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      virtual bool onCourierMessage(const ListMovementFinishedUpdMsg& oMsg);

      //(SWFL-278, SWFL-279, SWFL-285, SWFL-292, SWFL-1953, SWFL-1961, SWFL-270, SWFL-283, SWFL-299)
      bool onCourierMessage(const SpellerKeyPressed& oMsg);
      bool onCourierMessage(const ClearEditFieldRequestReq& oMsg);
      bool onCourierMessage(const ResetListDataReq& oMsg);
      bool onCourierMessage(const MatchListEntryReq& oMsg);
      bool onCourierMessage(const ResetSortOrderReq& oMsg);
      bool onCourierMessage(const hmibase::widget::editfield::EditFieldUpdMsg& oMsg);
      //	 virtual bool onCourierMessage(const WaitPopUpReqMsg& oMsg);
      virtual bool onCourierMessage(const AnimationWidgetIndMsg& oMsg);
      // ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
   public:
      /*to access Phonebook functions and variable from other clients*/
      static ServicePhoneBook* _mPBKHelper;
      static ServicePhoneBook* poGetInstance();

      /*incoming courier messages*/
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(ListMovementFinishedUpdMsg)
      ON_COURIER_MESSAGE(CallListReq)
      ON_COURIER_MESSAGE(ContactListReq)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ContactDetailsReq)
      ON_COURIER_MESSAGE(SpellerKeyPressed)
      ON_COURIER_MESSAGE(DialCall_ModelReq)
      ON_COURIER_MESSAGE(ClearEditFieldRequestReq)
      ON_COURIER_MESSAGE(ResetListDataReq)
      ON_COURIER_MESSAGE(AnimationWidgetIndMsg)
      ON_COURIER_MESSAGE(ResetSortOrderReq)
      //		ON_COURIER_MESSAGE(WaitPopUpReqMsg)
      ON_COURIER_MESSAGE(hmibase::widget::editfield::EditFieldUpdMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      COURIER_BINDING_MAP_BEGIN()
      COURIER_BINDING_ITEM_CHANGE(PhoneDialPadInputTextItem)
      COURIER_BINDING_MAP_END()

      tU32 u32GetNumOfMissedCall()
      {
         return u32NumOfMissedCall;
      }

      /*Binding source to update Scroll Status  */
      DataItemContainer<QuickScrollSearchDataBindingSource> quickScrollSearch;

      /*sets enCallListDownload state*/
      void vSetCallListDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended CallListDownloadState);

      /*returns CallListDownload state for the connected device*/
      most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended enGetCallListDownloadState();
      /*calls slice call history extended method start*/
      void vSendSliceCallHistoryExtendedStart(int startIndex, int WindowSize);
      /*phonebook list slice extended method start*/
      void vSendRequestPhoneBookListSliceExtendedStart(int startIndex, int WindowSize);
      /*Get Contact details  method start*/
      void vsendGetContactDetailsStart(); // (SWFL - 1946)
      /* Sends the support status of PhoneBook lists *///(SWFL-305, SWFL-306),SWFL-302,(SWFL - 706, SWFL - 1944),SWFL-706
      void vUpdateListSupportStatus(tRCU8 corfu8DeviceHandle, const btphn_trPhnBkListSupport& corfrListSupport);
      /*calls slice call history method start*/
      void vRequestCallListData();//(SWFL-305, SWFL-306)
      /*posts courier message to to controller and  sends */
      /*calls Phonebookslice method start*/
      void vRequestContactListData(); //(SWFL - 706, SWFL - 1944)
      void covSendCallList(tU16 corfu16TotalListSize);//(SWFL-305, SWFL-306),SWFL-302
      /*posts courier message to to controller and  sends updates of contacts list*/
      void covSendContactList(tU16 corfu16TotalListSize);//(SWFL - 706, SWFL - 1944),SWFL-706
      /*used to reset call list items and to release call list*/
      void vDeleteCallList(); // SWFL - 302
      /*used to reset contaccts list items and to release contacts list*/
      void vDeleteContactList();//SWFL-706
      /*deletes all the list maintained by service phonebook*/
      tVoid vDeleteAllLists();
      void updatecharInBubble(std::string firstchar);
      /*uses to call the method start GetDetailedContact using the row value*/
      void  vGetContacthandle(tU32 rowvalue); // (SWFL - 1946)

      //(SWFL - 278, SWFL - 279, SWFL - 285, SWFL - 292, SWFL - 1953, SWFL - 1961, SWFL - 270, SWFL - 283, SWFL - 299)
      void vSendAutoCompletePhoneNumber(std::string strEditInfo);
      tVoid vMatchListItemInfo(tU8 hdlRow);
      tVoid vCallListItemInfo(tU8 hdlRow); //(SWFL-305, SWFL-306)

      /*called when button reaction message is received from settings list for INF4CV*/
      tVoid vSettingListInfoCoach(tU8 hdlRow);

      /*called when button reaction message is received from settings list for INF4CV*/
      tVoid vSettingListInfoSmart(tU8 hdlRow);

      /*called when button reaction message is received from sort list */
      tVoid vSortOrderList(tU8 hdlRow);

      void onRemoteControlKeyPress(std::string inputStr);

      tVoid covUpdatePrefNumType(std::string copcFirstName, std::string copcLastName, std::string acopcContactNumbers[]);
      void vDialCallMethodStart(tU8 hdlRow);
      void OnSortPhonebook(tU8 Sortorder);
      tVoid vCreateContactDetailsList(std::string copcFirstName, std::string  copcLastName, std::string  acopcContactNumbers[], tU8 ContactDetailType[]); // (SWFL - 1946)

      bool onCourierBindingItemChange_PhoneDialPadInputTextItem(const Courier::Request& request);
      void vDeleteContactListOnToggle();//Bug 880047
      void vDeleteCallListOnToggle();//Bug 880047
      tU32 u32GetCharacterByteLength(tU8 u8StartByte);	//Bug: 884735

      std::string ContactNumbersList[BTPHN_C_CONTACT_DETAILS_MAX_NUMBER + 1];//680019
      bool bCurrentActiveTab; //Bug 711626
      std::map<tU8, tU8> m_phonebookSupportStatus;
      tBool bPhonebookContactSupport;
      tU16 m_u16PBcurrentlisthandle;//Bug 880046
};


}
}


#endif
