/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : MicClientHandler.h
* COMPONENT Name      : Apphmi_Phone
* DESCRIPTION         : Takes care of the MIC related handling for Phone and Intercom features
* AUTHOR              : Bruce Netto
* Revision History    : 0.1
* Date 04.10.2020     : Initial version
****************************************************************************/
#ifndef MIC_CLIENT_HANDLER_H
#define MIC_CLIENT_HANDLER_H
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesClientBase.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include "AppHmi_PhoneStateMachineData.h"
#include "AppHmi_PhoneDatabinding.h"
#include "AppHmi_PhoneMessages.h"
#include "AppHmi_PhoneStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "IntercomModel.h"
#endif
//#include "Project_Trace.h"
#include "asf/core/Logger.h"
#include "ProjectPluginMsgs.h"
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice
#define AUDIO_SOUND_PROPERTIES ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
static const uint16_t SYP_PRIVATE_MODE  = 13;
#define SYP_PRIVATE_MODE_1      ((int16_t) 1) // Private mode OFF
#define SYP_PRIVATE_MODE_2      ((int16_t) 2) //Private mode ON
#define SYP_PRIVATE_MODE_3      ((int16_t) 3) //Private mode ON
#endif
using namespace ::asf::core;
using namespace Courier;

namespace App {
namespace Core {
enum enMicStatus
{
   enMIC_Off = 0u,
   enMIC_BTCall,
   enMIC_IntercomCall,
   enMIC_BTCall_Intercom,
   enMIC_Intercom_BTCall
};


class MicClientHandler : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListCallbackIF
   , public AUDIO_SOUND_PROPERTIES::SystemPropertyChangedCallbackIF
   , public AUDIO_SOUND_PROPERTIES::SetSystemPropertyCallbackIF
   , public AUDIO_SOUND_PROPERTIES::SystemPropertyListCallbackIF
{
   public:
      virtual ~MicClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListError >& error);
      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListUpdate >& signal);

      void onSystemPropertyChangedError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SystemPropertyChangedError >& error);
      void onSystemPropertyChangedSignal(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SystemPropertyChangedSignal >& signal);

      void onSetSystemPropertyError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetSystemPropertyError >& error);
      void onSetSystemPropertyResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetSystemPropertyResponse >& response);

      void onSystemPropertyListError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SystemPropertyListError >& error) ;
      void onSystemPropertyListUpdate(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SystemPropertyListUpdate >& update);

   public:
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      ON_COURIER_MESSAGE(PrivateModeUpdateMsg)
#endif
      COURIER_MSG_MAP_DELEGATE_END()
      DECLARE_CLASS_LOGGER();
      static MicClientHandler* poGetInstance();
      static MicClientHandler* _MicInstance;

      void vHandleMIC(bool l_bmicStatus);
      //void vCheckforEnableDialpadCallButton();
      bool m_bMIC1Status;

      void vSetMicStatus(enMicStatus micStatus);
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      bool m_bPrivateMode;
      void vTogglePrivateMode();
      void onPrivateModeUpdate(int privateMode);
#endif
      bool getMicStatus()
      {
         return m_bMIC1Status;
      }
      enMicStatus getEnMicStatus()
      {
         return _enMicStatus;
      }
   private:
      bool onCourierMessage(const ButtonReactionMsg& oMsg);

      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy > _audioSoundPropertiesProxy;

      MicClientHandler();
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      IntercomModel& rfoIntercomModel;
      bool onCourierMessage(const PrivateModeUpdateMsg& oMsg);
#endif
      Courier::DataItemContainer<SpeedLockDataBindingSource> speedlock;
      enMicStatus _enMicStatus;
};


}//namespace Core
}//namespace App

#endif /*MIC_CLIENT_HANDLER_H*/
