/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
****************************************************************************/
#ifndef SERVICEMSG_HEADER
#define SERVICEMSG_HEADER

#define GENERIC_FI_INTERFACE
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
//Add include files here
#define BTPHNMSG_C_WINDOW_START 0
#define BTPHNMSG_C_WINDOW_SIZE 1
#define BTPHN_C_NAVI_ACTIVE 1

#include "most_fi_if.h"
#include "midw_fi_if.h"
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "MOST_Msg_FI.h"
#include "MOST_Msg_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "MessagingDataTypes.h"
#include "MsgModelComponent.h"
#include "AppHmi_PhoneTypes.h"
#include "PhonebookModelComponent.h"
#include "App/Core/BTPhoneDefines.h"

using namespace ::asf::core;
using namespace ::MOST_Msg_FI;


//Forward Declarations
class tclMostMsgFiIf;
class MSGModelComponent;

namespace App {
namespace Core {

#define BTPHNMSG_C_WINDOW_START 0
#define BTPHNMSG_C_WINDOW_SIZE 1

class ServiceMsg :
   public hmibase:: ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public MOST_Msg_FI::CreateMessageListCallbackIF,
   public MOST_Msg_FI::RequestSliceMessageListCallbackIF,
   public MOST_Msg_FI::ReleaseMessageListCallbackIF,
   public MOST_Msg_FI::MessageListChangeCallbackIF,
   public MOST_Msg_FI::MessagingDeviceConnectionCallbackIF,
   public ::MOST_Msg_FI::GetMessageCallbackIF,
   public ::MOST_Msg_FI::ReadMessageAloudExtendedCallbackIF,
   public MOST_Msg_FI::MessagingAudioPlaybackStateCallbackIF,
   public MOST_Msg_FI::MapDeviceCapabilitiesExtendedCallbackIF
{
   public:
      ServiceMsg();

      static ServiceMsg* poGetInstance()
      {
         if (NULL == _poServiceMsg)
         {
            _poServiceMsg = new ServiceMsg();
         }
         return _poServiceMsg;
      }
      virtual ~ServiceMsg();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange) ;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      /*Manual Code for CCA interface*/

      // class AllocateCallbackIF implementation

      // class CreateMessageListCallbackIF implementation
      virtual void onCreateMessageListError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::CreateMessageListError >& error);
      virtual void onCreateMessageListResult(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::CreateMessageListResult >& result);

      virtual void onGetMessageError(const ::boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Msg_FI::GetMessageError >& /*error*/);
      virtual void onGetMessageResult(const ::boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Msg_FI::GetMessageResult >& result);

      // class RequestSliceMessageListCallbackIF implementation
      virtual void onRequestSliceMessageListError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::RequestSliceMessageListError >& error);
      virtual void onRequestSliceMessageListResult(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::RequestSliceMessageListResult >& result);

      // class ReleaseMessageListCallbackIF implementation
      virtual void onReleaseMessageListError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::ReleaseMessageListError >& error);
      virtual void onReleaseMessageListResult(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::ReleaseMessageListResult >& result);

      virtual void onReadMessageAloudExtendedError(const ::boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Msg_FI::ReadMessageAloudExtendedError >& /*error*/);
      virtual void onReadMessageAloudExtendedResult(const ::boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Msg_FI::ReadMessageAloudExtendedResult  >& result);

      // class MessageListChangeCallbackIF implementation
      virtual void onMessageListChangeError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessageListChangeError >& error);
      virtual void onMessageListChangeStatus(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessageListChangeStatus >& status);

      // class MessagingDeviceConnectionCallbackIF implementation
      virtual void onMessagingDeviceConnectionError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessagingDeviceConnectionError >& error);
      virtual void onMessagingDeviceConnectionStatus(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessagingDeviceConnectionStatus >& status);

      // class MessagingAudioPlaybackStateCallbackIF implementation
      virtual void onMessagingAudioPlaybackStateError(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessagingAudioPlaybackStateError >& error);
      virtual void onMessagingAudioPlaybackStateStatus(const :: boost::shared_ptr< ::MOST_Msg_FI::MOST_Msg_FIProxy >& proxy, const boost::shared_ptr< ::MOST_Msg_FI::MessagingAudioPlaybackStateStatus >& status);
      // class MapDeviceCapabilitiesExtendedCallbackIF implementation
      virtual void onMapDeviceCapabilitiesExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesExtendedError >& error);

      virtual void onMapDeviceCapabilitiesExtendedStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesExtendedStatus >& status);
      void vOnChangeSMSSettings();
      void vSetShowMessageStatus(bool bEnable)
      {
         m_bShowMessageStatus = bEnable;
      }

   private:
      void vInit();
      static ServiceMsg* _poServiceMsg;
      ::boost::shared_ptr< MOST_Msg_FIProxy > _MsgProxy;
      MSGModelComponent& rfoMSGModelComponent;
      DECLARE_CLASS_LOGGER();

      mutable tU16 m_u16MessageListHandle;
      std::vector<int> messageHandleList;
      tU8 u8ConnectedDeviceHandle; // Device handle of connected device

      btphn_trMsgHandle rMsgMessageHandle;
      btphn_trMsgDetailsResult rMessageDetails;

      virtual bool onCourierMessage(const ReadMessageAloudReq& oMsg);
      virtual bool onCourierMessage(const MessageDialReq& oMsg);
      virtual bool onCourierMessage(const DeviceHandleResp& oMsg);

      void vExtractMessageHeader(btphn_trMsgListSupport& rMsgListEntry, const boost::shared_ptr< ::MOST_Msg_FI::RequestSliceMessageListResult >& result);
      void vLogMessageHeader(btphn_trMsgListSupport& rMsgListEntry);
      tVoid vDeleteMsgList();
      bool m_bShowMessageStatus;

   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ReadMessageAloudReq)
      ON_COURIER_MESSAGE(MessageDialReq)
      ON_COURIER_MESSAGE(DeviceHandleResp)
      COURIER_MSG_MAP_END()
};


} // namespace Core
} // namespace App
#endif
