/************************************************************************
*FILE:			MessagingDataTypes.h
*SW-COMPONENT: BTPhone
*DESCRIPTION:  User defined data types with respect to Messaging Functionalities
*AUTHOR:		Anarasi Bikash Patro
*COPYRIGHT: 	(c) 2018-2018 Robert Bosch Car Multimedia GmbH
*HISTORY:
*11.07.2017 Rev. 01. Supriya Seshadri
Initial version
************************************************************************/

#ifndef MESSAGINGDATATYPES_HEADER
#define MESSAGINGDATATYPES_HEADER

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/
#ifndef WINDOWS_SIMULATION
#include "osal_if.h" // For including the OSAL related files.
#else
#include "tTypes.h"
#include <string>
#endif


/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
#define BTPHN_C_DEFAULT_VALUE_ZERO 0 // Default assigned during initialization
#define BTPHN_C_CONTACT_UNKNOWN "unknown"
typedef enum
{
   /* This is the Inbox folder */
   BTPHN_EN_MSG_FOLDER_INBOX = 0UL,

   /* This is the Deleted folder */
   BTPHN_EN_MSG_FOLDER_DELETED = 1UL,

   /* This is the Drafts folder */
   BTPHN_EN_MSG_FOLDER_DRAFTS = 2UL,

   /* This is the Sent folder */
   BTPHN_EN_MSG_FOLDER_SENT = 3UL,

   /* This folder is a user defined folder */
   BTPHN_EN_MSG_FOLDER_USERDEFINED = 4UL,

   /* This folder cannot be accessed (private, etc.) */
   BTPHN_EN_MSG_FOLDER_INACCESSIBLE = 5UL,

   /* This is the Outbox folder used when sending a message */
   BTPHN_EN_MSG_FOLDER_OUTBOX = 6UL
} btphn_MsgFolderType;

typedef enum
{
   /* Message list type of SMS/MMS */
   BTPHN_EN_MSG_LIST_SMS_MMS = 0UL,

   /* Message list type of email */
   BTPHN_EN_MSG_LIST_EMAIL = 1UL
} btphn_MsgListType;

typedef enum
{
   BTPHN_EN_MSG_LIST_SORT_TIMESTAMP = 0UL,

   BTPHN_EN_MSG_LIST_SORT_LASTNAME = 1UL,

   BTPHN_EN_MSG_LIST_SORT_FIRSTNAME = 2UL,

   BTPHN_EN_MSG_LIST_SORT_ADDRESS = 3UL,

   BTPHN_EN_MSG_LIST_SORT_PHONENUMBER = 4UL,

   BTPHN_EN_MSG_LIST_SORT_CONVERSATION = 5UL
} btphn_MsgListSortType;

typedef enum
{
   /* All messages from the containing folder are included */
   BTPHN_EN_MSG_LIST_FILTER_ALL = 0UL,

   /* Only unread messages are returned */
   BTPHN_EN_MSG_LIST_FILTER_UNREAD = 1UL
} btphn_MsgListFilterType;

typedef enum
{
   BTPHN_EN_MSG_LCH_CONTENT_CHANGED = 0UL,

   BTPHN_EN_MSG_LCH_ITEMS_ADDED = 1UL,

   BTPHN_EN_MSG_LCH_ITEMS_REMOVED = 2UL,

   BTPHN_EN_MSG_LCH_ITEMS_CHANGED = 3UL
} btphn_MsgListChangeType;

typedef enum
{
   BTPHN_EN_E8MSG_TYPE_SMS = 0UL,

   BTPHN_EN_E8MSG_TYPE_MMS = 1UL,

   BTPHN_EN_E8MSG_TYPE_EMAIL = 2UL
} btphn_MsgType;

typedef enum
{
   BTPHN_EN_E8DELIVERY_SUCCESS = 0UL,

   BTPHN_EN_E8DELIVERY_FAILURE = 1UL,

   BTPHN_EN_E8SENDING_SUCCESS = 2UL,

   BTPHN_EN_E8SENDING_FAILURE = 3UL
} btphn_MsgSendMsgResultType;

typedef struct
{
   tU8 u8DeviceHandle;
   tU32 u32MsgHandleUpper;
   tU32 u32MsgHandleLower;
} btphn_trMsgHandle;

struct btphn_trMsgDate
{
   std::string copcCldrYear;
   std::string copcCldrMonth;
   std::string copcCldrDay;

   btphn_trMsgDate():
      copcCldrYear(""),
      copcCldrMonth(""),
      copcCldrDay("")
   {}
};


struct btphn_tsMsgTime
{
   std::string copcHours;
   std::string copcMinutes;
   std::string copcSecounds;

   btphn_tsMsgTime() :
      copcHours(""),
      copcMinutes(""),
      copcSecounds("")
   {
   }
};


struct btphn_trMsgDateTime
{
   btphn_trMsgDate rMsgdate;
   btphn_tsMsgTime rMsgTime;

   btphn_trMsgDateTime():
      rMsgdate(),
      rMsgTime()
   {}
};


typedef struct
{
   btphn_trMsgHandle rMsgHandle;
   btphn_trMsgDateTime rMsgDateTime;
   std::string copcSubject;
   std::string copcShortMessage;
   tBool bAttachmentFlag;
   btphn_MsgType enMsgType;
   btphn_MsgSendMsgResultType enMsgSendMsgResultType;
   tBool bReadStatusFlag;
   std::string copcFirstName;
   std::string copcLastName;
   std::string copcEmailAddress;
   std::string copcPhoneNumber;
} btphn_trMsgListSupport;

typedef struct
{
   tU16 rMsgAccountHandle;
   std::string rMsgAccountName;
} btphn_trMsgActiveAccount;

struct btphn_trMsgDetailsResult
{
   btphn_trMsgDateTime rMsgDateTime;
   std::string copcSubject;
   std::string copcShortMessage;
   std::string copcPhoneNumber;
   std::string copcFirstName;
   std::string copcLastName;
   tU8 u8NumAttachment;
   tU8 u8NumbodyParts;

   btphn_trMsgDetailsResult(): rMsgDateTime(),
      copcSubject(""),
      copcShortMessage(""),
      copcPhoneNumber(""),
      copcFirstName(""),
      copcLastName(""),
      u8NumAttachment(0),
      u8NumbodyParts(0)
   {}
};


typedef enum
{
   BTPHN_EN_E8ENGLISHUS = 0UL,

   BTPHN_EN_E8FRENCH_CANADIAN = 1UL,

   BTPHN_EN_E8MEXICAN_SPANISH = 2UL,

   BTPHN_EN_E8EUROPEAN_ENGLISH = 3UL,

   BTPHN_EN_E8EUROPEAN_SPANISH = 4UL,

   BTPHN_EN_E8EUROPEAN_FRENCH = 5UL,

   BTPHN_EN_E8EUROPEAN_GERMAN = 6UL,

   BTPHN_EN_E8CLASSICAL_ARABIC = 7UL,

   BTPHN_EN_E8KOREAN = 8UL,

   BTPHN_EN_E8STANDARD_CHINESE = 9UL,

   BTPHN_EN_E8ITALIAN = 10UL,

   BTPHN_EN_E8SWEDISH = 11UL,

   BTPHN_EN_E8DUTCH = 12UL,

   BTPHN_EN_E8HUNGARIAN = 13UL,

   BTPHN_EN_E8CZECK = 14UL,

   BTPHN_EN_E8NORWEGIAN = 15UL,

   BTPHN_EN_E8DANISH = 16UL,

   BTPHN_EN_E8SLOVAK = 17UL,

   BTPHN_EN_E8PORTUGESE = 18UL,

   BTPHN_EN_E8RUSSIAN = 19UL,

   BTPHN_EN_E8GREEK = 20UL,

   BTPHN_EN_E8FINNISH = 21UL,

   BTPHN_EN_E8JAPANESE = 22UL,

   BTPHN_EN_E8TURKISH = 23UL,

   BTPHN_EN_E8USE_SYSTEM_LANGUAGE_SELECTION = 255UL
} btphn_trTTSLanguage;


#endif // MESSAGINGDATATYPES_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
