#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                :
* COMPONENT Name      :
* DESCRIPTION         :
* AUTHOR              :
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/
#ifndef INTERCOM_CLIENT_HANDLER_H
#define INTERCOM_CLIENT_HANDLER_H
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "AppHmi_PhoneStateMachineData.h"
#include "AppHmi_PhoneDatabinding.h"
#include "AppHmi_PhoneMessages.h"
#include "AppHmi_PhoneStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
//#include "Project_Trace.h"
#include "bosch/cm/ai/IntercomAudioServiceProxy.h"
#include "bosch/cm/ai/IntercomAudioService.h"
#include "bosch/cm/ai/IntercomAudioServiceDBus.h"
#include "bosch/cm/ai/IntercomAudioServiceJson.h"
#include "bosch/cm/ai/IntercomAudioServiceClientBase.h"
#include "asf/core/Logger.h"
#include "IntercomModel.h"
#include "PhoneGadgetModel.h"
#include "ProjectPluginMsgs.h"
#include "SPM_CORE_FIProxy.h"

using namespace ::asf::core;
using namespace ::bosch::cm::ai::IntercomAudioService;
using namespace Courier;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

namespace App {
namespace Core {
class IntercomClienthandler : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public IncomingCallCallbackIF
   , public OutgoingCallCallbackIF
   , public CallActionCallbackIF
   , public ActiveCallStatusCallbackIF
   , public CancelCallCallbackIF
   , public IntercomServiceAvailabilityCallbackIF
   , public RspPhoneStatusCallbackIF
   , public EventPhoneStatusChangedCallbackIF
   , public GetPhoneStatusCallbackIF
   , public EventNanoMessageErrorStatusCallbackIF
   , public EventRTPErrorStatusCallbackIF
   , public EventInterComConfigErrorCallbackIF
   , public EventAudioAllocationStatusCallbackIF
   , public CabinsSystemsInfoCallbackIF
   , public CabinsSourceRestorationInfoCallbackIF
   , public RspIntercomAvailableCallbackIF
   , public EventIntercomAvailableCallbackIF
   , public GetAvailabilityCallbackIF
   , public ::SPM_CORE_FI::HmiStateCallbackIF

{
   public:
      virtual ~IntercomClienthandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      // Callback 'CallActionCallbackIF'

      virtual void onCallActionError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionError >& error);
      virtual void onCallActionResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionResponse >& response);

      // Callback 'IncomingCallCallbackIF'

      virtual void onIncomingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallError >& error);
      virtual void onIncomingCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallSignal >& signal);

      // Callback 'OutgoingCallCallbackIF'

      virtual void onOutgoingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallError >& error);
      virtual void onOutgoingCallResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallResponse >& response);

      // Callback 'CancelCallCallbackIF'

      virtual void onCancelCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallError >& error);
      virtual void onCancelCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallSignal >& signal);

      // Callback 'ActiveCallStatusCallbackIF'

      virtual void onActiveCallStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusError >& error);
      virtual void onActiveCallStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusSignal >& signal);

      // Callback 'IntercomServiceAvailabilityCallbackIF'
      virtual void onIntercomServiceAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilityError >& error);
      virtual void onIntercomServiceAvailabilitySignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilitySignal >& signal);

      // Callback 'RspPhoneStatusCallbackIF'

      virtual void onRspPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusError >& error);
      virtual void onRspPhoneStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusSignal >& signal);

      // Callback 'EventPhoneStatusChangedCallbackIF'

      virtual void onEventPhoneStatusChangedError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedError >& error);
      virtual void onEventPhoneStatusChangedSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedSignal >& signal);

      // Callback 'GetPhoneStatusCallbackIF'

      virtual void onGetPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusError >& error);
      virtual void onGetPhoneStatusResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusResponse >& response);

      // Callback 'EventInterComConfigErrorCallbackIF'

      virtual void onEventInterComConfigErrorError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorError >& error);
      virtual void onEventInterComConfigErrorSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorSignal >& signal);

      // Callback 'EventNanoMessageErrorStatusCallbackIF'

      virtual void onEventNanoMessageErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusError >& error);
      virtual void onEventNanoMessageErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusSignal >& signal);

      // Callback 'EventRTPErrorStatusCallbackIF'

      virtual void onEventRTPErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusError >& error);
      virtual void onEventRTPErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusSignal >& signal);

      //Callback 'EventAudioAllocationStatusCallbackIF'

      virtual void onEventAudioAllocationStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventAudioAllocationStatusError >& error);
      virtual void onEventAudioAllocationStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventAudioAllocationStatusSignal >& signal);

      //Callback 'CabinsSystemsInfoCallbackIF'

      virtual void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< CabinsSystemsInfoError >& error);
      virtual void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update);

      virtual void onRspIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspIntercomAvailableError >& error);
      virtual void onRspIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspIntercomAvailableSignal >& signal);

      //Callback 'EventIntercomAvailableCallbackIF'
      virtual void onEventIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventIntercomAvailableError >& error);
      virtual void onEventIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventIntercomAvailableSignal >& signal);

      //Callback 'GetAvailabilityCallbackIF'
      virtual void onGetAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailabilityError >& error);
      virtual void onGetAvailabilityResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailabilityResponse >& response);

      //Callback 'CabinsSourceRestorationInfoCallBackIF'
      //Callback 'RspIntercomAvailableCallbackIF'
      virtual void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error);
      virtual void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update);

      // Callback 'HmiStateCallbackIF'
      void onHmiStateError(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                           const boost::shared_ptr< ::SPM_CORE_FI::HmiStateError >& /*error*/);
      void onHmiStateStatus(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                            const boost::shared_ptr< ::SPM_CORE_FI::HmiStateStatus >& /*status*/);
   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(IntercomCallResponseReq)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(IContactsReq)
      ON_COURIER_MESSAGE(TerminateIConfCall)
      COURIER_MSG_MAP_DELEGATE_END()
      DECLARE_CLASS_LOGGER();
      static IntercomClienthandler* poGetInstance();
      static IntercomClienthandler* _IntercomInstance;

      uint8 m_uint8StartupIntercomAvailable;
      bool bIsIntercomIncomingCallPopupActive;
      bool bIsIntercomOutgoingCallPopupActive;
      bool bIsIntercomOngoingCallActive;
      bool m_bIsIntercomConfCallActive;
      bool checkStBit(unsigned char byte, int index);
      bool CheckConnection(bool bEnable, bool bConnection);
      bool getIntercomServiceAvailability();
      bool bRestroomstatus;
      bool bKitchenstatus;
      bool bUpperDeckstatus;
      bool m_bEventInterComConfigErrorStatus;
      bool m_bEventNanoMessageErrorStatus;
      bool m_bEventRTPErrorStatus;
      bool m_bIntercomIncomingSignal;
      bool m_audioallocationstatus;
      bool m_bMissedIntercomCall;
      void OnUpdMissedBTCall();
      void OnUpdTerminateCall();

      bool getIntercomIncomingCallStatus()
      {
         return bIsIntercomIncomingCallPopupActive;
      }
      // Method to retrive the outgoing call Status
      bool getIntercomCallDialingStatus()
      {
         return bIsIntercomOutgoingCallPopupActive;
      }

      bool getIntercomConfCallStatus()
      {
         return m_bIsIntercomConfCallActive;
      }

      // Method to retrive the on going call Status
      bool getIntercomOngoingCallStatus()
      {
         return bIsIntercomOngoingCallActive;
      }

      bool getEventInterComConfigErrorStatus()
      {
         return m_bEventInterComConfigErrorStatus;
      }
      bool getEventNanoMessageErrorStatus()
      {
         return m_bEventNanoMessageErrorStatus;
      }
      bool getEventRTPErrorStatus()
      {
         return m_bEventRTPErrorStatus;
      }
      bool getMissedIntercomCallStatus()
      {
         return m_bMissedIntercomCall ;
      }
      void setMissedIntercomCallStatus(bool bMissedIntercomCall)
      {
         m_bMissedIntercomCall = bMissedIntercomCall;
      }

      Candera::String getStrMissedCall()
      {
         return strMissedCallerID;
      }

      void OnUpdIContactsCall(tU8 hdlRow);
      //Removed Pluginendstaion update as it is depreciated from avdec plugin
      void vCheckAudioAllocationinIncomingCall();
      void vCheckIncomingCallMICActive();
      void OnUpdConferenceCall();
      bool BIsCheckCallStatus(tU16 u16Contacttype);
      void vCheckActiveCallCount(IntercomPhonestatus arPhoneStatus[3]);

   private:

      IntercomClienthandler();

      IntercomModel& rfoIntercomModel;

      Candera::String getCallerId(tU32 u32callerId);
      Candera::String getCallStatus(int Callstatusindex);
      Candera::String strcallerId;
      Candera::String strMissedCallerID;
      tU16 u16Contacttype;
      tU8 m_u8IntercomActiveCallCount;
      tU8 m_u8SystemGroup;
      tU8 m_u8SystemStatus;
      tU8 m_u8SystemCategory;
      tU8 m_u8NanoMsgStatus;

      bool bIsIntercomServiceAvailable;
      bool m_bIsCMAavailable;
      bool m_bIsCMAavailablefirsttimeflag;
      IntercomContactinfo arContactinfo[3];
      IntercomContactinfo arConfCalllist[3];
      IntercomPhonestatus arPhoneStatus[3];
      void OnUpdIcontactLists();
      void ValidateIntercomStatus();
      void OnUpdDisconnectCall();
      void OnUpdDisconnectConfCall();
      void OnUpdConferenceCallList();
      void OnUpdCancelCall();
      bool onCourierMessage(const IntercomCallResponseReq& oMsg);
      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const IContactsReq& oMsg);
      bool onCourierMessage(const TerminateIConfCall& oMsg);

      void OnIntercomDialCall(tU16 u16dialkey);

      ::boost::shared_ptr< bosch::cm::ai::IntercomAudioService:: IntercomAudioServiceProxy > _IntercomAudioServiceProxy;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxy;
      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy> _SPMSetproxy;
};


}
}


#endif
#endif
