/**************************************************************************************
* @file         : ClockSrvClient_Defines.h
* @author       : Palani K
* @addtogroup   : Phone
* @brief        : To support time and date related features for Phone module
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef CLOCKSRVCLIENT_DEFINES_H
#define CLOCKSRVCLIENT_DEFINES_H

namespace App {
namespace Core {

/**
 * Enumeration type of vdClock date format
 */
enum enDateFormat
{
   DateFormat__dd_mm_yyyy_Dash = 1u,
   DateFormat__mm_dd_yyyy_Dash = 2u,
   DateFormat__yyyy_mm_dd_Dash = 3u,
   DateFormat__dd_mm_yyyy_Slash = 4u,
   DateFormat__mm_dd_yyyy_Slash = 5u,
   DateFormat__dd_mm_yyyy_Dot = 6u,
   DateFormat__yyyy_mm_dd_JPN = 7u,
   DateFormat__yyyy_mm_dd_KOR = 8u
};


/**
 * Enumeration type of vdClock time format
 */
enum enTimeFormat
{
   TimeFormat__TF_Mode12 = 1u,
   TimeFormat__TF_Mode24 = 2u
};


}//App
}//Core


#endif /*CLOCKSRVCLIENT_DEFINES_H*/
