/***************************************************************************
* Copyright(c) 2017-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#ifndef SERVICEBT_HEADER
#define SERVICEBT_HEADER

#define GENERIC_FI_INTERFACE
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#include "most_fi_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "midw_fi_if.h"
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppUtils/HmiMacros.h"
#include "AppBase/ServiceAvailableIF.h"
#include "DeviceListModel.h"
#include "Project_Trace.h"
#include "BTPhoneDefines.h"
#include "AppHmi_PhoneTypes.h"
#include "../PhoneBook/ServicePhonebook.h"
#include "PhonebookModelComponent.h"
#include "PhoneCallModel.h"
#include "CallHistoryModel.h"
#include "App/DataModel/PhoneGadgetModel.h"

using namespace ::asf::core;
using namespace ::MOST_BTSet_FI;

//Forward Declarations
class DeviceListModel;
class PhoneCallModel;


namespace App {
namespace Core {
class ServiceBT
   : public hmibase::ServiceAvailableIF,
     public StartupSync::PropertyRegistrationIF,
     public MOST_BTSet_FI::AddNewDeviceCallbackIF,
     public MOST_BTSet_FI::PairingResponseCallbackIF,
     public MOST_BTSet_FI::ChangeDeviceStateCallbackIF,
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
     public MOST_BTSet_FI::RequestAvailableRingtonesListCallbackIF,
#endif
     public MOST_BTSet_FI::PairingStatusCallbackIF,
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
     public MOST_BTSet_FI::ChangeRingtoneCallbackIF,
#endif
     public MOST_BTSet_FI::PairingPinCallbackIF,
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
     public MOST_BTSet_FI::RequestDeviceRingtoneListCallbackIF,
#endif
     public MOST_BTSet_FI::GetDeviceInfoExtendedCallbackIF,
     public MOST_BTSet_FI::VehicleBTFriendlyNameCallbackIF,
     public MOST_BTSet_FI::ConnectBluetoothProfileCallbackIF,
     public MOST_BTSet_FI::MaxDevicesPairedCallbackIF,
     public MOST_BTSet_FI::StartAutoConnectSequenceCallbackIF,
     public MOST_BTSet_FI::DisconnectBluetoothProfileCallbackIF,
     public MOST_BTSet_FI::DeviceListExtendedCallbackIF,
     public MOST_BTSet_FI::SwitchMultiHFPSupportCallbackIF,
     public MOST_BTSet_FI::ClearDeviceInfoCallbackIF
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
   , public MOST_BTSet_FI::SwitchBluetoothOnOffExtendedCallbackIF,
     public MOST_BTSet_FI::BluetoothOnOffCallbackIF,
     public MOST_BTSet_FI::ServiceAvailableCallbackIF
#endif
{
   private:
      static ServiceBT* _mBTHelper;
      ServiceBT();
      std::vector<DeviceListInformation> m_arDeviceListInfo;
      std::map<tU8, btphn_trBTPairedDeviceInfo> m_arConnectedDeviceProfileInfo;
      std::vector<tU8> m_vecDisconnectDeviceList;
      tU8 m_u8ActivePhoneDevice;
      bool m_bIsDisconnectflag;
   public:
      //ServiceBT(/*tclMostBtsetFiIf *pIfClass*/::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy);

      virtual ~ServiceBT();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      /*Manual Code for CCA interface*/

      // class AddNewDeviceCallbackIF implementation
      virtual void onAddNewDeviceError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::AddNewDeviceError >& error);
      virtual void onAddNewDeviceResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::AddNewDeviceResult >& result);

      // class PairingResponseCallbackIF implementation
      virtual void onPairingResponseError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingResponseError >& error);
      virtual void onPairingResponseResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingResponseResult >& result);

      // class ChangeDeviceStateCallbackIF implementation
      virtual void onChangeDeviceStateError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeDeviceStateError >& error);
      virtual void onChangeDeviceStateResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeDeviceStateResult >& result);

      // class RequestAvailableRingtonesListCallbackIF implementation
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onRequestAvailableRingtonesListError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::RequestAvailableRingtonesListError >& error);
      virtual void onRequestAvailableRingtonesListResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::RequestAvailableRingtonesListResult >& result);
#endif

      // class PairingStatusCallbackIF implementation
      virtual void onPairingStatusError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingStatusError >& error);
      virtual void onPairingStatusStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingStatusStatus >& status);

      // class ChangeRingtoneCallbackIF implementation
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onChangeRingtoneError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeRingtoneError >& error);
      virtual void onChangeRingtoneStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeRingtoneStatus >& status);
#endif

      // class PairingPinCallbackIF implementation
      virtual void onPairingPinError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingPinError >& error);
      virtual void onPairingPinStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingPinStatus >& status);

      virtual void onVehicleBTFriendlyNameError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTFriendlyNameError >& /*error*/);
      virtual void onVehicleBTFriendlyNameStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::VehicleBTFriendlyNameStatus >& status);

      virtual void onGetDeviceInfoExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedError >& error);
      virtual void onGetDeviceInfoExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedResult >& result);

      virtual void onMaxDevicesPairedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_BTSet_FI::MaxDevicesPairedError >& /*error*/);
      virtual void onMaxDevicesPairedStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::MaxDevicesPairedStatus >& status);

#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      virtual void onRequestDeviceRingtoneListError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListError >& error);
      virtual void onRequestDeviceRingtoneListResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListResult >& result);
#endif

      virtual void onConnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileError >& error);
      virtual void onConnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileResult >& result);

      virtual void onStartAutoConnectSequenceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceError >& error);
      virtual void onStartAutoConnectSequenceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceResult >& result);

      virtual void onDeviceListExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedError >& error);
      virtual void onDeviceListExtendedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedStatus >& status);

      virtual void onDisconnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileError >& error);
      virtual void onDisconnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileResult >& result);

      virtual void onSwitchMultiHFPSupportError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportError >& error);
      virtual void onSwitchMultiHFPSupportResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportResult >& result);

      virtual void onClearDeviceInfoResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr<ClearDeviceInfoResult>& result);
      virtual void onClearDeviceInfoError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr<ClearDeviceInfoError>& error);

#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      virtual void onSwitchBluetoothOnOffExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedError >& error);
      virtual void onSwitchBluetoothOnOffExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedResult >& result);

      virtual void onBluetoothOnOffError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffError >& error);
      virtual void onBluetoothOnOffStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffStatus >& status);

      virtual void onServiceAvailableError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableError >& error);
      virtual void onServiceAvailableStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableStatus >& status);

#endif

   private:
      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy;
      //	::boost::shared_ptr< MOST_BTSet_FIProxy > _most_btset_fi;

      /* Paired Device information of each paired device */
      /* Device support information of each paired device */
      DECLARE_CLASS_LOGGER();
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      bool m_bluetoothOnOffStatus;
      bool m_bServicestatusflag;
#endif

   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_PHONE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(AddNewDeviceReq)
      ON_COURIER_MESSAGE(SSPResponseReq)
      ON_COURIER_MESSAGE(DeviceListReq)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(DeleteDeviceConfirmationReq)
      ON_COURIER_MESSAGE(DisconnectDeviceConfirmationReq)
      ON_COURIER_MESSAGE(IntercomStatusMsg)
      ON_COURIER_MESSAGE(RenderingCompleteMsg)
      COURIER_MSG_MAP_END()

      /*to access ServiceBT functions and variable in other client handlers*/

      /* To get Passive device name and device handle */
      void GetPassivePhoneDetails(std::string& strDeviceName, tU8& u8DeviceHandle);

      static ServiceBT* poGetInstance()
      {
         if (NULL == _mBTHelper)
         {
            _mBTHelper = new ServiceBT();
         }
         return _mBTHelper;
      }

      /*setter function to set connected device handle*/
      void vSetConnectedDeviceHandle(tU8 tu8connectedDeviceHandle);

      /*getter function which returns connected device handle*/
      tU8 u8GetConnectedDeviceHandle();

      std::string szGetConnectedBTDeviceName()
      {
         return strConnectedBTDeviceName;
      }

      /*getter function which returns deviceIsConnected info*/
      //tBool bGetDeviceConnectedInfo(){ return bDeviceIsConnected; }

#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      tVoid vSetChangeRingtone(tU8 u8RingToneID);
#endif

      /*function to clear the device list database*/
      tVoid onClearDeviceInfo();
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      tVoid BTONOFFStart(bool bOnOFF);
      inline bool GetBluetoothOnOffStatus()
      {
         return m_bluetoothOnOffStatus;
      }
      bool GetServiceAvailableStatus()
      {
         return m_bServicestatusflag;
      }
#endif
   private:

      bool onCourierMessage(const DeviceListReq& corfoMsg);
      bool onCourierMessage(const AddNewDeviceReq& corfoMsg);
      bool onCourierMessage(const SSPResponseReq& corfoMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const DeleteDeviceConfirmationReq& oMsg);
      bool onCourierMessage(const DisconnectDeviceConfirmationReq& oMsg);
      bool onCourierMessage(const IntercomStatusMsg& oMsg);
      bool onCourierMessage(const RenderingCompleteMsg& oMsg);

      DeviceListModel& rfoDeviceListModel;
      PhoneCallModel& rfoPhoneCallModel;
      /* to store Number of devices in the paired device list*/
      tU8 m_u8DeviceListSize;
      /*to store device connected information*/
      //tBool bDeviceIsConnected;

      /* to store Status of device list*/
      btphn_tenDeviceListStatus enDeviceListStatus;

      /* Paired Device information of each paired device */
      //std::vector<btphn_trBTPairedDeviceInfo> m_arPairedDeviceInfo;
      //std::vector<tu8> m_arPairedDeviceHandleInfo;

      //std::map<tU8,btphn_trBTDeviceConnectionInfo> m_arConnectedDeviceInfo;

      /* Device support information of each paired device */
      std::vector<btphn_trBTDeviceSupportInfo> arDeviceSupportInfo;

      /*to store device handle for the device which is selected from paired device list for deletion*/
      tU8 u8DeleteDeviceHandle;

      /* Device handle of the connected device irrespective of the profile */
      tU8 m_u8ConnectedDeviceHandle;

      /*stores row value of device selected for unpairing/deletion */
      tU8 u8PairedDeviceListDeviceDleteIndex;
      tU8  u8DisconnectDeviceIndex;
      /*stores row value of device selected for bt connection */
      tU8 u8PairedDeviceSelectedListIndex;

      /* connection/deletion/unpairing/pairing request flag for device selected from device list*/
      //bool bChangeDeviceStateReq;

      /*stores device handle of device to be connected/selected when there is an existing device connected */
      tU8 u8SelectDeviceHandle;

      /*Flag used to find if add new device request is triggered when there is an already connected device*/
      tBool bAddDeviceAfterDisconnect;

      /*Flag used to find if deletion has been initiated*/
      tBool bDeviceDisconnectInitiated;

      tU8 m_u8MaxNumOfHFPConnected;

      tU8 m_u8ActiveDevHandle;
      tU8 m_u8PassiveDevHandle;
      tU8 m_u8AVPDevHandle;
      tU8 m_u8StoreHandleHFP;
      tU8	m_u8StoreHandleAVP;
      tU8 m_u8DisconnectedHandle;
      tU8 m_u8NumConnectedDevice;

      // 0 - initialization - No Device connected
      // 1 - First device connected on Boot up/restart (could be AVP or HFP)
      // 2 - Allow disconnection popup to be seen - do we show disconnect popup for AVP profile alone ?
      tU8 m_u8BTAppConnectionStates;

      /* Boolean flag to maintain the status of the pairing cancel request made by the user */
      //  bool m_bPairingCancelReqStatus;//commenting this code for the bug fix 887119

      // Added for supporting MCP hadnling in PhoneHall
      // set this flag to false only when both devices are disconnected
      // Even if one phone is connected, Maintain this flag as true
      bool bIsAnyOfPhoneConnected;

      bool bIsIntercomCallScene;

      /*sends add new device request for service*/
      void vSendAddNewDeviceStart();

      std::string strConnectedBTDeviceName;
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      uint8 u8Active_Source;
#endif
      //bool bIntercomNot_Supported
      /*device connection timer*/
      static bool bIsDeviceConnectionTimerRunning;
      OSAL_tTimerHandle hDeviceConnectionTimer; // DeviceConnection timer

      static void vOnDeviceConnectionTimerExpiry(tPVoid pvObject); // Callback function on Timer Expiry
      void vStopDeviceConnectionTimer(); // Stops DeviceConnection timer execution
      void vStartDeviceConnectionTimer();//starts DeviceConnection timer execution for 35000 ms
      /* Stop Connection Timers */
      void vStopConnectionTimers(const btphn_tenBTDeviceStatus& corfenDeviceStatus, std::string strDeviceName, tU8 u8ChangedDeviceHandle);
      tVoid vProfileChange(const tU8 m_u8DeviceListSize, const btphn_tenBTDeviceStatus l_u8DeviceStatus);

      tVoid vUpdateConnDeviceHandle(const tU8 u8DeviceHandle);
      /*sends change device methos start */
      tVoid vUpdateDeviceState(tU8& l_u8deviceindex, btphn_tenBTDeviceStateAction deviceState);

      /*sends change device state method start to service*/
      tVoid vSendChangeDeviceStateStart(btphn_tenBTDeviceStateAction enDeviceStateAction, tU8 u8DeviceHandle);

      /* Sends courier message with BT service error information to HMI */
      tVoid vSendServiceError(const btphn_tenBTServiceType& corfrServiceType,  btphn_tenServiceErrCode corfrErrCode);

      /*Device list implementation when device list posts button reaction msg upon user interaction*/
      tVoid vPairedDevListItemInfo(tU8 hdlRow, tU8 hdlCol);

      /*handles device connection from paired device list failure case*/
      tVoid vSendConnectionFailed();

      /*handles device deletion from paired device list failed case*/
      tVoid vSendDeletionFailed();

      tVoid vContactCallListItemInfo(tU8 hdlRow);

      //To start ConnectBTProfile method
      tVoid vSendConnectBtProfile(tU8 u8DeviceHandle);

      //To start AutoConnect method
      tVoid vSendAutoConnectStart();

      tVoid vDeviceConnectionupdate(const ::boost::shared_ptr< DeviceListExtendedStatus >& status, tU8);

      //tVoid vDeviceDisconnectUpdate(const ::boost::shared_ptr< DeviceListExtendedStatus >&status,tU8);
      void vPairedDeviceInfo(tU8, const ::boost::shared_ptr< DeviceListExtendedStatus >&);

      //Method used to populate the member map with Device list
      tVoid vDeviceListToMap(const ::boost::shared_ptr< DeviceListExtendedStatus >& status);

      //Method to update the changed status of a particular device
      tVoid vUpdateChangedStatus(btphn_tenBTDeviceStatus eDeviceStatus, std::string strChangedDeviceName, tU8 u8ChangedDeviceHandle, tU8 e8DeviceDisconnectedReason);

   public:
      //To get the No of Hfp devices connected
      inline tU8 GetNoOfHFPDevicesConnected()
      {
         return    m_u8MaxNumOfHFPConnected;
      }
      //To set the Active device handle
      tVoid vSetActiveDevice(tU8 u8DeviceHandle)
      {
         m_u8ActiveDevHandle = u8DeviceHandle;
      }
      //To get the active device handle
      tU8 u8GetActiveDevHandle()
      {
         return m_u8ActiveDevHandle;
      }
      //To set the passive device handle
      tVoid vSetPassiveDevice(tU8 u8DeviceHandle)
      {
         m_u8PassiveDevHandle = u8DeviceHandle;
      }
      //To set the secondary device handle
      tU8 u8GetSecondaryDevHandle()
      {
         return m_u8PassiveDevHandle;
      }
      //To update the device handle of the A2DP connected device
      tVoid vSetAVPDevice(tU8 u8DeviceHandle)
      {
         m_u8AVPDevHandle = u8DeviceHandle;
      }
      //To obtain the device handle of the A2DP connected device
      tU8 u8GetAVPDevHandle()
      {
         return m_u8AVPDevHandle;
      }

      //To obtain the device handle of the Devie connected Status
      bool getPhoneConnectivityStatus()
      {
         return bIsAnyOfPhoneConnected;
      }

      //To start ConnectBTProfile method
      tVoid vSendConnectBTProfile(tU8 u8DevHandle, ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType);
      //To start DisconnectBTProfile method
      tVoid vSendDisconnectBTProfile(tU8 u8DevHandle, ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType);
      //To initiate HFP Connection
      tVoid vProceedForHFPConnection(tU8 hdlRow);
      //To obtain the device handle of the Active HFP device
      tU8 u8GetDisconnectionDevHandle();
      //To initiate A2DP connection
      tVoid vProceedForAVPConnection(tU8 hdlRow);
      //To switch multiple HFP support on or off
      tVoid vSwitchMultiHFPSupport(tBool bMultiHFPSupport);
      //To Toggle the Active phone from homescreen
      tVoid vToggleActivePhone();
      //To refresh device list status on android auto session change
      tVoid vUpdateDevicelistStatusOnAndroidAutoSessionChange();
      // to check whether the specified device handle existing in the DeviceDisconnectedList or not
      bool bIsDeviceDisconnectionProcessed(tU8 arg_DeviceHandle);

      void vUpdateDeviceDisconnectionInfo(tU8 arg_DeviceHandle);
};


}//Namespace Core
}//NameSpace App
#endif
