/***************************************************************************
* Copyright(c) 2017-2020 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#include "hall_std_if.h"
#include "ServiceBT.h"
#include "most_BTSet_fi_types.h"
#include "most_BTSet_fi_types_Extended.h"
//#include "App/BTDataTypes.h"
#include "AppHmi_PhoneTypes.h"
#include "ServiceTel.h"
#include "../Core/VehicleSrvClient/VehicleSrvClient.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "IntercomClienthandler.h"
#include "PhoneGadgetModel.h"
#endif

//#include "tclMostBtsetFiIf.h"
//using namespace ::App::Core;
using namespace ::MOST_BTSet_FI;
using namespace ::most_BTSet_fi_types;
using namespace ::most_BTSet_fi_types_Extended;

namespace App {
namespace Core {

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_PHONE_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_FILE_PREFIX            App::Core::ServiceBT::
#include "trcGenProj/Header/ServiceBT.cpp.trc.h"
#endif

//Add include files here

/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
ServiceBT* ServiceBT::_mBTHelper = NULL;
bool ServiceBT::bIsDeviceConnectionTimerRunning = false;
//ServiceBT::ServiceBT(/*tclMostBtsetFiIf *pIfClass*/::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy) :
ServiceBT::ServiceBT() :
   _btSetProxy(::MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("btSetFiPort", *this)),
   rfoDeviceListModel(*DeviceListModel::poGetInstance()),
   rfoPhoneCallModel(*PhoneCallModel::poGetInstance()),
   m_u8DeviceListSize(0),
   enDeviceListStatus(BTPHN_EN_DEVICE_LIST_INVALID),
   m_u8ConnectedDeviceHandle(0),
   u8DeleteDeviceHandle(0),
   u8SelectDeviceHandle(0),
   m_u8DisconnectedHandle(0),
   u8PairedDeviceListDeviceDleteIndex(BTPHN_C_HEXA_ZERO),
   u8DisconnectDeviceIndex(BTPHN_C_HEXA_ZERO),
   u8PairedDeviceSelectedListIndex(BTPHN_C_HEXA_ZERO),
   strConnectedBTDeviceName(""),
   m_u8BTAppConnectionStates(0),
   bIsAnyOfPhoneConnected(false),
//bDeviceIsConnected(FALSE),
   bAddDeviceAfterDisconnect(false),
   // bChangeDeviceStateReq(false), //this variable is made a SM extern variable
   m_u8MaxNumOfHFPConnected(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8AVPDevHandle(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8ActiveDevHandle(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8StoreHandleAVP(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8StoreHandleHFP(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8PassiveDevHandle(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8NumConnectedDevice(BTPHN_C_DEFAULT_VALUE_ZERO),
   m_u8ActivePhoneDevice(BTPHN_C_DEFAULT_VALUE_ZERO),
   bDeviceDisconnectInitiated(false),
   //m_bPairingCancelReqStatus(false),//commenting this code for the bug fix 887119
   m_bIsDisconnectflag(false)
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
   , m_bluetoothOnOffStatus(false)
   , m_bServicestatusflag(false)
#endif
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   , u8Active_Source(PHONEONE)
#endif
   , bIsIntercomCallScene(false)
{
   if (_btSetProxy.get())
   {
      ETG_TRACE_USR2(("ServiceBT _btSetProxy.get is TRUE"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _btSetProxy->getPortName());
   }
   else
   {
      ETG_TRACE_FATAL(("ServiceBT _btSetProxy.get is FALSE"));
   }

   hDeviceConnectionTimer = OSAL_NULL;
   if (OSAL_s32TimerCreate(vOnDeviceConnectionTimerExpiry, this, &hDeviceConnectionTimer) == OSAL_ERROR)
   {
      ETG_TRACE_FATAL(("ServiceBT : device connection timer failed"));
   }
   m_arDeviceListInfo.clear();
   m_vecDisconnectDeviceList.clear();
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
ServiceBT::~ServiceBT()
{
   m_vecDisconnectDeviceList.clear();
}


void ServiceBT::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


void ServiceBT::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
}


/*****************************************************************************
* onAvailable: Register for properties once service is available
*****************************************************************************/
void ServiceBT::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("ServiceBT onAvailable(_btSetProxy)"));
   if ((proxy == _btSetProxy) && (_btSetProxy.get()))
   {
      _btSetProxy->sendPairingStatusUpReg(*this);
      _btSetProxy->sendPairingPinUpReg(*this);
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      _btSetProxy->sendChangeRingtoneUpReg(*this);
#endif
      _btSetProxy->sendVehicleBTFriendlyNameUpReg(*this);
      _btSetProxy->sendDeviceListExtendedUpReg(*this);
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      _btSetProxy->sendBluetoothOnOffUpReg(*this);
      _btSetProxy->sendServiceAvailableUpReg(*this);
#endif
   }
   else
   {
      if (proxy != _btSetProxy)
      {
         ETG_TRACE_FATAL(("ServiceBT registerProperties(_btSetProxy != proxy)"));
      }
   }
   //Switch for Single HFP or Dual HFP
   vSwitchMultiHFPSupport(true);
}


/*****************************************************************************
* onUnavailable: De-register for properties once service is unavailable
*****************************************************************************/
void ServiceBT::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("ServiceBT onUnavailable(_btSetProxy)"));
   //Add your code here
   if (proxy == _btSetProxy && (_btSetProxy.get()))
   {
      ETG_TRACE_FATAL(("ServiceBT deregisterProperties(_btSetProxy)"));
      _btSetProxy->sendPairingStatusRelUpRegAll();
      _btSetProxy->sendPairingPinRelUpRegAll();
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
      _btSetProxy->sendChangeRingtoneRelUpRegAll();
#endif
      _btSetProxy->sendVehicleBTFriendlyNameRelUpRegAll();
      _btSetProxy->sendDeviceListExtendedRelUpRegAll();
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      _btSetProxy->sendBluetoothOnOffRelUpRegAll();
      _btSetProxy->sendServiceAvailableRelUpRegAll();
#endif
   }
}


/*******************************Implementation of Manual code*****************************************/

/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void ServiceBT::onAddNewDeviceError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::AddNewDeviceError >& error)
{
   ETG_TRACE_FATAL(("onAddNewDeviceError"));
   bChangeDeviceStateReq = FALSE;
   ETG_TRACE_USR4(("onAddNewDeviceError:DeviceStateReqFlag : %d", bChangeDeviceStateReq));
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
*18.09.2017: vke6kor
*Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onAddNewDeviceResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::AddNewDeviceResult >& result)
{
   /*check if valid value is received from service*/
   ETG_TRACE_USR2(("AddNewDeviceResult"));
   ETG_TRACE_USR2(("AddNewDeviceResult getSDeviceName = %s", result->getSDeviceName().c_str()));
   ETG_TRACE_USR2(("AddNewDeviceResult getSPinNumber = %s", result->getSPinNumber().c_str()));
   ETG_TRACE_USR2(("AddNewDeviceResult : PairingType: %d", ETG_CENUM(btphn_tenBTPairingType, (btphn_tenBTPairingType)result->getE8PairingType())));
   bChangeDeviceStateReq = FALSE;
   ETG_TRACE_USR4(("onAddNewDeviceResult:DeviceStateReqFlag : %d", bChangeDeviceStateReq));

   std::string Device_name = result->getSDeviceName();
   std::string Pin_Number = result->getSPinNumber();
   btphn_tenBTPairingType e8PairingType = static_cast <btphn_tenBTPairingType>(result->getE8PairingType())/*T_e8_BTSetPairingType__e8PAIRING_TYPE_CHANGE_PIN*/;
   //e8PairingType = result->getE8PairingType();
   if (std::strcmp("", Device_name.c_str()) == 0 || std::strcmp("", Device_name.c_str()) == 0)
   {
      return;
   }
   rfoDeviceListModel.OnUpdNewDeviceInfoResult(Device_name, Pin_Number, (btphn_tenBTPairingType)e8PairingType);
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void ServiceBT::onPairingResponseError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingResponseError >& error)
{
   bChangeDeviceStateReq = FALSE;
   ETG_TRACE_USR4(("onPairingResponseError:DeviceStateReqFlag : %d", bChangeDeviceStateReq));
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
*18.09.2017: vke6kor
*Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onPairingResponseResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingResponseResult >& result)
{
   bChangeDeviceStateReq = FALSE;
   IsParingActive = 0;
   ETG_TRACE_USR4(("ServiceBT : onPairingResponseResult"));
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void ServiceBT::onChangeDeviceStateError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeDeviceStateError >& error)
{
   /*most fi basetype enum to store changedevice state error code */
   fi_basetypes_most::T_e8_ErrorCode enErrorCode;
   ETG_TRACE_USR4(("ServiceBT : onChangeDeviceStateError()"));
   bChangeDeviceStateReq = FALSE; //resetting devicestate flag for subsequent connection/disconnection request

   ETG_TRACE_USR4(("onChangeDeviceStateError : DeviceStateReqFlag : %d", bChangeDeviceStateReq));
   /*getCcaErrorCode returns a object of type ChangeDeviceStateErrorStructure. getE8ErrorCode returns enum of type T_e8_ErrorCode */
   enErrorCode = ((error->getCcaErrorCode()).getE8ErrorCode());
   if (enErrorCode == 0)
   {
      return;
   }
   /* Sending the error information for updating controller */
   vSendServiceError(BTPHN_EN_BT_CHANGEDEVICESTATE, (btphn_tenServiceErrCode)enErrorCode);
}


/*****************************************************************************
* @brief   Clear DeviceInfo Result
*04.07.2019: ebg1kor
*Rev 0.1: Initial Version
*SYSFL- 529,SWFL-2684: Factory Reset_Phone
*****************************************************************************/
void ServiceBT::onClearDeviceInfoResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr<ClearDeviceInfoResult>& result)
{
   ETG_TRACE_USR2(("ServiceBT: onClearDeviceInfoResult"));
}


/*****************************************************************************
* @brief  Clear DeviceInfo Error
*04.07.2019: ebg1kor
*Rev 0.1: Initial Version
*SYSFL- 529,SWFL-2684: Factory Reset_Phone
*****************************************************************************/
void ServiceBT::onClearDeviceInfoError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr<ClearDeviceInfoError>& error)
{
   ETG_TRACE_USR2(("ServiceBT :onClearDeviceInfoError"));
}


/*****************************************************************************
* @brief   : This function  Receives the MethodResult message from BT service
*               for ChangeDeviceState. If change device state result is received for successful device connection,
*				i.e, connection result as select, the there is successfull device connection.
*			When ever there is change in device status of any device on the paired device list then, device lists status update is received from service
*
* @param[in] - proxy - shared pointer for client side representation of a service,
*				result - gives if requested device state is connected/disconnected
* @param[out]- void
initial rev:Shwetha K
*****************************************************************************/
void ServiceBT::onChangeDeviceStateResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
      const boost::shared_ptr< ::MOST_BTSet_FI::ChangeDeviceStateResult >& result)
{
   ETG_TRACE_USR4(("ServiceBT : onChangeDeviceStateResult()"));
   bChangeDeviceStateReq = FALSE; //resetting devicestate flag for subsequent connection/disconnection request
   ETG_TRACE_USR4(("onChangeDeviceStateResult :DeviceStateReqFlag : %d", bChangeDeviceStateReq));
   T_e8_BTSetConnectionResult enConnectionResult = result->getE8ConnectionResult();
   ETG_TRACE_USR2(("ChangeDeviceStateResult : enConnectionResult = %d , u8DeleteDeviceHandle = %d , u8SelectDeviceHandle = %d",
                   ETG_CENUM(btphn_tenBTConnectionResult, enConnectionResult), u8DeleteDeviceHandle, u8SelectDeviceHandle));
   if (T_e8_BTSetConnectionResult__e8DEVICE_CONNECTED == enConnectionResult)
   {
      ETG_TRACE_USR2(("ChangeDeviceStateResult : Connection Result Is DEVICE CONNECTED"));
   }
   else if (T_e8_BTSetConnectionResult__e8DEVICE_DISCONNECTED == enConnectionResult)
   {
      /*if device with u8DeleteDeviceHandle is disconnected, send changedevicestate request for deleting the device from device list*/
      if ((BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= u8DeleteDeviceHandle))
      {
         ETG_TRACE_USR2(("ChangeDeviceStateResult :  send Device Delete"));
         vSendChangeDeviceStateStart(BTPHN_EN_DELETE, u8DeleteDeviceHandle);
      }
      /*if already connected device is disconnected and we should proceed for fresh connection for u8SelectDeviceHandle(new device handle) - connection trigger from device list when already a device is connected */
      else if ((BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= u8SelectDeviceHandle))
      {
         ETG_TRACE_USR2(("ChangeDeviceStateResult : Device Disconnected, connect new device"));
         vSendChangeDeviceStateStart(BTPHN_EN_SELECT, u8SelectDeviceHandle);
         u8SelectDeviceHandle = 0;
      }
      /*if already connected device is disconnected and we should proceed for new pairing - connection trigger from add new device press when already a device is connected */
      else if ((bAddDeviceAfterDisconnect == true))
      {
         ETG_TRACE_USR2(("onChangeDeviceStateResult : Connected Device disconnected, proceeed for pairing initiate"));
         ETG_TRACE_USR2(("onChangeDeviceStateResult : bChangeDeviceStateReq = %d", bChangeDeviceStateReq));
         //for closing device disconnected pop up
         POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceDisConnected"))));
         //send method start for fresh pairing once already connected device is disconnected
         ServicePhoneBook::poGetInstance()->vDeleteCallList();
         vSendAddNewDeviceStart();
         bAddDeviceAfterDisconnect = false;
      }
   }

   /*check for device block status*/
   else if (T_e8_BTSetConnectionResult__e8DEVICE_BLOCKED == enConnectionResult)
   {
      ETG_TRACE_USR2(("ChangeDeviceStateResult : Connection Result Is BLOCKED"));
   }
   /*else device is not connected the call connection failed method */
   else
   {
      if (T_e8_BTSetConnectionResult__e8DEVICE_NOT_CONNECTED == enConnectionResult)
      {
         /*on unsuccessful device connection show device connection failed pop up */
         vSendConnectionFailed();
      }
      /*to reset device state flag and to send service error update to controller*/
      vSendDeletionFailed();
      //dont reset bAddDeviceAfterDisconnect when its deletion failed;
   }
}


/*****************************************************************************
* @brief: This function is called upon receiving change device state result when device is not yet connected.
* This function resets the connection tiner. Its connection failed function call
*If IsDeviceConnectingActive then courier msg is sent to controller to hide Pfo_DeviceConnecting and Pfo_DeleteDeviceConfirmation pop ups
* @param[in] - void
* @param[out]- void
* initial rev:Shwetha K
*****************************************************************************/
void ServiceBT::vSendConnectionFailed()
{
   ETG_TRACE_USR4(("ServiceBT : vSendConnectionFailed()"));
   /*resetting device connection timer and flag*/
   bIsDeviceConnectionTimerRunning = false;
   u8SelectDeviceHandle = 0;

   if (OSAL_NULL != hDeviceConnectionTimer)
   {
      OSAL_s32TimerSetTime(hDeviceConnectionTimer,
                           BTPHN_C_DEFAULT_VALUE_ZERO,
                           BTPHN_C_DEFAULT_VALUE_ZERO);
   }
   IsDeviceListOperationProgress = BTPHN_C_VALUE_ZERO;
   /*to hide device connecting pop up and to show connection failed popup upon unsuccessful device connections*/
   if (BTPHN_C_VALUE_ONE == IsDeviceConnectingActive)
   {
      POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceConnecting"))));
      POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_ConnectionFailed"))));

      IsDeviceConnectingActive = BTPHN_C_VALUE_ZERO;
   }
   ETG_TRACE_USR4(("Device Connection Failed"));
   ///*resetting device connection timer and flag */
   //bIsDeviceConnectionTimerRunning = FALSE;
   //if (OSAL_NULL != hDeviceConnectionTimer)
   //{
   //	OSAL_s32TimerSetTime(hDeviceConnectionTimer,
   //		BTPHN_C_DEFAULT_VALUE_ZERO,
   //		BTPHN_C_DEFAULT_VALUE_ZERO);
   //}
}


/*****************************************************************************
* @brief: This function is called delettion of requested delete device handle is failed
* This function resets u8DeleteDeviceHandle to 0 and sends service error to controller
*
* @param[in] - void
* @param[out]- void
* initial rev:Shwetha K
*****************************************************************************/
void ServiceBT::vSendDeletionFailed()
{
   ETG_TRACE_USR4(("ServiceBT : vSendDeletionFailed()\t"));

   if (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= u8DeleteDeviceHandle)
   {
      /*reset delete device handle*/
      u8DeleteDeviceHandle = BTPHN_C_DEFAULT_VALUE_ZERO;
      vSendServiceError(BTPHN_EN_BT_CHANGEDEVICESTATE, BTPHN_EN_ERRCODE_NOERROR);
   }
   else
   {
      ETG_TRACE_USR4(("Deletion is not requested from HMI"));
   }
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
*18.09.2017: vke6kor
*Rev 0.1: Initial Version
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
void ServiceBT::onRequestAvailableRingtonesListError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
      const boost::shared_ptr< ::MOST_BTSet_FI::RequestAvailableRingtonesListError >& error)
{
   ETG_TRACE_USR2(("ServiceBT::onRequestAvailableRingtonesListError"));
   //Add your code here
}


/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void ServiceBT::onRequestAvailableRingtonesListResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy,
      const boost::shared_ptr< ::MOST_BTSet_FI::RequestAvailableRingtonesListResult >& result)
{
}


#endif

/*****************************************************************************
* @brief   Add Function details here
*****************************************************************************/
void ServiceBT::onPairingStatusError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingStatusError >& error)
{
}


/*****************************************************************************
* @brief  On Confirmation of PIN from the phone
*31.05.2019: ebg1kor
*Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onPairingStatusStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingStatusStatus >& status)
{
   ETG_TRACE_USR2(("onPairingStatusStatus"));
   if (status->getU8DeviceHandle() == 0)
   {
      return;
   }
   btphn_tenBTPairingStatus enPairingStatus = static_cast <btphn_tenBTPairingStatus>(status->getE8PairingStatusType());
   ETG_TRACE_USR2(("Pairing Status = %d", enPairingStatus));
   if (BTPHN_EN_PAIRING_STATUS_IDLE != enPairingStatus)
   {
      /* While getting the pairing status of cancelled on user cancel request, don't send pairing status and in all other cases post the message
      //commenting this code for the bug fix 887119
      if ((enPairingStatus == BTPHN_EN_PAIRING_STATUS_CANCELLED) && (m_bPairingCancelReqStatus == true))
      {
         Clear the flag on receiving cancelled status
         m_bPairingCancelReqStatus = false;
      }
      else
      { */
      POST_MSG((COURIER_MESSAGE_NEW(PairingStatusResp)(enPairingStatus)));
      // }

      if (BTPHN_EN_PAIRING_STATUS_SUCCESSFUL == enPairingStatus)
      {
         if (FALSE == bIsDeviceConnectionTimerRunning)
         {
            vStartDeviceConnectionTimer();
            //if (OSAL_NULL != hDeviceConnectionTimer)
            //{
            //	ETG_TRACE_USR4(("DeviceConnection Timer is started"));
            //	OSAL_s32TimerSetTime(
            //		hDeviceConnectionTimer, // Timer handle
            //		BTPHN_C_DEVICE_CONNECTION_TIMER_DURATION, // Timer expiry duration
            //		BTPHN_C_DEFAULT_VALUE_ZERO // Timer repeat value
            //		);
            //	bIsDeviceConnectionTimerRunning = TRUE;
            //	ETG_TRACE_USR4(("bIsDeviceConnectionTimerRunning Set to TRUE"));
            //}
         }
      }
      else if (BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL == enPairingStatus)
      {
         ETG_TRACE_USR2(("onPairingStatusStatus = BTPHN_EN_PAIRING_STATUS_UNSUCCESSFUL"));
         IsParingActive = 0;
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR2(("onPairingStatusStatus updateBTLinkStatus is BT_STATUS_NOT_CONNECTED"));
            VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_NOT_CONNECTED); //CAN Imp
         }
      }
      else if ((enPairingStatus == BTPHN_EN_PAIRING_STATUS_CANCELLED) || (enPairingStatus == BTPHN_EN_PAIRING_STATUS_CONNECTIONLOST) ||
               (enPairingStatus == BTPHN_EN_PAIRING_STATUS_TIMEOUT) || (enPairingStatus == BTPHN_EN_PAIRING_STATUS_AUTHENTICATIONFAILURE))
      {
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            ETG_TRACE_USR2(("onPairingStatusStatus updateBTLinkStatus is BT_STATUS_NOT_CONNECTED"));
            VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_NOT_CONNECTED); //CAN Imp
         }
      }
      // vSendAutoConnectStart(); // To fix the bug 509060
   }
}


/***************************************************************************
* AutoConnectSequence method error
* Function name : onStartAutoConnectSequenceError
* parma[in]- MOST_BTSet_FIProxy,StartAutoConnectSequenceError
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onStartAutoConnectSequenceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceError >& error)
{
   ETG_TRACE_USR2(("ServiceBT::onStartAutoConnectSequenceError"));
}


/***************************************************************************
* AutoConnectSequence method Result
* Function name : onStartAutoConnectSequenceResult
* parma[in]- MOST_BTSet_FIProxy,StartAutoConnectSequenceResult
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onStartAutoConnectSequenceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceResult >& result)
{
   ETG_TRACE_USR2(("ServiceBT::onStartAutoConnectSequenceResult"));
}


/***************************************************************************
* DeviceListExtended Error
* Function name : onDeviceListExtendedError
* parma[in]- MOST_BTSet_FIProxy,DeviceListExtendedError
* param[out]- void
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
void ServiceBT::onDeviceListExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedError >& error)
{
   ETG_TRACE_USR2(("ServiceBT::onDeviceListExtendedError"));
}


/***************************************************************************
* vDeviceListToMap
* Function name : vDeviceListToMap
* parma[in]- ::boost::shared_ptr< DeviceListExtendedStatus >
* param[out]- void
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
* update to the model incase of device no change
* v 0.2 rev: Sai Prabha Changes:Bug 280289
****************************************************************************/
tVoid ServiceBT::vDeviceListToMap(const ::boost::shared_ptr< DeviceListExtendedStatus >& status)
{
   if (m_u8DeviceListSize != 0)
   {
      m_arDeviceListInfo.clear();
      for (uint8 i = 0; i < m_u8DeviceListSize; i++)
      {
         tU8 l_u8DeviceHandle = status->getODeviceListExtendedResult()[i].getU8DeviceHandle();
         DeviceListInformation obj;
         obj.SetDeviceHandle(status->getODeviceListExtendedResult()[i].getU8DeviceHandle());
         obj.SetDeviceName(status->getODeviceListExtendedResult()[i].getSDeviceName().c_str());
         obj.SetConnectingStatus(status->getODeviceListExtendedResult()[i].getE8DeviceConnectionStatus());
         obj.SetDeviceConnectedStatus(status->getODeviceListExtendedResult()[i].getBDeviceConnectedStatus());
         obj.SetHFPStatus(status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8HFP());
         obj.SetAVPStatus(status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8AVP());
         obj.SetOSDStatus(status->getODeviceListExtendedResult()[i].getBOutgoingSourceDeviceStatus());
         /*obj.SetDeviceBtAddress(status->getODeviceListExtendedResult()[i].getSDeviceAddress().c_str());*/
         m_arDeviceListInfo.push_back(obj) ;

         // At start up add all disconnected device to disconnected device list, this way, we wont show disconnect popup for
         // all the disconnected devices in the device list at start up (though middleware updates as DISCONNECTED- CONNECT FAILED)
         // this is ONE TIME at the boot up, "m_u8BTAppConnectionStates == 0"
         if (0 == m_u8BTAppConnectionStates)
         {
            ETG_TRACE_USR4(("ServiceBT::vDeviceListToMap - First Update - device handle : %d DeviceConnectedStatus : %d ", obj.GetDeviceHandle(), obj.GetDeviceConnectedStatus()));
            if (obj.GetDeviceConnectedStatus() == false)
            {
               ETG_TRACE_USR4(("ServiceBT::vDeviceListToMap - device handle : %d  belongs to part of diconnected devices. Hence adding to disconnected devices list.", obj.GetDeviceHandle()));
               if (std::find(m_vecDisconnectDeviceList.begin(), m_vecDisconnectDeviceList.end(), obj.GetDeviceHandle()) == m_vecDisconnectDeviceList.end())
               {
                  // insert only unique device handles
                  m_vecDisconnectDeviceList.push_back(obj.GetDeviceHandle());
               }
            }
            else
            {
               ETG_TRACE_USR4(("ServiceBT::vDeviceListToMap - device handle : %d belongs to part of Connected devices. Hence not added to disconnected devices list.", obj.GetDeviceHandle()));
            }
         }
      }
   }
}


void ServiceBT::vUpdateDeviceDisconnectionInfo(tU8 arg_DeviceHandle)
{
   ETG_TRACE_USR4(("ServiceBT::vUpdateDeviceDisconnectionInfo deviceHandle = : %d", arg_DeviceHandle));

   if (!m_vecDisconnectDeviceList.empty())
   {
      for (uint8 i = 0; i < m_vecDisconnectDeviceList.size(); ++i)
      {
         if (arg_DeviceHandle == m_vecDisconnectDeviceList[i])
         {
            ETG_TRACE_USR4(("ServiceBT::vUpdateDeviceDisconnectionInfo deviceHandle = : %d entry found in device disconnection list.", m_vecDisconnectDeviceList[i]));
            // device got reconnected within same power cycle hence, removing the entry to treat the next disconnection as fresh entry.
            m_vecDisconnectDeviceList.erase(m_vecDisconnectDeviceList.begin() + i);
            ETG_TRACE_USR4(("ServiceBT::vUpdateDeviceDisconnectionInfo deviceHandle = : %d entry Erased from device disconnection list as device got connected.", arg_DeviceHandle));
            break;
         }
      }
   }
}


bool ServiceBT::bIsDeviceDisconnectionProcessed(tU8 arg_DeviceHandle)
{
   ETG_TRACE_USR4(("ServiceBT::bIsDeviceDisconnectionProcessed deviceHandle = : %d", arg_DeviceHandle));
   bool bDisconnectedPopupAlreadydisplayed = false;

   if (!m_vecDisconnectDeviceList.empty())
   {
      for (uint8 i = 0; i < m_vecDisconnectDeviceList.size(); i++)
      {
         if (arg_DeviceHandle == m_vecDisconnectDeviceList[i])
         {
            ETG_TRACE_USR4(("ServiceBT::bIsDeviceDisconnectionProcessed deviceHandle = : %d entry found in device disconnection list.", arg_DeviceHandle));
            bDisconnectedPopupAlreadydisplayed = true;
            break;
         }
      }
   }

   return bDisconnectedPopupAlreadydisplayed;
}


/***************************************************************************
* vUpdateChangedStatus
* Function name : vUpdateChangedStatus
* parma[in]- btphn_tenBTDeviceStatus,string,tU8
* param[out]- void
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vUpdateChangedStatus(btphn_tenBTDeviceStatus eDeviceStatus, std::string strChangedDeviceName, tU8 u8ChangedDeviceHandle, tU8 e8DeviceDisconnectedReason)
{
   ETG_TRACE_USR4(("Switch case: Device Status = : %d", (tU8)eDeviceStatus));

   if ((m_u8BTAppConnectionStates == 0)
         && ((eDeviceStatus == BTPHN_EN_DEVICE_CONNECTED) || (eDeviceStatus == BTPHN_EN_DEVICE_CONNECTED_OSD))
      )
   {
      ETG_TRACE_USR4(("First BT device connect after bootup - BTPHN_EN_DEVICE_CONNECTED"));
      m_u8BTAppConnectionStates = 1;
   }

   switch (eDeviceStatus)
   {
      case BTPHN_EN_DEVICE_CONNECTED :
         ETG_TRACE_USR4(("BTPHN_EN_DEVICE_CONNECTED"));
         ETG_TRACE_USR4(("m_u8MaxNumOfHFPConnected:%d", m_u8MaxNumOfHFPConnected));
         ETG_TRACE_USR4(("m_u8NumConnectedDevice:%d", m_u8NumConnectedDevice));
         rfoDeviceListModel.OnUpdDeviceConnected(eDeviceStatus, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice);
         vStopConnectionTimers(eDeviceStatus, strChangedDeviceName,  u8ChangedDeviceHandle);//commented
         bIsAnyOfPhoneConnected = true;

         if (m_u8NumConnectedDevice > 0)
         {
            if (m_u8MaxNumOfHFPConnected > 0)
            {
               //PhoneSettings: when hfp connections are available,enable the phone setting
               ETG_TRACE_USR4(("OnUpdDeviceConnected::hfp device connected"));

               rfoDeviceListModel.vEnablePhoneSettings(); // Enable Phone Settings when a phone with Hfp profile is connected
            }

            // checks even if the same device was previosuly connected only as AVP and got disconnected.
            vUpdateDeviceDisconnectionInfo(u8ChangedDeviceHandle);
         }
         break;

      case BTPHN_EN_DEVICE_CONNECTED_OSD :
         ETG_TRACE_USR4(("BTPHN_EN_DEVICE_CONNECTED_OSD"));
         ETG_TRACE_USR4(("m_u8MaxNumOfHFPConnected:%d", m_u8MaxNumOfHFPConnected));
         ETG_TRACE_USR4(("m_u8NumConnectedDevice:%d", m_u8NumConnectedDevice));
         rfoDeviceListModel.OnUpdDeviceConnected(eDeviceStatus, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice);
         vStopConnectionTimers(eDeviceStatus, strChangedDeviceName,  u8ChangedDeviceHandle);
         bIsAnyOfPhoneConnected = true;
         if (m_u8NumConnectedDevice > 0)
         {
            if (m_u8MaxNumOfHFPConnected > 0)
            {
               //PhoneSettings: when hfp connections are available,enable the phone setting
               ETG_TRACE_USR4(("OnUpdDeviceConnected::hfp device connected"));

               rfoDeviceListModel.vEnablePhoneSettings(); // Enable Phone Settings when a phone with Hfp profile is connected
            }
            // checks even if the same device was previosuly connected only as AVP and got disconnected.
            vUpdateDeviceDisconnectionInfo(u8ChangedDeviceHandle);
         }
         break;

      case BTPHN_EN_DEVICE_DISCONNECTED :
         m_arConnectedDeviceProfileInfo.erase(u8ChangedDeviceHandle);
         ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.erase(u8ChangedDeviceHandle);
         ServicePhoneBook::poGetInstance()->bPhonebookContactSupport = false;
         rfoDeviceListModel.OnUpdDeviceConnected(eDeviceStatus, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice);

         if (BTPHN_C_DEFAULT_VALUE_ZERO == m_u8NumConnectedDevice)
         {
            ETG_TRACE_USR4(("Setting bIsAnyOfPhoneConnected to false as m_u8NumConnectedDevice is ZERO"));
            bIsAnyOfPhoneConnected = false;
         }
         if (BTPHN_C_DEFAULT_VALUE_ZERO == m_u8MaxNumOfHFPConnected)
         {
            ServiceTel::poGetInstance()->vDisableBTVRView(); // BT_VR should be actually disabled in this condition
         }
         if (m_u8DisconnectedHandle == u8ChangedDeviceHandle)
         {
            ETG_TRACE_USR4(("device disconnected"));
            // POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceDisConnected")))); //add

            if (!bIsDeviceDisconnectionProcessed(u8ChangedDeviceHandle))
            {
               ETG_TRACE_USR4(("device disconnected - For the first time"));
               POST_MSG((COURIER_MESSAGE_NEW(DeviceStatusResp)(BTPHN_EN_DEVICE_DISCONNECTED)));

               if (std::find(m_vecDisconnectDeviceList.begin(), m_vecDisconnectDeviceList.end(), u8ChangedDeviceHandle) == m_vecDisconnectDeviceList.end())
               {
                  // insert only unique device handles
                  m_vecDisconnectDeviceList.push_back(u8ChangedDeviceHandle);
               }
            }
            else
            {
               ETG_TRACE_USR4(("device disconnected - Already processed"));
            }

            m_u8DisconnectedHandle = 0;
            if (BTPHN_C_DEFAULT_VALUE_ZERO == m_u8MaxNumOfHFPConnected)
            {
               if (false == bIsIntercomCallScene)
               {
                  ETG_TRACE_USR4(("Active scene is intercom call scene, do not navigate to phone selection scene"));
                  POST_MSG((COURIER_MESSAGE_NEW(ActivateAddDeviceMsg)())); // stays in contact list //Bug 453657
               }
               //GenCan Value Clearing once Phone is disconnected from the target
               VehicleSrvClient::poGetInstance()->vInitGenericCanInterfaces();
            }
         }
         if (u8ChangedDeviceHandle != ServiceTel::poGetInstance()->u8GetActiveDev())
         {
            ETG_TRACE_USR4(("vUpdateChangedStatus::Deleting lists on Disconnection of phone"));
            ETG_TRACE_USR4(("vUpdateChangedStatus::Device Disconnected Reason e8DeviceDisconnectedReason:%d", e8DeviceDisconnectedReason));
            if (e8DeviceDisconnectedReason != 5)
            {
               ETG_TRACE_USR4(("vUpdateChangedStatus::Device Disconnected Reason is not Intermediate hence deleting the Call list and contacts"));
               ServicePhoneBook::poGetInstance()->vDeleteCallList();
               ServicePhoneBook::poGetInstance()->vDeleteContactList();
               // Request for current Active phone's Call and contact list
               POST_MSG((COURIER_MESSAGE_NEW(CallListReq)()));
               POST_MSG((COURIER_MESSAGE_NEW(ContactListReq)()));
            }
         }
         if (bDeviceDisconnectInitiated)
         {
            bDeviceDisconnectInitiated = false;
         }
         if ((BTPHN_EN_DEVICE_DISCONNECTED == eDeviceStatus) && (NULL != _btSetProxy))
         {
            POST_MSG((COURIER_MESSAGE_NEW(ClearEditFieldResp)()));
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
            _btSetProxy->sendRequestDeviceRingtoneListStart(*this, false);
#endif
         }

         break;

      case BTPHN_EN_DEVICE_DELETED:

         POST_MSG((COURIER_MESSAGE_NEW(ClearEditFieldResp)()));
         ETG_TRACE_USR4(("above if in deleted"));
         bDeviceDisconnectInitiated = false;
         m_arConnectedDeviceProfileInfo.erase(u8ChangedDeviceHandle);
         ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.erase(u8ChangedDeviceHandle);

         break;

      case most_BTSet_fi_types::T_e8_BTSetDeviceStatus__e8DEVICE_NO_CHANGE :

         ETG_TRACE_USR4(("NO Change"));
         vProfileChange(m_u8DeviceListSize, BTPHN_EN_DEVICE_NO_CHANGE);
         if (m_u8MaxNumOfHFPConnected == 0)
         {
            //PhoneSettings: when no hfp phones are connected
            ETG_TRACE_USR4(("OnUpdDeviceConnected::IsDeviceConnected %d", IsDeviceConnected));
            rfoDeviceListModel.vDisablePhoneSettings();
         }
         break;

      default:
         break;
   }
}


/***************************************************************************
* DeviceListExtendedStatus
* Function name : onDeviceListExtendedStatus
* parma[in]- MOST_BTSet_FIProxy, DeviceListExtendedStatus
* param[out]- void
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
* update to the model incase of device no change
* v 0.2 rev: Sai Prabha
* v 0.3 rev: Sai Prabha Change details: Bug 280289
****************************************************************************/
void ServiceBT::onDeviceListExtendedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedStatus >& status)
{
   m_u8DeviceListSize = status->getU8NumPairedDevices();
   ETG_TRACE_USR4(("m_u8DeviceListSize = %d", m_u8DeviceListSize));

   vDeviceListToMap(status);

   m_u8NumConnectedDevice = 0;

   if (m_u8DeviceListSize > 0)
   {
      ETG_TRACE_USR2(("ServiceBT::onDeviceListExtendedStatus"));
      tU8 l_u8ChangedDeviceHandle = status->getODeviceListChange().getU8DeviceHandle();
      tU8 l_e8DeviceDisconnectedReason = status->getODeviceListChange().getE8DeviceDisconnectedReason();
      ETG_TRACE_USR2(("onDeviceListExtendedStatus::l_u8ChangedDeviceHandle %d ", l_u8ChangedDeviceHandle));
      std::string strChangedDeviceName;
      for (tU8 i = 0; i < m_u8DeviceListSize; i++)
      {
         if (l_u8ChangedDeviceHandle == m_arDeviceListInfo[i].GetDeviceHandle())
         {
            strChangedDeviceName = m_arDeviceListInfo[i].GetDeviceName().c_str();
         }
      }

      vPairedDeviceInfo(m_u8DeviceListSize, status);
      btphn_tenBTDeviceStatus eDeviceStatus = (btphn_tenBTDeviceStatus)status->getODeviceListChange().getE8DeviceStatus();
      vUpdateChangedStatus(eDeviceStatus, strChangedDeviceName, l_u8ChangedDeviceHandle, l_e8DeviceDisconnectedReason);
      vProfileChange(m_u8DeviceListSize, eDeviceStatus);
      if (VehicleSrvClient::poGetInstance() != NULL)
      {
         if (m_u8NumConnectedDevice > 0)
         {
            ETG_TRACE_USR4(("ServiceBT::onDeviceListExtendedStatus: set BT_STATUS_CONNECTED"));
            VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_CONNECTED); //CAN Imp
         }
         else
         {
            ETG_TRACE_USR4(("ServiceBT::onDeviceListExtendedStatus: set BT_STATUS_NOT_CONNECTED"));
            VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_NOT_CONNECTED); //CAN Imp
         }
      }
      //   if ((BTPHN_EN_DEVICE_DISCONNECTED == (btphn_tenBTDeviceStatus)status->getODeviceListChange().getE8DeviceStatus()) && (T_e8_BTSetDeviceDisconnectedReason__e8INTERMEDIATE != status->getODeviceListChange().getE8DeviceDisconnectedReason() && T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE != status->getODeviceListChange().getE8DeviceDisconnectedReason() && T_e8_BTSetDeviceDisconnectedReason__e8LINKKEY_MISSING != status->getODeviceListChange().getE8DeviceDisconnectedReason()) // initialized value of DeviceDisconnectedReason at boot
      //       && (m_u8ActiveDevHandle == status->getODeviceListChange().getU8DeviceHandle() || ServiceTel::poGetInstance()->u8GetActiveDev() == BTPHN_C_DEFAULT_VALUE_ZERO || m_u8PassiveDevHandle == status->getODeviceListChange().getU8DeviceHandle()))
      //   {
      //       if ((status->getODeviceListChange().getU8DeviceHandle() != BTPHN_C_DEFAULT_VALUE_ZERO) &&
      //           (status->getODeviceListChange().getU8DeviceHandle() != 0xFF))
      //       {
      //           ETG_TRACE_USR4(("device handle of disconnected :%d", status->getODeviceListChange().getU8DeviceHandle()));
      //           m_u8DisconnectedHandle = status->getODeviceListChange().getU8DeviceHandle();
      //       }
      //   }
   }
   else
   {
      ETG_TRACE_USR4(("All device information is cleared"));
      m_arDeviceListInfo.clear();
      m_arConnectedDeviceProfileInfo.clear();
      vSetActiveDevice(0);
      vSetPassiveDevice(0);
      vSetAVPDevice(0);
      vUpdateConnDeviceHandle(0);
      bDeviceDisconnectInitiated = false;
   }
   rfoDeviceListModel.OnUpdCreateBTDeviceList(m_u8DeviceListSize, m_arDeviceListInfo);
   /* Check for overall HFP and AVP status to update device connection status */
   if (Sm_ActiveSource == 0)
   {
      ETG_TRACE_USR4(("ServiceBT::onDeviceListExtendedStatus :: Sm_ActiveSource %d ", Sm_ActiveSource));
      rfoPhoneCallModel.OnUpdDeviceConnectionStatus();
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::onDeviceListExtendedStatus :: Sm_ActiveSource %d ", Sm_ActiveSource));
   }
}


/***************************************************************************
* function used to get the passive device name and passive device handle.
* Function name : GetPassivePhoneDetails
* parma[in]- std::string, tU8
* param[out]- Void
* v 0.1 initial rev : Palani K
* Req Ids : SYSFL-5565
****************************************************************************/
void ServiceBT::GetPassivePhoneDetails(std::string& strDeviceName, tU8& u8DeviceHandle)
{
   for (uint8 i = 0; i < m_arDeviceListInfo.size(); i++)
   {
      if ((m_arDeviceListInfo[i].GetConnectingStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED) &&
            (m_arDeviceListInfo[i].GetDeviceConnectedStatus() == TRUE))
      {
         if (u8GetActiveDevHandle() != m_arDeviceListInfo[i].GetDeviceHandle())
         {
            u8DeviceHandle =  m_arDeviceListInfo[i].GetDeviceHandle();
            strDeviceName =   m_arDeviceListInfo[i].GetDeviceName().c_str();
            return;
         }
      }
   }
}


/***************************************************************************
* function used to set primary/ secondary / avp connected device handle if there is any device connected.
* Function name : vDeviceConnectionupdate
* parma[in]- DeviceListExtendedStatus, tU8
* param[out]- tVoid
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vDeviceConnectionupdate(const ::boost::shared_ptr< DeviceListExtendedStatus >& status, tU8 u8ChangedDeviceHandle)
{
   ETG_TRACE_USR4((" ServiceBT::vDeviceConnectionupdate u8ChangedDeviceHandle= %d", u8ChangedDeviceHandle));

   for (uint8 i = 0; i < m_arDeviceListInfo.size(); i++)
   {
      if (m_arDeviceListInfo[i].GetDeviceConnectedStatus() == TRUE)
      {
         if ((status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8HFP()
               == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED))
         {
            ETG_TRACE_USR4((" vDeviceConnectionupdate:DEvice HFP connected"));
            if (u8GetActiveDevHandle() != m_arDeviceListInfo[i].GetDeviceHandle())
            {
               ETG_TRACE_USR4(("vDeviceConnectionupdate: Setting Secondary device handle to :%d for device %s", m_arDeviceListInfo[i].GetDeviceHandle(), m_arDeviceListInfo[i].GetDeviceName().c_str()));
               vSetPassiveDevice(m_arDeviceListInfo[i].GetDeviceHandle());
            }
         }
         if (status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8AVP()
               == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
         {
            ETG_TRACE_USR4(("vDeviceConnectionupdate: Setting AVP device handle to :%d for device %s", m_arDeviceListInfo[i].GetDeviceHandle(), m_arDeviceListInfo[i].GetDeviceName().c_str()));
            vSetAVPDevice(m_arDeviceListInfo[i].GetDeviceHandle());
         }
      }
   }
   if ((u8ChangedDeviceHandle >= BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX) &&
         ((m_u8ActiveDevHandle == u8ChangedDeviceHandle) || (m_u8PassiveDevHandle == u8ChangedDeviceHandle)))
   {
      ETG_TRACE_USR4((" vDeviceConnectionupdate:Updating Connected device handle to :%d", u8ChangedDeviceHandle));
      vUpdateConnDeviceHandle(u8ChangedDeviceHandle);
   }
}


/***************************************************************************
* Iterate through the device list and fills the vector m_arPairedDeviceInfo. storing  u8MaxNumOfDev for future
* Function name : vPairedDeviceInfo
* m_u8MaxNumOfHFPConnected : Total HFP Devices connected
* m_u8NumConnectedDevice : Total number of devices connected

* parma[in]- tU8, DeviceListExtendedStatus,
* param[out]- void
* v 0.1 initial rev : Shwetha
* v 0.2 rev: Sai Prabha 31/05/2019 SYSFL:5561,5562
* v 0.3 rev Kumar 21/8/2019 Bug 272399
****************************************************************************/
void ServiceBT::vPairedDeviceInfo(tU8 u8NumOfPairedDevice, const ::boost::shared_ptr< DeviceListExtendedStatus >& status)
{
   ETG_TRACE_USR4(("ServiceBT::vPairedDeviceInfo"));
   m_u8MaxNumOfHFPConnected = 0;
   m_u8NumConnectedDevice = 0;
   m_u8AVPDevHandle = 0;
   m_u8PassiveDevHandle = 0;
   m_u8ActiveDevHandle = 0;

   //To iterate through all the paired devices
   for (tU8 i = 0; i < u8NumOfPairedDevice; i++)
   {
      tU8 l_u8DeviceHandle = status->getODeviceListExtendedResult()[i].getU8DeviceHandle();

      //Add profile status to map only if device is freshly connected. Don't modify old values here.
      if ((status->getODeviceListExtendedResult()[i].getBDeviceConnectedStatus() == true) && ((m_arConnectedDeviceProfileInfo.find(l_u8DeviceHandle) == m_arConnectedDeviceProfileInfo.end())))
      {
         btphn_trBTPairedDeviceInfo rConnectionInfo;
         rConnectionInfo.u8DeviceHandle = m_arDeviceListInfo[i].GetDeviceHandle();
         rConnectionInfo.e8HFPStatus = m_arDeviceListInfo[i].GetHFPStatus();
         rConnectionInfo.e8AVPStatus = m_arDeviceListInfo[i].GetAVPStatus();
         rConnectionInfo.szDeviceName =  m_arDeviceListInfo[i].GetDeviceName();
         m_arConnectedDeviceProfileInfo.insert(std::pair<tU8, btphn_trBTPairedDeviceInfo>(l_u8DeviceHandle, rConnectionInfo));
      }
      //To store number of connected devices through any profile
      if (m_arDeviceListInfo[i].GetDeviceConnectedStatus() == true)
      {
         m_u8NumConnectedDevice++ ;
      }

      //To store number of connected devices through Hands Free profile
      ETG_TRACE_USR4(("DEVICE CONNECTION STATUS = %d", status->getODeviceListExtendedResult()[i].getE8DeviceConnectionStatus()));
      ETG_TRACE_USR4(("HFPConnected from service:%d", status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8HFP()));
      if (status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8HFP() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
      {
         m_u8MaxNumOfHFPConnected++;

         //Incase of current active HFP is disconnected, and second phone is made as active, update phone gadget accordingly.only GUI
         if ((1 == m_u8MaxNumOfHFPConnected) && (Sm_ActiveSource == 0))
         {
            POST_MSG((COURIER_MESSAGE_NEW(PhoneGadgetRequestMsg)(6)));
         }
         ETG_TRACE_USR4(("m_u8MaxNumOfHFPConnected :%d", m_u8MaxNumOfHFPConnected));
         ETG_TRACE_USR4(("HFPConnected from service:%d", status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8HFP()));
         if ((ServiceTel::poGetInstance()) && (l_u8DeviceHandle == ServiceTel::poGetInstance()->u8GetActiveDev()))
         {
            ETG_TRACE_USR4(("HFPConnected set as Active"));
            vSetActiveDevice(l_u8DeviceHandle);
            vUpdateConnDeviceHandle(l_u8DeviceHandle);
         }
         else
         {
            ETG_TRACE_USR4(("HFPConnected set as Passive"));
            vSetPassiveDevice(l_u8DeviceHandle);
         }
      }
      //To store number of connected devices through Audio profile
      if (status->getODeviceListExtendedResult()[i].getODeviceProfileConnectionStatus().getE8AVP() ==
            most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
      {
         vSetAVPDevice(l_u8DeviceHandle);
      }
      ETG_TRACE_USR4(("Device Name = %s", status->getODeviceListExtendedResult()[i].getSDeviceName().c_str()));
      ETG_TRACE_USR4(("device handle of connection sts :%d", l_u8DeviceHandle));

      if ((BTPHN_EN_DEVICE_DISCONNECTED == (btphn_tenBTDeviceStatus)status->getODeviceListChange().getE8DeviceStatus())
            && (T_e8_BTSetDeviceDisconnectedReason__e8INTERMEDIATE != status->getODeviceListChange().getE8DeviceDisconnectedReason()
                && T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE != status->getODeviceListChange().getE8DeviceDisconnectedReason()
                && T_e8_BTSetDeviceDisconnectedReason__e8LINKKEY_MISSING != status->getODeviceListChange().getE8DeviceDisconnectedReason()) // initialized value of DeviceDisconnectedReason at boot
            && (l_u8DeviceHandle == status->getODeviceListChange().getU8DeviceHandle()
                || m_u8ActiveDevHandle == status->getODeviceListChange().getU8DeviceHandle()
                || m_u8PassiveDevHandle == status->getODeviceListChange().getU8DeviceHandle()))
      {
         if ((status->getODeviceListChange().getU8DeviceHandle() != BTPHN_C_DEFAULT_VALUE_ZERO)
               && (status->getODeviceListChange().getU8DeviceHandle() != 0xFF)
               && (0 < m_u8BTAppConnectionStates))
         {
            ETG_TRACE_USR4(("device handle of disconnected :%d", status->getODeviceListChange().getU8DeviceHandle()));
            m_u8DisconnectedHandle = status->getODeviceListChange().getU8DeviceHandle();
            m_u8BTAppConnectionStates = 2;
         }
      }
      if (status->getODeviceListExtendedResult()[i].getE8DeviceConnectionStatus() == BTPHN_C_VALUE_THREE)
      {
         ETG_TRACE_USR4(("device handle of disconnecting :%d", l_u8DeviceHandle));
         m_u8DisconnectedHandle = l_u8DeviceHandle;
         m_u8BTAppConnectionStates = 2;
      }
   }

   //To clear connected device map in case nothing is connected
   if (m_u8NumConnectedDevice == 0)
   {
      ETG_TRACE_USR4(("Map cleared"));
      m_arConnectedDeviceProfileInfo.clear();
      ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.clear();
   }
   /*std::map<tU8, btphn_trBTPairedDeviceInfo>::iterator it = m_arConnectedDeviceProfileInfo.begin();
   for(; it!= m_arConnectedDeviceProfileInfo.end(); it++)
   {
   	ETG_TRACE_USR4(("Device Handle = %d", it->second.u8DeviceHandle));
   	ETG_TRACE_USR4(("Device HFP status = %d", it->second.e8HFPStatus));
   	ETG_TRACE_USR4(("Device AVP status = %d", it->second.e8AVPStatus));
   }*/
}


/***************************************************************************
* Called when device is disconnected and deleted from list
* Function name : vDeviceDisconnectUpdate
* parma[in]- DeviceListExtendedStatus,tU8
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
// tVoid ServiceBT::vDeviceDisconnectUpdate(const ::boost::shared_ptr< DeviceListExtendedStatus >&status, tU8 u8ChangedDeviceHandle)
// {
// ETG_TRACE_USR4(("ServiceBT::vDeviceDisconnectUpdate"));		//Not Called
// if (u8ChangedDeviceHandle == m_u8AVPDevHandle)
// {
// m_u8AVPDevHandle= 0;
// }
// if (u8ChangedDeviceHandle == m_u8ActiveDevHandle)
// {
// m_u8ActiveDevHandle = 0;
// }
// else if (u8ChangedDeviceHandle == m_u8PassiveDevHandle)
// {
// m_u8PassiveDevHandle = 0;
// }
// ETG_TRACE_USR4(("vDeviceDisconnectUpdate :Connected device handle= %d", u8GetConnectedDeviceHandle()));
// }
/***************************************************************************
* ConnectBluetoothProfile method error
* Function name : onConnectBluetoothProfileError
* parma[in]- MOST_BTSet_FIProxy,ConnectBluetoothProfileError
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onConnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onConnectBluetoothProfileResult  ERROR ERROR"));
}


/***************************************************************************
* ConnectBluetoothProfile method result
* Function name : onConnectBluetoothProfileResult
* parma[in]- MOST_BTSet_FIProxy,ConnectBluetoothProfileResult
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onConnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileResult >& result)
{
   ETG_TRACE_USR4(("ServiceBT::onConnectBluetoothProfileResult  getU8DeviceHandle= %d ", result->getU8DeviceHandle()));
}


/************************************************************************
*FUNCTION:		 vValidListUpdate
*DESCRIPTION:	 This function is responsible for updating all the paired device information to GUI
*
*PARAMETER:		u8ChangedDeviceHandle-> handle for status changed device
*               eDeviceStatus -> device status info
				bDeviceFound-> holds true if device handle is found for status changed device
*
*
*RETURNVALUE:	 tVoid
************************************************************************/
// void ServiceBT::vValidListUpdate(tU8 u8ChangedDeviceHandle, btphn_tenBTDeviceStatus eDeviceStatus) // not called
// {
// ETG_TRACE_USR4(("ServiceBT::vValidListUpdate u8ChangedDeviceHandle = %d eDeviceStatus=%d ", u8ChangedDeviceHandle, eDeviceStatus));
// std::vector <DeviceListInformation>::iterator it;
// for (it = m_arDeviceListInfo.begin(); it != m_arDeviceListInfo.end(); it++)
// {
// if (u8ChangedDeviceHandle == it->GetDeviceHandle() || eDeviceStatus == most_BTSet_fi_types::T_e8_BTSetDeviceStatus__e8DEVICE_DELETED)
// {
// vStopConnectionTimers( eDeviceStatus);
// /* Sends the Device name and device status to HMI Model Component.*/
// //vSendDeviceStatus( (btphn_tenBTDeviceStatus)eDeviceStatus);
// return;
// }
// }
// }
/***************************************************************************
* Update the Device Status to Model
* Function name : vProfileChange
* parma[in]- tU8,const btphn_tenBTDeviceStatus
* param[out]- tVoid
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
* v 0.2 initial rev : Sai Prabha Changes :Bug 280289
****************************************************************************/
tVoid ServiceBT::vProfileChange(const tU8 m_u8DeviceListSize, const btphn_tenBTDeviceStatus l_u8DeviceStatus)
{
   ETG_TRACE_USR4(("vProfileChange: Device Status= %d ", l_u8DeviceStatus));

   ETG_TRACE_USR4(("vProfileChange: Update Device connected irrespective profile. "));
   rfoDeviceListModel.OnUpdDeviceConnected(l_u8DeviceStatus, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice);

   for (tU8 i = 0; i < m_u8DeviceListSize; i++)
   {
      std::map<tU8, btphn_trBTPairedDeviceInfo>::iterator it =  m_arConnectedDeviceProfileInfo.find(m_arDeviceListInfo[i].GetDeviceHandle());
      ETG_TRACE_USR4(("Vector devHandle = %d, Map devHandle =%d", m_arDeviceListInfo[i].GetDeviceHandle(), it->second.u8DeviceHandle));
      ETG_TRACE_USR4(("Current HFP status = %d, Previous HFP Status =%d", m_arDeviceListInfo[i].GetHFPStatus(), it->second.e8HFPStatus));
      if ((it != m_arConnectedDeviceProfileInfo.end()) && (m_arDeviceListInfo[i].GetHFPStatus() != it->second.e8HFPStatus))
      {
         if (m_arDeviceListInfo[i].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
         {
            ETG_TRACE_USR4(("vProfileChange: hfpconnected"));
            rfoDeviceListModel.OnUpdConnectedDeviceName(m_arDeviceListInfo[i].GetDeviceName().c_str());
         }
         else if ((m_arDeviceListInfo[i].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED) &&
                  (m_arDeviceListInfo[i].GetAVPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED))
         {
            ETG_TRACE_USR4(("vProfileChange: hfpdisconnected "));
            rfoDeviceListModel.OnUpdDisconnectedDeviceName(m_arDeviceListInfo[i].GetDeviceName().c_str());
         }

         ETG_TRACE_USR4(("vProfileChange: Popup displayed on hfp change "));
         rfoDeviceListModel.OnUpdDeviceConnected(l_u8DeviceStatus, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice);
         //Update the map with changed HFP status
         it->second.e8HFPStatus = m_arDeviceListInfo[i].GetHFPStatus();
      }
      else if ((it != m_arConnectedDeviceProfileInfo.end()) && (m_arDeviceListInfo[i].GetAVPStatus() != it->second.e8AVPStatus))
      {
         ETG_TRACE_USR4(("vProfileChange: Popup displayed on avp change "));
         if ((m_arDeviceListInfo[i].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED)
               && (m_arDeviceListInfo[i].GetAVPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED))
         {
            rfoDeviceListModel.OnUpdDisconnectedDeviceName(m_arDeviceListInfo[i].GetDeviceName().c_str());
         }
         it->second.e8AVPStatus = m_arDeviceListInfo[i].GetAVPStatus();
      }
   }
}


/***************************************************************************
* vUpdateConnDeviceHandle Determines the connected device handle and updates to HMI
* Function name : vUpdateConnDeviceHandle
* parma[in]- const tU8
* param[out]- tVoid
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vUpdateConnDeviceHandle(const tU8 u8DeviceHandle)
{
   ETG_TRACE_USR4(("ServiceBT::UpdateConnDeviceHandle()\t"));
   ETG_TRACE_USR4(("Connected device handle : %d", u8DeviceHandle));

   if (m_u8ConnectedDeviceHandle != u8DeviceHandle)
   {
      m_u8ConnectedDeviceHandle = u8DeviceHandle;
      ETG_TRACE_USR4(("New ConnectedDeviceHandle : %d", m_u8ConnectedDeviceHandle));
   }
   /* Sends the Device handle to the AppLogic classes */
   POST_MSG((COURIER_MESSAGE_NEW(DeviceHandleResp)(m_u8ConnectedDeviceHandle)));

   if (BTPHN_C_DEFAULT_VALUE_ZERO != m_u8ConnectedDeviceHandle)
   {
      std::vector<DeviceListInformation>::iterator it = m_arDeviceListInfo.begin();
      for (it; it != m_arDeviceListInfo.end(); ++it)
      {
         if (m_u8ConnectedDeviceHandle == it->GetDeviceHandle())
         {
            strConnectedBTDeviceName = it->GetDeviceName().c_str();
            rfoDeviceListModel.OnUpdConnectedDeviceName(strConnectedBTDeviceName.c_str());
            tBool bSLCSatus = it->GetOSDStatus();
            rfoDeviceListModel.OnUpdSLCStatus(bSLCSatus);
         }
      }
   }
   else
   {
      ServicePhoneBook* _poPhonebookptr = ServicePhoneBook::poGetInstance();
      //vDeleteAllLists();
      if (_poPhonebookptr != NULL)
      {
         _poPhonebookptr->vDeleteAllLists();
         /*SUZUKI-19075 - Download state will be set to default
         when device disconnected*/
         _poPhonebookptr->vSetCallListDownloadState(most_PhonBk_fi_types_Extended::T_e8_PhonBkRecentCallListDownloadStateExtended__e8RCDS_NOT_STARTED);
      }
      if ((NULL != ServiceTel::poGetInstance()))
      {
         ServiceTel::poGetInstance()->vHandleDeviceHandleResp(m_u8ConnectedDeviceHandle);
      }
   }
}


/***************************************************************************
* ChangeRingtone method error
* Function name : onChangeRingtoneError
* parma[in]- MOST_BTSet_FIProxy,ChangeRingtoneError
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
void ServiceBT::onChangeRingtoneError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeRingtoneError >& error)
{
   ETG_TRACE_USR2(("ServiceBT::onChangeRingtoneError"));

   if (error->hasCcaErrorCode() || error->hasSystemErrorCode())
   {
      ETG_TRACE_USR4(("ServiceBT::onChangeRingtoneError Encountered error in Change in ringtone. Hence set usePhonesetting unchecked (will use default tone)"));
      PhonebookModelComponent::poGetInstance()->OnUpdChangeRingtoneStatus(BTPHN_C_VALUE_ONE);
   }
}


/***************************************************************************
* ChangeRingtone method status
* Function name : onChangeRingtoneStatus
* parma[in]- MOST_BTSet_FIProxy, ChangeRingtoneStatus
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onChangeRingtoneStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::ChangeRingtoneStatus >& status)
{
   ETG_TRACE_USR4(("ServiceBT::onChangeRingtoneStatus"));
   ETG_TRACE_USR4(("ServiceBT::onChangeRingtoneStatus : status->getU8DeviceHandle() : %d", status->getU8DeviceHandle()));
   ETG_TRACE_USR4(("ServiceBT::onChangeRingtoneStatus : ServiceTel::poGetInstance()->u8GetActiveDev() : %d", ServiceTel::poGetInstance()->u8GetActiveDev()));

   if ((status->getU8DeviceHandle() != 0) && (ServiceTel::poGetInstance()->u8GetActiveDev() == status->getU8DeviceHandle()))
   {
      ETG_TRACE_USR4(("ServiceBT::onChangeRingtoneStatus INSIDE IF "));
      POST_MSG((COURIER_MESSAGE_NEW(ChangeRingtoneResp)((Courier::UInt8)status->getU16RingtoneID())));
      if ((NULL != PhonebookModelComponent::poGetInstance()))
      {
         PhonebookModelComponent::poGetInstance()->OnUpdChangeRingtoneStatus(status->getU16RingtoneID());
      }
   }
}


#endif

/***************************************************************************
* PairingPin property error
* Function name : onPairingPinError
* parma[in]- MOST_BTSet_FIProxy,PairingPinError
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onPairingPinError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingPinError >& error)
{
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
* Function name : onPairingPinStatus
* 18.09.2017: vke6kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onPairingPinStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< ::MOST_BTSet_FI::PairingPinStatus >& status)
{
   ETG_TRACE_USR2(("PairingPinStatus: PinNumber :%s", status->getSPinNumber().c_str()));
   if (std::strcmp("", (status->getSPinNumber().c_str())) == 0)
   {
      return;
   }
   ETG_TRACE_USR2(("PairingPinStatus:Closing disconnected popup"));

   rfoDeviceListModel.OnUpdPairingPinStatus(status->getSPinNumber().c_str());
}


void ServiceBT::onVehicleBTFriendlyNameError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< VehicleBTFriendlyNameError >& /*error*/)
{
   ETG_TRACE_ERR(("ServiceBT: onVehicleBTFriendlyNameError"));
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
* Function name : onVehicleBTFriendlyNameStatus
* 18.09.2017: vke6kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onVehicleBTFriendlyNameStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< VehicleBTFriendlyNameStatus >& status)
{
   ETG_TRACE_USR2(("VehicleBTFriendlyNameStatus: VehicleBTFriendlyName:%s", status->getSVehicleBTFriendlyName().c_str()));
   if (std::strcmp("", (status->getSVehicleBTFriendlyName().c_str())) != 0)
   {
      rfoDeviceListModel.OnUpdVehicleBTFriendlyNameStatus(status->getSVehicleBTFriendlyName().c_str());
   }
}


/***************************************************************************
* MaxDevicespaired property error
* Function name : onMaxDevicesPairedError
* parma[in]- MOST_BTSet_FIProxy,MaxDevicesPairedError
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onMaxDevicesPairedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< MaxDevicesPairedError >& /*error*/)
{
   ETG_TRACE_USR4(("BTSetting: onMaxDevicesPairedError"));
}


/*****************************************************************************
* @brief: Proprty Status Update for MaxDevicesPaired
* Function name : onMaxDevicesPairedStatus
* 18.09.2017: vke6kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::onMaxDevicesPairedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const boost::shared_ptr< MaxDevicesPairedStatus >& status)
{
   ETG_TRACE_USR2(("MaxDevicesPairedStatus: DeviceHandle : %d, DeviceName : %d", status->getU8DeviceHandle(), status->getSDeviceName().c_str()));
}


/***************************************************************************
* RequestDeviceRingtoneList method error
* Function name : onRequestDeviceRingtoneListError
* parma[in]- MOST_BTSet_FIProxy,RequestDeviceRingtoneListError
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
void ServiceBT::onRequestDeviceRingtoneListError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListError >& error)
{
}


/***************************************************************************
* RequestDeviceRingtoneList method result
* Function name : onRequestDeviceRingtoneListResult
* parma[in]- MOST_BTSet_FIProxy,RequestDeviceRingtoneListResult
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onRequestDeviceRingtoneListResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListResult >& result)
{
}


#endif

/***************************************************************************
* GetDeviceInfoExtended method error
* Function name : onGetDeviceInfoExtendedError
* parma[in]- MOST_BTSet_FIProxy,GetDeviceInfoExtendedError
* param[out]- void
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onGetDeviceInfoExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedError >& error)
{
}


/***************************************************************************
* GetDeviceInfoExtended method result
* Function name : onGetDeviceInfoExtendedResult
* parma[in]- MOST_BTSet_FIProxy,GetDeviceInfoExtendedResult
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
void ServiceBT::onGetDeviceInfoExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedResult >& result)
{
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
* Function name : onCourierMessage
* 18.09.2017: vke6kor
* Rev 0.1: Initial Version
* Rev 1.0 Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
*****************************************************************************/
bool ServiceBT::onCourierMessage(const AddNewDeviceReq& corfoMsg)
{
   ETG_TRACE_USR2(("onCourierMessage:  AddNewDeviceReq m_u8MaxNumOfHFPConnected = %d m_u8AVPDevHandle= %d\n", m_u8MaxNumOfHFPConnected, m_u8AVPDevHandle));
   //flag used only when a add new device request is triggered when there is an already connected device.
   bAddDeviceAfterDisconnect = false;
   if (FALSE == bChangeDeviceStateReq)
   {
      IsParingActive = 0;
   }
   tU8 DevHandle = 0;
   if (m_u8DeviceListSize < BTPHN_C_MAX_PAIRED_DEVICE)		//To check whether the paired device list is full or not.
   {
      ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType;
      if (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= m_u8AVPDevHandle)		//To check if A2DP is already connected for any device.
      {
         ServiceType.setBAVP(true);
         DevHandle = m_u8AVPDevHandle;
         ETG_TRACE_USR2(("onCourierMessage:  AddNewDeviceReq: Disconnecting because avp handle <=2"));
         vSendDisconnectBTProfile(DevHandle, ServiceType);
      }
      if (m_u8MaxNumOfHFPConnected >= 2)
      {
         ServiceType.setBHFP(true);
         DevHandle = u8GetDisconnectionDevHandle();
         ETG_TRACE_USR2(("onCourierMessage:  AddNewDeviceReq:Disconnecting because hfp connected >=2"));
         vSendDisconnectBTProfile(DevHandle, ServiceType);
      }
      vSendAddNewDeviceStart();
   }
   else
   {
      rfoDeviceListModel.OnUpdDeviceListfull();
   }
   if (_btSetProxy == NULL)
   {
      bChangeDeviceStateReq = false;
   }
   return true;
}


/*****************************************************************************
* @brief: responsible sending new device start for service
* Function name : vSendAddNewDeviceStart
* 24.04.2018: kis8kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::vSendAddNewDeviceStart()
{
   ETG_TRACE_USR4(("vSendAddNewDeviceStart:DeviceStateReqFlag : %d", bChangeDeviceStateReq));
   if (bChangeDeviceStateReq == false)
   {
      ETG_TRACE_USR2(("onCourierMessage:  AddNewDeviceReqstart"));
      if (NULL != _btSetProxy)
      {
         _btSetProxy->sendAddNewDeviceStart(*this, true);
         if (VehicleSrvClient::poGetInstance() != NULL)
         {
            VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_SEARCHING); //CAN Imp
         }
      }
      bChangeDeviceStateReq = true;
      ETG_TRACE_USR4(("vSendAddNewDeviceStart:DeviceStateReqFlag : %d", bChangeDeviceStateReq));
   }
}


/*****************************************************************************
* @brief: Proprty Status Update for DeviceListStatus
* Function name : onCourierMessage
* 18.09.2017: vke6kor
* Rev 0.1: Initial Version
*****************************************************************************/
bool ServiceBT::onCourierMessage(const SSPResponseReq& corfoMsg)
{
   ETG_TRACE_USR2(("sendPairingResponseStart()"));
   T_e8_BTSetPairingResponseType enSSPResponse = static_cast <T_e8_BTSetPairingResponseType>(corfoMsg.GetPairingResponse());
   if (_btSetProxy != NULL)
   {
      /* Whenever making explicit cancel pairing request by the user, update the boolean variable to true to maintain the status */
//commenting this code for the bug fix 887119
      /*       if (corfoMsg.GetPairingResponse() == BTPHN_EN_PAIRING_RESPONSE_CANCEL)
            {
               m_bPairingCancelReqStatus = true;
            } */

      _btSetProxy->sendPairingResponseStart(*this, (T_e8_BTSetPairingResponseType)enSSPResponse);
   }
   return true;
}


/***************************************************************************
* Function name : vSendAutoConnectStart
* parma[in]-
* param[out]- tVoid
* v 0.1 initial rev : Shwetha
****************************************************************************/
tVoid ServiceBT::vSendAutoConnectStart()
{
   ETG_TRACE_USR2(("vSendAutoConnectStart()"));
   if (NULL != _btSetProxy)
   {
      _btSetProxy->sendStartAutoConnectSequenceStart(*this, true);
   }
}


/***************************************************************************
* Function name : vUpdateDevicelistStatusOnAndroidAutoSessionChange
* v 0.1 initial rev : Palani K
* Req Ids :
* Refresh device list status on android auto session status change
****************************************************************************/
tVoid ServiceBT::vUpdateDevicelistStatusOnAndroidAutoSessionChange()
{
   ETG_TRACE_USR2(("ServiceBT: vUpdateDevicelistStatusOnAndroidAutoSessionChange "));

   /*Refresh device list status on android auto session status change*/
   rfoDeviceListModel.OnUpdCreateBTDeviceList(m_u8DeviceListSize, m_arDeviceListInfo);
}


/***************************************************************************
* Function name : onCourierMessage
* parma[in]- const DeviceListReq&
* param[out]- bool
* v 0.1 initial rev : Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
* updated the list to model and device name to model
* v 0.2 rev : Sai Prabha
****************************************************************************/
bool ServiceBT::onCourierMessage(const DeviceListReq& oMsg)
{
   ETG_TRACE_USR2(("onCourierMessage:  DeviceListReq"));

   rfoDeviceListModel.OnUpdCreateBTDeviceList(m_u8DeviceListSize, m_arDeviceListInfo);
   //On Acc ON/OFF the status of the devices needs to be updated
   rfoDeviceListModel.OnUpdDeviceConnected(BTPHN_EN_DEVICE_NO_CHANGE, m_u8MaxNumOfHFPConnected, m_u8NumConnectedDevice); //PRABHA
   ServiceTel* poServiceTel = ServiceTel::poGetInstance();
   for (tU8 i = 0; i < m_u8DeviceListSize; i++)
   {
      if (poServiceTel != NULL)
      {
         if (m_arDeviceListInfo[i].GetDeviceHandle() == poServiceTel->u8GetActiveDev())
         {
            //bruce long data phone device name
            //bruce OPL check when to send phone info and call info
            strConnectedBTDeviceName = m_arDeviceListInfo[i].GetDeviceName().c_str();
            ETG_TRACE_USR2(("updating name also ::SAI"));
            rfoDeviceListModel.OnUpdConnectedDeviceName(m_arDeviceListInfo[i].GetDeviceName().c_str());
            VehicleSrvClient::poGetInstance()->vUpdatePhoneInfo(LONGDATATYPE_PHONENAME, m_arDeviceListInfo[i].GetDeviceName().c_str());
         }
      }
   }
   return true;
}


///////////////////////////
bool ServiceBT::onCourierMessage(const RenderingCompleteMsg& oMsg)
{
   const Courier::ViewId View_Name = Courier::ViewId(oMsg.GetViewName().GetCString());
   const Courier::ViewId IACTIVECALL = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_IntercomCall");
   const Courier::ViewId ICALLCONNECTING = Courier::ViewId("Global#Scenes#Speller#I_Call_Connecting");
   const Courier::ViewId ICONFCALL = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Intercom_ConferenceCall");
   ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg GetViewName:%s", oMsg.GetViewName().GetCString()));

   if ((View_Name == IACTIVECALL) || (View_Name == ICALLCONNECTING) || (View_Name == ICONFCALL))
   {
      ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg, Active view = %s", oMsg.GetViewName().GetCString()));
      bIsIntercomCallScene = true;
   }
   else
   {
      ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg, Active view not Intercom call scenes = %s", oMsg.GetViewName().GetCString()));
      bIsIntercomCallScene = false;
   }

   return false;
}


//////////////////
/*****************************************************************************
* @brief: setter function to set connected device handle
* Function name : vSetConnectedDeviceHandle
* 27.11.2017: kis8kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::vSetConnectedDeviceHandle(tU8 tu8connectedDeviceHandle)
{
   ETG_TRACE_USR2(("ServiceBT:  vSetConnectedDeviceHandle, setting conncted device handle to = %d\n", tu8connectedDeviceHandle));
   m_u8ConnectedDeviceHandle = tu8connectedDeviceHandle;
}


/*****************************************************************************
* @brief: setter function to set connected device handle
* Function name : u8GetConnectedDeviceHandle
* 27.11.2017: kis8kor
* Rev 0.1: Initial Version
*****************************************************************************/
tU8 ServiceBT::u8GetConnectedDeviceHandle()
{
   ETG_TRACE_USR2(("ServiceBT:  u8GetConnectedDeviceHandle, conncted device handle to = %d\n", m_u8ConnectedDeviceHandle));
   return m_u8ConnectedDeviceHandle;
}


/***************************************************************************
* @brief: function to toggle between the two HFP devices to set active phone
* Function name : vToggleActivePhone()
* v 0.1 initial rev : Sai Prabha
* Req Ids : SYSFL-5561,62
*****************************************************************************/
tVoid ServiceBT::vToggleActivePhone()
{
   ServicePhoneBook::poGetInstance()->bPhonebookContactSupport = false;
   if (0 != m_arConnectedDeviceProfileInfo.size())
   {
      ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
      ETG_TRACE_USR4(("ServiceBT::ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
      std::map<tU8, btphn_trBTPairedDeviceInfo>::iterator it =  m_arConnectedDeviceProfileInfo.begin();
      for (it ; it != m_arConnectedDeviceProfileInfo.end() ; ++it)
      {
         if (it->first != ServiceTel::poGetInstance()->u8GetActiveDev())
         {
            if (most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED == it->second.e8HFPStatus)
            {
               ETG_TRACE_USR4(("ServiceBT::TogglePhonesHandleMsg():%d", it->first));
               ETG_TRACE_USR4(("Deleting lists on Disconnection of phone"));
               ServicePhoneBook::poGetInstance()->vDeleteCallListOnToggle();
               ServicePhoneBook::poGetInstance()->vDeleteContactListOnToggle();
               ServiceTel::poGetInstance()->vSetActivePhone(it->first, it->second.szDeviceName);
               strConnectedBTDeviceName = it->second.szDeviceName;
               ETG_TRACE_USR4(("ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
               ETG_TRACE_USR4(("OnUpdConnectedDeviceName:%s", it->second.szDeviceName));
               //Bug 680928
               std::map<tU8, tU8>::iterator itr =  ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.find(it->first);
               ServicePhoneBook::poGetInstance()->bPhonebookContactSupport = itr->second;
               ETG_TRACE_USR4(("corresponding PB support value is:%d", ServicePhoneBook::poGetInstance()->bPhonebookContactSupport));

               break;
            }
         }
      }
   }
}


/**************************************************************************
* This courier message is called when list item is pressed.
* This function extracts the list id, list row value and list col value from which the button reaction  message is triggered.
* It calls list specific implementation for each list from which button reacton is posted
* @param[in] - oMsg -  courier message received
*
* @param[out]- returns true if message is consumed else false
initial rev: Sai Prabha
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781,SYSFL-475838,475839
**************************************************************************/
bool ServiceBT::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg()"));
   tBool bRetVal = false;
   ListProviderEventInfo info;
#ifndef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   const Courier::ViewId GADGET_SCENE_NAME = Courier::ViewId("/Scene2D:AppHmi_PhoneModule#PhoneScenes#P_CallList");
   const Courier::Identifier  IdBtn2 = Courier::Identifier("Layer_TouchArea_Toggle/ButtonWidget");

   const Courier::Identifier senderInfo = oMsg.GetSender();
   const Courier::ViewId sceneName = oMsg.GetView();

   if (oMsg.GetEnReaction() == enRelease)
   {
      ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg - enRelease"));

      if (senderInfo == IdBtn2)
      {
         ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget"));
         ETG_TRACE_USR4(("ServiceBT::TogglePhonesHandleMsg()"));

         ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
         if (0 != m_arConnectedDeviceProfileInfo.size())
         {
            ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
            ETG_TRACE_USR4(("ServiceBT::ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
            vToggleActivePhone();
         }
      }
   }
#endif

#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
   const Courier::ViewId CALL_LIST = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList");
   const Courier::ViewId CONTACT_LIST = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts");
   const Courier::ViewId CALL_LIST_LOADING = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_CallList_Loading");
   const Courier::ViewId CONTACT_LIST_LOADING = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_Contacts_Loading");
   const Courier::ViewId DIALPAD = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#P_DialPad");
   const Courier::ViewId ICONTACTS = Courier::ViewId("AppHmi_PhoneModule#PhoneScenes#I_Contacts");

   const Courier::Identifier  IdBtn2 = Courier::Identifier("Layer_TouchArea_Toggle/ButtonWidget");

   const Courier::Identifier senderInfo = oMsg.GetSender();
   const Courier::ViewId sceneName = oMsg.GetView();

   if ((oMsg.GetEnReaction() == enRelease) && (senderInfo == IdBtn2))
   {
      ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg - enRelease"));
      bool IsPhoneIntercomCallActive = false;
      if ((true == IsIntercomCallActive) || (true == IntercomClienthandler::poGetInstance()->getIntercomIncomingCallStatus()) || (true == IntercomClienthandler::poGetInstance()->getIntercomCallDialingStatus()))
      {
         ETG_TRACE_USR4(("PhoneHall::Intercom Call is active hence toggle shouldnt be processed"));
         IsPhoneIntercomCallActive = true ;
      }
      if ((true == ServiceTel::poGetInstance()->getIncomingCallStatus()) || (true == ServiceTel::poGetInstance()->getCallDialingStatus()) || (true == ServiceTel::poGetInstance()->getOngoingCallStatus()))
      {
         ETG_TRACE_USR4(("PhoneHall::BT Call is active hence toggle shouldnt be processed"));
         IsPhoneIntercomCallActive = true ;
      }

      if (((sceneName == CALL_LIST) || (sceneName == CONTACT_LIST) || (sceneName == DIALPAD) || (sceneName == CALL_LIST_LOADING) || (sceneName == CONTACT_LIST_LOADING)) && (false == IsPhoneIntercomCallActive))
      {
         ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
         ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg - enRelease inside scene"));
         if ((GetNoOfHFPDevicesConnected() == 2) && (u8Active_Source == PHONEONE))
         {
            ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget"));
            ETG_TRACE_USR4(("ServiceBT::TogglePhonesHandleMsg()"));

            ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
            if (0 != m_arConnectedDeviceProfileInfo.size())
            {
               // this is for Phone1 to Phone 2 toggle :::  (Phone1, phone2 and intercom connected)
               Sm_ActiveSource = 0;
               ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
               ETG_TRACE_USR4(("ServiceBT::ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
               u8Active_Source = PHONETWO;
               rfoDeviceListModel.OnUpdGadgetStatus(u8Active_Source);
               vToggleActivePhone();
               ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
            }
         }
         else
         {
            // this is for Phone2 to Intercom toggle :::  (Phone1, phone2 and intercom connected)
            if (true == PhoneGadgetModel::poGetInstance()->GetIntercomStatus())
            {
               u8Active_Source = INTERCOM;
               Sm_ActiveSource = 1;
               ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
               ETG_TRACE_USR4(("ServiceBT : switch to ICONTACTS scene"));
               rfoDeviceListModel.OnUpdGadgetStatus(u8Active_Source);
               POST_MSG(COURIER_MESSAGE_NEW(ActivateOnIContactsSceneMsg)());
            }
            else
            {
               ETG_TRACE_USR4(("ServiceBT : Intercom service is not available"));
               ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
               if (0 != m_arConnectedDeviceProfileInfo.size())
               {
                  ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
                  ETG_TRACE_USR4(("ServiceBT::ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
                  u8Active_Source = PHONEONE;
                  Sm_ActiveSource = 0;
                  rfoDeviceListModel.OnUpdGadgetStatus(u8Active_Source);
                  vToggleActivePhone();
                  ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
               }
            }
         }
      }
      else if ((sceneName == ICONTACTS) && (false == IsPhoneIntercomCallActive))
      {
         if (GetNoOfHFPDevicesConnected() == 0)
         {
            // this is for No toggle :::  (only intercom connected)
            u8Active_Source = INTERCOM;
            Sm_ActiveSource = 1;
            rfoDeviceListModel.OnUpdGadgetStatus(u8Active_Source);
            ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
            ETG_TRACE_USR4(("ServiceBT : dont toggle as no phones connected"));
         }
         else
         {
            ETG_TRACE_USR4(("ServiceBT : Toggle to phone"));
            if (0 != m_arConnectedDeviceProfileInfo.size())
            {
               Sm_ActiveSource = 0;
               ETG_TRACE_USR4(("ServiceBT::m_arConnectedDeviceProfileInfo.size():%d", m_arConnectedDeviceProfileInfo.size()));
               ETG_TRACE_USR4(("ServiceBT::ServiceTel::poGetInstance()->u8GetActiveDev():%d", ServiceTel::poGetInstance()->u8GetActiveDev()));
               u8Active_Source = PHONEONE;
               rfoDeviceListModel.OnUpdGadgetStatus(u8Active_Source);
               POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(ActivateCallListMsg)()));
               vToggleActivePhone();

               ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg-ButtonWidget u8Active_Source = %d", u8Active_Source));
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("ServiceBT : No Action"));
         ETG_TRACE_USR4(("ServiceBT :IsPhoneIntercomCallActive = %d", IsPhoneIntercomCallActive));
      }
   }
#endif
   // TODO: Ramesh Need to enable below method call to Ensure Phone Gadget state is correctly updated.
   // But that method is dependent on ServiceBT
   PhoneGadgetModel::poGetInstance()->UpdatePhoneGadgetInfo();

   if (oMsg.GetEnReaction() == enRelease)
   {
      ETG_TRACE_USR4(("ServiceBT : ButtonReactionMsg - enRelease"));

      // ETG_TRACE_USR4(("ServiceBT:ButtonReactionMsg Listid : %d, HdlRow : %d, hdlCol : %d", listId, hdlRow, hdlCol));
      /*GetItemIdentifierInfo is base class function which extracts row ,column values and list id from the message received from ButtonReactionMsg */
      if (ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info))
      {
         /*to store list id , row value, column value as received from button press*/
         unsigned int listId = info.getListId();
         tU8 hdlRow = info.getHdlRow();
         tU8 hdlCol = info.getHdlCol();
         // the list id for generic access
         // if more than 1 active element in one list row, e.g. Button in a button line
         ETG_TRACE_USR4(("ServiceBT:ButtonReactionMsg Listid : %d, HdlRow : %d, hdlCol : %d", listId, hdlRow, hdlCol));
         /*to do: write call list case when call feature is implemented*/
         switch (listId)
         {
            case LISTID_PHONESELECTION:
            {
               ETG_TRACE_USR4(("ServiceBT : on ButtonReactionMsg(): LISTID_PHONESELECTION"));
               vPairedDevListItemInfo(hdlRow, hdlCol);
               bRetVal = true;
               break;
            }
            case LISTID_CONTACTCALLLIST:
            {
               ETG_TRACE_USR4(("ServiceBT : on ButtonReactionMsg(): LISTID_CONTACTCALLLIST"));
               vContactCallListItemInfo(hdlRow);
               bRetVal = true;
               break;
            }
            default:
               ETG_TRACE_USR4(("inside default"));
         }//end of switch(listId)
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
         switch (listId)
         {
            case LISTID_ICONTACTS:
            {
               //to place intercom outgoing call
               ETG_TRACE_USR4(("IntercomClienthandler : on ButtonReactionMsg(): LISTID_ICONTACTS"));
               IntercomClienthandler::poGetInstance()->OnUpdIContactsCall(hdlRow);
               bRetVal = true;
               break;
            }
            default:
               ETG_TRACE_USR4(("inside default"));
         }//end of switch(listId)
#endif
      }// end of if (ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info) && (info.getListId() == LISTID_PHONESELECTION))
   }
   return bRetVal;
}


///
bool ServiceBT::onCourierMessage(const IntercomStatusMsg& oMsg)
{
   ETG_TRACE_USR4(("IntercomStatusMsg"));
   if (sm_variant_intercom == 1)
   {
      ETG_TRACE_USR4(("inside if"));
      rfoDeviceListModel.OnUpdIntercomStatus(true, false);
   }
   else
   {
      ETG_TRACE_USR4(("inside else"));
      rfoDeviceListModel.OnUpdIntercomStatus(false, true);
   }
   return true;
}


/**********************************************************************
* This function is called if a paired device list item is pressed.
*  this message checks for valid row index and posts DeleteDeviceResp courier msg to controller
* @param[in] - listId- list id received from button reaction msg
hdlRow- row index as received from btton reaction msg
hdlCol - column index as received from button reaction msg
*
* @param[out]- void
v 0.1 initial rev: Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
v 0.2 rev: Sai Prabha changes :Bug 280289
****************************************************************************/
tVoid ServiceBT::vPairedDevListItemInfo(tU8 hdlRow, tU8 hdlCol)
{
   ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo IsParingActive = %d IsDeviceListOperationProgress = %d", IsParingActive, IsDeviceListOperationProgress));
   if (hdlRow >= m_arDeviceListInfo.size() || hdlCol > BTPHN_VALUE_FOUR)
   {
      ETG_TRACE_ERR(("vPairedDevListItemInfo: Invalid row/col value"));
      return;
   }
   /*re-write IsPairingActive and IsDeviceConnected flag*/
   else if ((BTPHN_C_VALUE_ZERO == IsDeviceListOperationProgress) && (BTPHN_C_VALUE_ZERO == IsParingActive))  // To check if Devicelist operation or Pairing is not in progress
   {
      ETG_TRACE_USR4(("ServiceBT: Row value mapped to device %s", m_arDeviceListInfo[hdlRow].GetDeviceName().c_str()));
      ::most_BTSet_fi_types_Extended::T_BTServiceType ProfileType;
      switch (hdlCol)
      {
         case 0: // Connection or Disconnection from the device tile in the paired device list
         {
            /* Process Connection or Disconnection only when Android auto session or Carplay is not active */
            if ((g_SM_SpiSessionStatus != SPI_SESSION_ANDROID_AUTO_ACTIVE) && (g_SM_SpiSessionStatus != SPI_SESSION_CARPLAY_ACTIVE))
            {
               if ((m_arDeviceListInfo[hdlRow].GetHFPStatus() != most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED) &&
                     (m_arDeviceListInfo[hdlRow].GetAVPStatus() != most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED))
               {
                  ETG_TRACE_USR4(("ServiceBT: vSendConnectBTProfile for HFP"));
                  vProceedForHFPConnection(hdlRow);
                  ETG_TRACE_USR4(("ServiceBT: vSendConnectBTProfile for A2DP"));
                  vProceedForAVPConnection(hdlRow);
               }
               else
               {
                  ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo Devicedisconnect confirmation ?"));
                  rfoDeviceListModel.OnUpdDeviceName(m_arDeviceListInfo[hdlRow].GetDeviceName());
                  u8DisconnectDeviceIndex = hdlRow;
                  POST_MSG((COURIER_MESSAGE_NEW(DisconnectDeviceResp)()));
               }
            }
            break;
         }
         case 1: // HFP Profile Toggle button
         {
            /* Process HFP Profile Toggle only when Android auto session or Carplay is not active */
            if ((g_SM_SpiSessionStatus != SPI_SESSION_ANDROID_AUTO_ACTIVE) && (g_SM_SpiSessionStatus != SPI_SESSION_CARPLAY_ACTIVE))
            {
               if (m_arDeviceListInfo[hdlRow].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED) // If HFP is already connected
               {
                  ETG_TRACE_USR4(("ServiceBT: vSendDisconnectBTProfile for HFP"));
                  ProfileType.setBHFP(true);
                  m_bIsDisconnectflag = true ; // fix for the bug disconnected pop up displayed twice : Bug 893271(detailed analysis is in bug)
                  vSendDisconnectBTProfile(m_arDeviceListInfo[hdlRow].GetDeviceHandle(), ProfileType);
               }
               else
               {
                  ETG_TRACE_USR4(("ServiceBT: vProceedForHFPConnection for HFP"));
                  vProceedForHFPConnection(hdlRow);
               }
            }
            break;
         }
         case 2: // A2DP Profile Toggle button
         {
            if (m_arDeviceListInfo[hdlRow].GetAVPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)  // If A2DPP is already connected
            {
               ETG_TRACE_USR4(("ServiceBT: vSendDisconnectBTProfile for A2DP"));
               ProfileType.setBAVP(true);
               vSendDisconnectBTProfile(m_arDeviceListInfo[hdlRow].GetDeviceHandle(), ProfileType);
            }
            else
            {
               ETG_TRACE_USR4(("ServiceBT: vSendConnectBTProfile for A2DP"));
               vProceedForAVPConnection(hdlRow);
            }
            break;
         }
         case 3: // Delete device button
         {
            ETG_TRACE_USR4(("ServiceBT: DELETE DEVICE"));
            bDeviceDisconnectInitiated = true;
            IsDeviceListOperationProgress = BTPHN_C_VALUE_ONE;
            u8PairedDeviceListDeviceDleteIndex = hdlRow;
            //if row value received is valid, then update deleting deice name. device index starts from 0
            rfoDeviceListModel.OnUpdDeviceName(m_arDeviceListInfo[hdlRow].GetDeviceName());
            //post message to controller, controller upon receiving DeleteDeviceResp msg, shows DeleteDeviceConfirmation popup to user
            POST_MSG((COURIER_MESSAGE_NEW(DeleteDeviceResp)()));
            break;
         }
         case 4:
         {
            ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo Call List Entry scenario"));
            if (m_arDeviceListInfo[hdlRow].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
            {
               uint8 l_u8ActivePhoneDevice = 0;
               l_u8ActivePhoneDevice = ServiceTel::poGetInstance()->u8GetActiveDev();
               ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo l_u8ActivePhoneDevice = %d ", l_u8ActivePhoneDevice));
               if (m_arDeviceListInfo[hdlRow].GetDeviceHandle() == l_u8ActivePhoneDevice)
               {
                  ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo : Active Device name selected ->Posting ActivateCalllistMsg. "));
                  POST_MSG((COURIER_MESSAGE_NEW(ActivateCallListMsg)()));
               }
               else
               {
                  ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo : selected index %d (device handle : %d) is not an active device. Hence no Action performed.", hdlRow, m_arDeviceListInfo[hdlRow].GetDeviceHandle()));
               }
            }
            else
            {
               ETG_TRACE_USR4(("ServiceBT: vPairedDevListItemInfo : Selected index is not HFP Connected Device. hence no action performed. "));
            }
            break;
         }
         default:
            ETG_TRACE_USR4(("ServiceBT: Default case for phone_selection button reaction"));
            break;
      }
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT: List Operation or pairing operation in progress"));
   }
}


bool ServiceBT::onCourierMessage(const DisconnectDeviceConfirmationReq& oMsg)
{
   ::most_BTSet_fi_types_Extended::T_BTServiceType ProfileType;
   m_bIsDisconnectflag = true ; // fix for the bug disconnected pop up displayed twice : Bug 893271(detailed analysis is in bug)
   bDeviceDisconnectInitiated = true;
   ETG_TRACE_USR4(("ServiceBT:DisconnectDeviceConfirmationReq:%d", bDeviceDisconnectInitiated));
   ETG_TRACE_USR4(("ServiceBT: DisconnectDeviceConfirmationReq SendDisconnectBTProfile for A2DP"));
   ProfileType.setBAVP(true);
   ETG_TRACE_USR4(("ServiceBT:DisconnectDeviceConfirmationReq GetAVP:%d", ProfileType.getBAVP()));
   vSendDisconnectBTProfile(m_arDeviceListInfo[u8DisconnectDeviceIndex].GetDeviceHandle(), ProfileType);
   ETG_TRACE_USR4(("ServiceBT: DisconnectDeviceConfirmationReq SendDisconnectBTProfile for HFP"));
   ProfileType.setBHFP(true);
   ETG_TRACE_USR4(("ServiceBT:DisconnectDeviceConfirmationReq GetHFP:%d", ProfileType.getBHFP()));
   vSendDisconnectBTProfile(m_arDeviceListInfo[u8DisconnectDeviceIndex].GetDeviceHandle(), ProfileType);
   return true;
}


/***************************************************************************
* This function is called inorder to initiate HFP connection to the device
* Function name : vProceedForHFPConnection
* parma[in]- tU8 hdlRow
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vProceedForHFPConnection(tU8 hdlRow)
{
   ETG_TRACE_USR4(("ServiceBT: vProceedForHFPConnection row value = %d", hdlRow));
   ::most_BTSet_fi_types_Extended::T_BTServiceType ProfileType;  //HFP/A2DP
   ProfileType.setBHFP(true);

   if (m_u8MaxNumOfHFPConnected >= MAX_HFP_CONNECTION) //If Already two device are connected to HFP, we have to disconnect the Active OSD HFP device first.
   {
      ETG_TRACE_USR4(("vProceedForHFPConnection: Disconnect previous device"));
      vSendDisconnectBTProfile(u8GetDisconnectionDevHandle(), ProfileType);
      m_u8StoreHandleHFP = m_arDeviceListInfo[hdlRow].GetDeviceHandle();		//storing the device handle for new HFP connection after disconnecting the old one
   }
   else
   {
      ETG_TRACE_USR4(("vProceedForHFPConnection: Connect new device"));
      vSendConnectBTProfile(m_arDeviceListInfo[hdlRow].GetDeviceHandle(), ProfileType);
   }
}


/***************************************************************************
* This function is called inorder to initiate A2DP connection to the device.
* Function name : vProceedForAVPConnection
* parma[in]- tU8 hdlRow
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vProceedForAVPConnection(tU8 hdlRow)
{
   ETG_TRACE_USR4(("ServiceBT: vProceedForAVPConnection row value =%d", hdlRow));
   ::most_BTSet_fi_types_Extended::T_BTServiceType ProfileType;
   ProfileType.setBAVP(true);

   if (u8GetAVPDevHandle() >= BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX)		//If Already A2DP connection exists, we have to disconnect the current A2DP device first.
   {
      ETG_TRACE_USR4(("vProceedForAVPConnection: Disconnect previous device"));
      vSendDisconnectBTProfile(u8GetAVPDevHandle(), ProfileType);
      m_u8StoreHandleAVP = m_arDeviceListInfo[hdlRow].GetDeviceHandle();		//storing the device handle for new A2DP connection after disconnecting the old one
   }
   else
   {
      ETG_TRACE_USR4(("vProceedForAVPConnection: Connect new device"));
      vSendConnectBTProfile(m_arDeviceListInfo[hdlRow].GetDeviceHandle(), ProfileType);
   }
}


/***************************************************************************
* This function is called inorder to obtain the handle for the OSD HFP device for disconnection.
* Function name : u8GetDisconnectionDevHandle
* parma[in]- NA
* param[out]- tU8
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tU8 ServiceBT::u8GetDisconnectionDevHandle()
{
   ServiceTel* poServiceTel = ServiceTel::poGetInstance();
   if (poServiceTel != NULL)
   {
      m_u8ActivePhoneDevice = poServiceTel->u8GetActiveDev();
      ETG_TRACE_USR4(("ServiceBT: ServiceTel::m_u8ActivePhoneDevice = %d ", m_u8ActivePhoneDevice));
   }

   ETG_TRACE_USR4(("ServiceBT: u8GetDisconnectionDevHandle  "));
   for (tU8 index = 0; index < m_arDeviceListInfo.size(); index++)
   {
      ETG_TRACE_USR4(("ServiceBT: u8GetDisconnectionDevHandle PairedDevice.index = %d ", m_arDeviceListInfo[index].GetDeviceHandle()));
      if ((m_arDeviceListInfo[index].GetConnectingStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
            && (m_arDeviceListInfo[index].GetDeviceHandle() == m_u8ActivePhoneDevice))
      {
         ETG_TRACE_USR4(("ServiceBT: u8GetDisconnectionDevHandle au8DeviceHandle = %d ", m_arDeviceListInfo[index].GetDeviceHandle()));
         return (m_arDeviceListInfo[index].GetDeviceHandle());
      }
   }
   return 0;
}


/***************************************************************************
* This function is called inorder to call the method DisconnectBluetoothProfileStart
* Function name : vSendDisconnectBTProfile
* parma[in]- tU8,most_BTSet_fi_types_Extended::T_BTServiceType
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vSendDisconnectBTProfile(tU8 u8DevHandle, ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType)
{
   ETG_TRACE_USR4(("ServiceBT: vSendDisconnectBTProfile u8DevHandle = %d ", u8DevHandle));
   if (_btSetProxy)
   {
      _btSetProxy->sendDisconnectBluetoothProfileStart(*this, u8DevHandle, ServiceType);
   }
}


/***************************************************************************
* This function is called inorder to call ConnectBluetoothProfileStartMethod
* Function name : vSendConnectBTProfile
* parma[in]- tU8,most_BTSet_fi_types_Extended::T_BTServiceType
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vSendConnectBTProfile(tU8 u8DevHandle, ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType)
{
   ETG_TRACE_USR4(("ServiceBT: vSendConnectBTProfile u8DevHandle = %d ", u8DevHandle));
   if (_btSetProxy)
   {
      _btSetProxy->sendConnectBluetoothProfileStart(*this, u8DevHandle, ServiceType);
   }
}


/***************************************************************************
* This function is called inorder to enable MultiHFPSupport on the HU
* Function name : vSwitchMultiHFPSupport
* parma[in]- tBool bMultiHFPSupport
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
tVoid ServiceBT::vSwitchMultiHFPSupport(tBool bMultiHFPSupport)
{
   ETG_TRACE_USR4(("ServiceBT: vSwitchMultiHFPSupport bMultiHFPSupport = %d ", bMultiHFPSupport));
   if (_btSetProxy)
   {
      _btSetProxy->sendSwitchMultiHFPSupportStart(*this, bMultiHFPSupport);
   }
}


/***************************************************************************
* Method Error
* Function name : onSwitchMultiHFPSupportError
* parma[in]-
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
void ServiceBT::onSwitchMultiHFPSupportError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onSwitchMultiHFPSupportError"));
}


/***************************************************************************
* Method Result
* Function name : onSwitchMultiHFPSupportResult
* parma[in]-
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
void ServiceBT::onSwitchMultiHFPSupportResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportResult >& result)
{
   ETG_TRACE_USR4(("ServiceBT::onSwitchMultiHFPSupportResult"));
}


/***************************************************************************
* This function is called inorder to enable MultiHFPSupport on the HU
* Function name : vSwitchMultiHFPSupport
* parma[in]- tBool bMultiHFPSupport
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
****************************************************************************/
void ServiceBT::onDisconnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileError"));
}


/***************************************************************************
* This function is called inorder to enable MultiHFPSupport on the HU
* Function name : vSwitchMultiHFPSupport
* parma[in]- tBool bMultiHFPSupport
* param[out]- tVoid
* v 0.1 initial rev : Aniket Anand
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
* v 0.2 initial rev : Sai Prabha Changes made :Bug 280289

****************************************************************************/
void ServiceBT::onDisconnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileResult >& result)
{
   ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult "));
   ::most_BTSet_fi_types_Extended::T_BTServiceType ServiceType;

   ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: ActiveHandle:%d ", ServiceTel::poGetInstance()->u8GetActiveDev()));

   ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: Handle from status:%d ", result->getU8DeviceHandle()));

   ETG_TRACE_USR4(("HFP discnt:%d", result->getOProfileDisconnectionStatus().getBHFP()));
   ETG_TRACE_USR4(("AVP discnt:%d", result->getOProfileDisconnectionStatus().getBAVP()));

   // if only hfp of a connected device is disconnected, then reduce the num of hfp connected devices , delete the lists and update to the model
   if ((result->getOProfileDisconnectionStatus().getBHFP() == true) && (ServiceTel::poGetInstance()->u8GetActiveDev() == result->getU8DeviceHandle()))
   {
      ETG_TRACE_USR4(("HFP discnt inside if:%d", result->getOProfileDisconnectionStatus().getBHFP()));
      ETG_TRACE_USR4(("HFP discnt inside if"));

      ServicePhoneBook::poGetInstance()->vDeleteCallList();
      ServicePhoneBook::poGetInstance()->vDeleteContactList();
      ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.erase(ServiceTel::poGetInstance()->u8GetActiveDev());
   }

   // if only hfp of a connected device is disconnected
   else if ((result->getOProfileDisconnectionStatus().getBAVP() == true) && (ServiceTel::poGetInstance()->u8GetActiveDev() == result->getU8DeviceHandle()))
   {
      ETG_TRACE_USR4(("AVP discnt inside if"));
      ETG_TRACE_USR4(("AVP discnt inside if:%d", result->getOProfileDisconnectionStatus().getBAVP()));
   }
   // if both hfp and avp of a connected device are disconnected, then reduce the num of hfp connected devices , delete the lists and update to the model
   else if ((result->getOProfileDisconnectionStatus().getBHFP() == true) && (result->getOProfileDisconnectionStatus().getBAVP() == true) && (ServiceTel::poGetInstance()->u8GetActiveDev() == result->getU8DeviceHandle()))
   {
      ETG_TRACE_USR4(("both"));

      ServicePhoneBook::poGetInstance()->vDeleteCallList();
      ServicePhoneBook::poGetInstance()->vDeleteContactList();
      ServicePhoneBook::poGetInstance()->m_phonebookSupportStatus.erase(ServiceTel::poGetInstance()->u8GetActiveDev());
   }
   // When both profiles are disconnected
   if ((result->getOProfileDisconnectionStatus().getBHFP() == true) || (result->getOProfileDisconnectionStatus().getBAVP() == true))
   {
      for (tU8 i = 0; i < m_u8NumConnectedDevice; i++)
      {
         if (result->getU8DeviceHandle() == m_arDeviceListInfo[i].GetDeviceHandle())
         {
            if ((m_arDeviceListInfo[i].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED)
                  && (m_arDeviceListInfo[i].GetAVPStatus() ==
                      most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_DISCONNECTED))
            {
               ETG_TRACE_USR4(("m_arDeviceListInfo[i].GetHFPStatus():%d", m_arDeviceListInfo[i].GetHFPStatus()));
               ETG_TRACE_USR4(("m_arDeviceListInfo[i].GetAVPStatus():%d", m_arDeviceListInfo[i].GetAVPStatus()));
               ETG_TRACE_USR4(("Device Name = %s", m_arDeviceListInfo[i].GetDeviceName().c_str()));
               ETG_TRACE_USR4(("Disconnected popup since both profiles are disconnected"));
               // bug fix 1070163, disconnected triggered internally to perform add device,
               // the popup get queued, as add device popup is triggered, so queued popup, appears later
               // even if the Add new device is cancelled and earlier device get reconnected. This
               // condition was added to avoid requesting for device disconnection popup
               if ((m_bIsDisconnectflag == true) // part of Bug fix 893271(disconnect popup shown twice for same device)
                     || (bAddDeviceAfterDisconnect == true)) // part of bug fix 1070163
               {
                  ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: Don't display disconnect pop up"));
                  m_bIsDisconnectflag = false;
               }
               else
               {
                  if (!bIsDeviceDisconnectionProcessed(result->getU8DeviceHandle()))
                  {
                     ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: Display disconnect pop up For the first time"));
                     // POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceDisConnected"))));
                     POST_MSG((COURIER_MESSAGE_NEW(DeviceStatusResp)(BTPHN_EN_DEVICE_DISCONNECTED)));

                     if (std::find(m_vecDisconnectDeviceList.begin(), m_vecDisconnectDeviceList.end(), result->getU8DeviceHandle()) == m_vecDisconnectDeviceList.end())
                     {
                        // insert only unique device handles
                        m_vecDisconnectDeviceList.push_back(result->getU8DeviceHandle());
                     }
                  }
                  else
                  {
                     ETG_TRACE_USR4(("device disconnected - Already processed"));
                  }
               }
            }
            ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: both for popup"));
         }
      }
   }
   if (m_u8StoreHandleHFP >= BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX)
   {
      ServiceType.setBHFP(true);
      ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: sending HFP connection request for device with handle = %d", m_u8StoreHandleHFP));
      vSendConnectBTProfile(m_u8StoreHandleHFP, ServiceType);
      m_u8StoreHandleHFP = BTPHN_C_DEFAULT_VALUE_ZERO;
   }
   else if (m_u8StoreHandleAVP >= BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX)
   {
      ServiceType.setBAVP(true);
      ETG_TRACE_USR4(("ServiceBT::onDisconnectBluetoothProfileResult: sending A2DP connection request for device with handle = %d", m_u8StoreHandleAVP));
      vSendConnectBTProfile(m_u8StoreHandleAVP, ServiceType);
      m_u8StoreHandleAVP = BTPHN_C_DEFAULT_VALUE_ZERO;
   }
}


/***************************************************************************
* This function is responsible for placing a call to the number displayed in  the row value received
* @param[in] - hdlRow -> row value received from button press
*
* @param[out]- tVoid

****************************************************************************/
tVoid ServiceBT::vContactCallListItemInfo(tU8 hdlRow)
{
   if (BTPHN_C_CONTACT_DETAILS_MAX_NUMBER < hdlRow)
   {
      ETG_TRACE_ERR(("Invalid contact call List index = %d", hdlRow));
      return;
   }
   //else if ((BTPHN_C_EQUAL != OSAL_s32StringCompare("", acopcContactNumbers[hdlRow])) /*&& (FALSE == bIsDialCallTimerRunning*/)))
   else
   {
      POST_MSG((COURIER_MESSAGE_NEW(ContactDetailsDialReq)(hdlRow)));
      //	ETG_TRACE_ERR(("Calling number = %s", acopcContactNumbers[hdlRow]));
      //	/* Sending the phone number to telservice for placing a call */
      ServicePhoneBook::poGetInstance()->vDialCallMethodStart(hdlRow);
      //	ServiceTel::getInstance()->vSendDialCallMethodStart(acopcContactNumbers[hdlRow], BTPHN_EN_ECNR_NOCHANGE);
   }
}


/***************************************************************************
* This function is received if user presses yes DeleteDeviceConfirmation pop up i.e,
* if user confirms delection of a particular device from device list
*  it updates delete device name to hmi
* @param[in] - oMsg- deletedeviceConfirmation req message
*
* @param[out]- true as couirer message is consumed
v0.1 initial rev: Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
v0.2 initial rev: Sai Prabha Changes: Bug 280289
****************************************************************************/
bool ServiceBT::onCourierMessage(const DeleteDeviceConfirmationReq& oMsg)
{
   ETG_TRACE_USR4(("DeleteDeviceConfirmationReq:: Device Index : %d ", u8PairedDeviceListDeviceDleteIndex));
   /* Updating Deleting Device status*/
   vUpdateDeviceState(u8PairedDeviceListDeviceDleteIndex, BTPHN_EN_DELETE);
   // Delete the current lists information

   ETG_TRACE_USR4(("Deleting lists on Disconnection of phone"));
   ServicePhoneBook::poGetInstance()->vDeleteCallList();
   ServicePhoneBook::poGetInstance()->vDeleteContactList();
   ETG_TRACE_USR4(("in if in deleted"));

   //POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceDeleting"))));
   POST_MSG((COURIER_MESSAGE_NEW(DeviceStatusResp)(BTPHN_EN_DEVICE_DELETED)));
   bDeviceDisconnectInitiated = false;

   return true;
}


/************************************************************************
* This function is called when device has to be deleted from device list
* it sets device state action to appropriate value based on dvice connected status,
* it then invokes vSendChangeDeviceStateStart
* @param[in] - devicedleteindex- device row index to be deleted
*				deviceState - device state action which has to be performed
* @param[out]- void
initial rev: Aniket
* Req Ids : SYSFL-2636, SYSFL-2637, SYSFL-4780, SYSFL-4781
**************************************************************************/
tVoid ServiceBT::vUpdateDeviceState(tU8& l_u8deviceindex, btphn_tenBTDeviceStateAction enDeviceStateAction)
{
   ETG_TRACE_USR4(("ServiceBT : vUpdateDeviceState()"));
   ETG_TRACE_USR3(("Device state action : %d, list index : %d ", enDeviceStateAction, l_u8deviceindex));
   /* Extracting the device index and device action to be performed */

   /* Check for invalid device list index */
   if ((l_u8deviceindex > m_arDeviceListInfo.size()))
   {
      ETG_TRACE_ERR(("ServiceBT: vUpdateDeviceState()\t Invalid Device list index"));
   }
   else
   {
      tU8 u8CurrDeviceHandle = m_arDeviceListInfo[l_u8deviceindex].GetDeviceHandle();
      /* Check for invalid device state action */
      if (BTPHN_EN_INVALID == enDeviceStateAction)
      {
         ETG_TRACE_ERR(("ServiceBT: vUpdateDeviceState()\tInvalid Device state action"));
      }
      /*if a select request is received when there is already existing active device connection, then disconnect the active connected device and once this device is disconnected, connection request is processed for the new select request*/
      // else if ((BTPHN_EN_SELECT == enDeviceStateAction) && (m_u8MaxNumOfHFPConnected >= MAX_HFP_CONNECTION))
      // {
      // ETG_TRACE_USR4(("vUpdateDeviceState() BTPHN_EN_SELECT "));
      // ETG_TRACE_USR4(("vUpdateDeviceState() Sending disconnect for connected device "));
      // //store the current device for select request
      // tU8 DeviceHandle = u8GetDisconnectionDevHandle();
      // u8SelectDeviceHandle = u8CurrDeviceHandle;
      // vSendChangeDeviceStateStart(BTPHN_EN_DISCONNECT, DeviceHandle);
      // return;
      // }
      /* Check if the connected device has to be deleted */
      else if (BTPHN_EN_DELETE == enDeviceStateAction)
      {
         /* Check if the change device handle is equal to the connected device handle */
         if (m_arConnectedDeviceProfileInfo.find(u8CurrDeviceHandle) != m_arConnectedDeviceProfileInfo.end())
         {
            u8DeleteDeviceHandle = u8CurrDeviceHandle;

            /* Setting the device state action to DISCONNECT since the connected device has to be first disconnected before it is deleted from the list */
            enDeviceStateAction = BTPHN_EN_DISCONNECT;
         }
      }
      /*request for change device state start*/
      vSendChangeDeviceStateStart(enDeviceStateAction, u8CurrDeviceHandle);
   }
}


/********************************************************************************
* This function is responsible for sending device state start for device selected by the user from device list
* it sets device state action to appropriate value based on dvice connected status,
* it then invokes vSendChangeDeviceStateStart
* @param[in] - 	enDeviceStateAction - device state action which has to be performed
u8DeviceHandle - device handle of the requested/selected device
* @param[out]- void
initial rev:Shwetha K
***********************************************************************************/
tVoid ServiceBT::vSendChangeDeviceStateStart(btphn_tenBTDeviceStateAction enDeviceStateAction, tU8 u8DeviceHandle)
{
   ETG_TRACE_USR4(("ServiceBT : vSendChangeDeviceStateStart() u8DeviceHandle = %d enDeviceStateAction =%d", u8DeviceHandle, enDeviceStateAction));
   /*tstart timer for device connecting  */
   //CRQ - SUZUKI-21726 - Handle BTPHN_EN_BT_CONNECTIONFAILED Popup
   if (FALSE == bChangeDeviceStateReq)
   {
      IsParingActive = 0;
   }
   if ((FALSE == bIsDeviceConnectionTimerRunning) && (BTPHN_EN_SELECT == enDeviceStateAction))
   {
      vStartDeviceConnectionTimer();
   }

   /* SUZUKI-15552. For DeviceHandle 0, ChangeDeviceState request is sent to
   FC_Bluetooth with DeviceStatus to be set as BLOCK or UNBLOCK */

   /*to check if service is available*/
   if (_btSetProxy)
   {
      if (bChangeDeviceStateReq == false)
      {
         if (((BTPHN_EN_BLOCK == enDeviceStateAction) || (BTPHN_EN_UNBLOCK_AUTO_CONNECT == enDeviceStateAction)) || (BTPHN_EN_UNBLOCK == enDeviceStateAction))
         {
            if (BTPHN_C_DEVICEHANDLE_ZERO == u8DeviceHandle)
            {
               _btSetProxy->sendChangeDeviceStateStart(*this, most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction(enDeviceStateAction), u8DeviceHandle);
            }
            else
            {
               ETG_TRACE_ERR(("Block/Unblock cannot be done for device handle : %d", u8DeviceHandle));
            }
         }
         else // (BTPHN_C_PAIRED_DEVICE_HANDLE_START_INDEX <= u8DeviceHandle)
         {
            /* Sending the request to BT service to change the state of	a device in the device list */
            _btSetProxy->sendChangeDeviceStateStart(*this, most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction(enDeviceStateAction), u8DeviceHandle);
            ETG_TRACE_USR4(("request sent to service"));
         }
         /* This flag is set so that subsequent AddNewDevice or ChangeDeviceState requests are not processed before response or error is received for current request */
         bChangeDeviceStateReq = true;
         ETG_TRACE_USR4(("vSendChangeDeviceStateStart:DeviceStateReqFlag : %d", bChangeDeviceStateReq));
      }
      else
      {
         ETG_TRACE_USR4(("request not sent to service"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("ServiceBT : vChangeDeviceStateStart()\t"
                     "BT service is unavailable hence request not posted"));
      /*SUZUKI-21003 - If BTService is not avilable then error will be returned to HMI*/
      bChangeDeviceStateReq = false;
      ETG_TRACE_USR4(("vSendChangeDeviceStateStart else:DeviceStateReqFlag : %d", bChangeDeviceStateReq));

      /*to do : if e call is implented*/
      ///*SUZUKI-21886: On E-call activation immediately after/before H.U. startup, BT device
      //disconnection does not succeed. Check for serviceAvailability is missing,
      //before posting to BT service. */
      //bEcallUpdateStatus = (corfenDeviceState == BTPHN_EN_BLOCK) ? TRUE : FALSE;

      /* Sending the error information for updating HMI */
      vSendServiceError(BTPHN_EN_BT_CHANGEDEVICESTATE, BTPHN_EN_ERRCODE_NOERROR);
   }
}


/********************************************************************************
*FUNCTION: 		 vSendServiceError
*DESCRIPTION: 	 Sends courier message with BT service error information to HMI
*PARAMETER:
* 				    corfrServiceType:	(I)
* 					    BT service type
* 				    corfrErrCode:	(I)
* 					    Service error code
*
*RETURNVALUE: 	tVoid
*
*HISTORY:
*30.11.17 Shwetha K
*Rev 0.1 Initial Revision.
**********************************************************************************/

void ServiceBT::vSendServiceError(const btphn_tenBTServiceType& corfrServiceType,  btphn_tenServiceErrCode corfrErrCode)
{
   ETG_TRACE_USR4(("ServiceBT : vSendServiceError()\t"));
   ETG_TRACE_USR4(("BT service type = %x\t", corfrServiceType));

   /* Sends courier message with BT service error information to HMI */
   switch (corfrServiceType)
   {
      case BTPHN_EN_BT_CHANGEDEVICESTATE:
      {
         /*Error Handling done in BL*/
         ETG_TRACE_USR4(("btphn_tclBTPhoneModel : Button Disable at BTPHN_EN_BT_CHANGEDEVICESTATE "));
         IsDeviceListOperationProgress = BTPHN_C_VALUE_ZERO;
         IsDeviceConnectingActive = BTPHN_C_VALUE_ZERO;
         break;
      }
      /*reset flag for connection failed*/
      case BTPHN_EN_BT_CONNECTIONFAILED:
      {
         /*Error Handling done in BL*/
         ETG_TRACE_USR4(("ServiceBT : vSendServiceError():BTPHN_EN_BT_CONNECTIONFAILED\t"));

         IsDeviceListOperationProgress = BTPHN_C_VALUE_ZERO;
         break;
      }
      /*to do for add new device*/
      default:
      {
         ETG_TRACE_ERR(("No Valid List ID Found"));
         break;
      }
   }

   /*update service error to controller*/
   POST_MSG((COURIER_MESSAGE_NEW(BTServiceErrResp)(corfrServiceType, corfrErrCode)));

   //CRQ - SUZUKI-21726 - Resetting the DeviceConnectionTimer whenever we receive ConnectionResult/Error.
   bIsDeviceConnectionTimerRunning = FALSE;
   ETG_TRACE_USR4(("bIsDeviceConnectionTimerRunning Set to False"));
}


/************************************************************************
*FUNCTION: 		 vOnDeviceConnectionTimerExpiry
*DESCRIPTION: 	 vOnDeviceConnectionTimerExpiry will be called, whenever the timer get expired while there is no response from Service.
*				 This timer will wait for Connection Status from Service. We should get response as Connected or Error. In case,
*				 we don't receive any messages upto 35Sec, then we should send the BTPHN_EN_BT_CONNECTIONFAILED - Error Message to PL.
*PARAMETER:
*RETURNVALUE: 	 NA
*
*HISTORY:
*08.12.17 Shwetha K
*Rev 0.1 Initial Revision.
************************************************************************/

void ServiceBT::vOnDeviceConnectionTimerExpiry(tPVoid pvObject)
{
   ETG_TRACE_USR4(("ServiceBT : vOnDeviceConnectionTimerExpiry()"));
   BTPHN_M_UNUSED(pvObject);

   ServiceBT::poGetInstance()->vSendServiceError(BTPHN_EN_BT_CONNECTIONFAILED, BTPHN_EN_ERRCODE_NOERROR);	// Sending Error Message to PL by updating BTPHN_EN_BT_CONNECTIONFAILED.
   ETG_TRACE_USR4(("BTPHN_EN_BT_CONNECTIONFAILED popup trigger sent successfully"));
}


/************************************************************************
*FUNCTION: 		 vStopConnectionTimers
*DESCRIPTION : Stop Connection Timers.
*PARAMETER :
*corfenDeviceStatus : (I)
* 					    Changed device state
*RETURNVALUE : tVoid
*
*HISTORY :
*08.12.17 Shwetha K
*Rev 0.1 Initial Revision.
v0.2 initial rev: Sai Prabha Changes: Bug 280289, 272399
************************************************************************/

void ServiceBT::vStopConnectionTimers(const btphn_tenBTDeviceStatus& corfenDeviceStatus, std::string strDeviceName, tU8 u8ChangedDeviceHandle)
{
   ETG_TRACE_USR4(("DeviceConnection corfenDeviceStatus value:%d", corfenDeviceStatus));
   if (BTPHN_EN_DEVICE_NO_CHANGE != corfenDeviceStatus)
   {
      /*to do : when call connect timer is done*/
      //if ((OSAL_NULL != hConnectTimer) &&
      //	(BTPHN_EN_DEVICE_DISCONNECTED == corfenDeviceStatus) &&
      //	(TRUE == bIsConnectTimerRunning))
      //{
      //	OSAL_s32TimerSetTime(
      //		hConnectTimer, // Timer handle
      //		BTPHN_C_DEFAULT_VALUE_ZERO, // Timer expiry duration
      //		BTPHN_C_DEFAULT_VALUE_ZERO // Timer repeat value
      //		);
      //	bIsConnectTimerRunning = FALSE;
      //}

      // CRQ - SUZUKI-21726 : Resetting the flag to false, when device connected successfully.
      if (BTPHN_EN_DEVICE_DISCONNECTED != corfenDeviceStatus)
      {
         if (bDeviceDisconnectInitiated == false)
         {
            vStopDeviceConnectionTimer();
            ETG_TRACE_USR4(("DeviceConnection Timer Stopped. Bcos, We received the ConnectionStatus from Service."));
            for (uint8 i = 0; i < m_arDeviceListInfo.size(); i++)
            {
               if (m_arDeviceListInfo[i].GetDeviceHandle() == u8ChangedDeviceHandle)
               {
                  ETG_TRACE_USR4(("DeviceConnection Timer Stopped HFP:%d", m_arDeviceListInfo[i].GetHFPStatus())); //add
                  ETG_TRACE_USR4(("DeviceConnection Timer Stopped AVP:%d", m_arDeviceListInfo[i].GetAVPStatus())); //add
                  if (m_arDeviceListInfo[i].GetHFPStatus() == most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_CONNECTED)
                  {
                     POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_JustWorksPairing"))));
                     POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_JustWorksPairingWaiting"))));

                     POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("AppHmi_PhoneModule#App_Popup#Pfo_DeviceConnecting"))));
                     POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_PhoneModule#Sys_Popup#Pfo_DeviceConnected"))));

                     if (VehicleSrvClient::poGetInstance() != NULL)
                     {
                        ETG_TRACE_USR4(("DeviceConnection updateBTLinkStatus is BT_STATUS_CONNECTED"));
                        VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_STATUS_CONNECTED); //CAN Imp
                     }
                  }
               }
            }
            rfoDeviceListModel.OnUpdActPassiveDeviceName(strDeviceName);
            IsDeviceConnectingActive = FALSE;
            //IsParingActive = 0;
         }
      }
   }
}


/************************************************************************
*FUNCTION: 		 vStopDeviceConnectionTimer
*DESCRIPTION: 	 vStopDialCallTimer will be called, whenever the Connection Status from Service was received. We should get response as ConnectionStatus or Error.
*				 Now, we will set the flag to false.
*PARAMETER:
*RETURNVALUE: 	 NA
*
*HISTORY:
*08.12.17 Shwetha K
*Rev 0.1 Initial Revision.
************************************************************************/

void ServiceBT::vStopDeviceConnectionTimer()
{
   ETG_TRACE_USR4(("ServiceBT : vStopDeviceConnectionTimer()"));
   // The device connection timer is reset if it is running
   if (TRUE == bIsDeviceConnectionTimerRunning)
   {
      bIsDeviceConnectionTimerRunning = FALSE;
      ETG_TRACE_USR4(("bIsDeviceConnectionTimerRunning Set to False"));
      if (OSAL_NULL != hDeviceConnectionTimer)
      {
         OSAL_s32TimerSetTime(hDeviceConnectionTimer,
                              BTPHN_C_DEFAULT_VALUE_ZERO,
                              BTPHN_C_DEFAULT_VALUE_ZERO);
      }
      ETG_TRACE_USR4(("Device Connection timer is stopped"));
   }
}


/*****************************************************************************
* @brief: responsible for starting device connection timer
* Function name : vStartDeviceConnectionTimer
* 24.04.2018: kis8kor
* Rev 0.1: Initial Version
*****************************************************************************/
void ServiceBT::vStartDeviceConnectionTimer()
{
   ETG_TRACE_USR4(("ServiceBT::vStartDeviceConnectionTimer()"));

   if (OSAL_NULL != hDeviceConnectionTimer)
   {
      ETG_TRACE_USR4(("DeviceConnection Timer is started"));
      OSAL_s32TimerSetTime(
         hDeviceConnectionTimer, // Timer handle
         BTPHN_C_DEVICE_CONNECTION_TIMER_DURATION, // Timer expiry duration
         BTPHN_C_DEFAULT_VALUE_ZERO // Timer repeat value
      );
      bIsDeviceConnectionTimerRunning = TRUE;
      ETG_TRACE_USR4(("bIsDeviceConnectionTimerRunning Set to TRUE"));
   }
}


/***************************************************************************
* Function name : vSetChangeRingtone
* parma[in]- tU8 u8RingToneID
* param[out]- tVoid
* v 0.1 initial rev : Nikhil Francis
****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_PHONECALLMANAGER_SUPPORT
tVoid ServiceBT::vSetChangeRingtone(tU8 u8RingToneID)
{
   ETG_TRACE_USR4(("ServiceBT::Courier Message ::ChangeRingtoneSettingsReq"));
   /* Settings device handle for current active device */
   ServiceTel* poServiceTel = ServiceTel::poGetInstance();
   if (poServiceTel != NULL)
   {
      _btSetProxy->sendChangeRingtonePureSet(poServiceTel->u8GetActiveDev(), u8RingToneID);
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::Courier Message ::ChangeRingtoneSettingsReq : Error in obtaining Servicetel instance"));
      _btSetProxy->sendChangeRingtonePureSet(BTPHN_C_DEFAULT_VALUE_ZERO, u8RingToneID);
   }
}


#endif

/***************************************************************************
* Function name : onClearDeviceInfo
*04.07.2019: ebg1kor
*Rev 0.1: Initial Version
*SYSFL- 529,SWFL-2684: Factory Reset_Phone
****************************************************************************/
tVoid ServiceBT::onClearDeviceInfo()
{
   _btSetProxy->sendClearDeviceInfoStart(*this);
}


#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
void ServiceBT:: onSwitchBluetoothOnOffExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedError"));
   if (error->hasSystemErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedError:SYSTEM Error code"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
   else if (error->hasCcaErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedError:CCA Error code"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(CAN_ERROR);//Gen Can Imp for roaming error code
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedError:Unknown Error"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
}


void ServiceBT::onSwitchBluetoothOnOffExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedResult >& result)
{
   ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedResult"));
}


tVoid ServiceBT::BTONOFFStart(bool bOnOFF)
{
   if (bOnOFF)
   {
      ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedStart ON"));
      _btSetProxy->sendSwitchBluetoothOnOffExtendedStart(*this, true, true);
   }
   else if (false == bOnOFF)
   {
      ETG_TRACE_USR4(("ServiceBT::onSwitchBluetoothOnOffExtendedStart OFF"));
      _btSetProxy->sendSwitchBluetoothOnOffExtendedStart(*this, false, true);
   }
}


void ServiceBT::onBluetoothOnOffError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffError"));
   if (error->hasSystemErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffError:SYSTEM Error code"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
   else if (error->hasCcaErrorCode() == true)
   {
      ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffError:CCA Error code"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(CAN_ERROR);//Gen Can Imp for roaming error code
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffError:Unknown Error"));
      VehicleSrvClient::poGetInstance()->updateBTLinkStatusError(PHONEMW_SNA);//Gen Can Imp for roaming error code
   }
}


void ServiceBT::onBluetoothOnOffStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffStatus >& status)
{
   bool bAppflyinstatus = false;
   ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus"));
   if (false == status->getBBTOnOff())
   {
      if (VehicleSrvClient::poGetInstance() != NULL)
      {
         VehicleSrvClient::poGetInstance()->updateBTLinkStatus(BT_LINK_STATUS_OFF); //CAN Imp
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus vUpdateBTOnOffStatus OFF"));
         VehicleSrvClient::poGetInstance()->vUpdateBTOnOffStatus(BT_STATUS_OFF);
      }
      ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: BT OFF"));
      m_bluetoothOnOffStatus = false;
      if (Sm_ActiveSource == 0)
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: Active Source is BT now so BT Tile Disable"));
         rfoDeviceListModel.OnUpdBTONOFFStatus(false);
      }
//When BT is Off if intercom is available then we need to enable the phone app flyin
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      if (PhoneGadgetModel::poGetInstance()->GetIntercomStatus() == false)
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: Intercom Unavalilable"));
         bAppflyinstatus = false;
      }
      else
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: Intercom avalilable"));
         bAppflyinstatus = true;
      }
#else
      bAppflyinstatus = false;
#endif
      if ((m_bServicestatusflag == true) && (0 == Sm_ActiveSource))
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: service avalilable"));
         rfoPhoneCallModel.OnUpdNetworkOperatorName("Bluetooth off");
      }
      else
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: service unavalilable"));
      }
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: BT ON"));
      m_bluetoothOnOffStatus = true;
      if (VehicleSrvClient::poGetInstance() != NULL)
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus vUpdateBTOnOffStatus ON"));
         VehicleSrvClient::poGetInstance()->vUpdateBTOnOffStatus(BT_STATUS_ON); //CAN Imp
      }
      //Variant handling is not required because irrespective of the intercom availablity, if BT is ON Phone AppFLYin has to be enabled
      bAppflyinstatus = true;
      if (Sm_ActiveSource == 0)
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: Active Source is BT now so BT Tile Enable"));
         rfoDeviceListModel.OnUpdBTONOFFStatus(true);
      }
      if ((m_bServicestatusflag == true) && (0 == Sm_ActiveSource))
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: service avalilable"));
         rfoPhoneCallModel.OnUpdNetworkOperatorName(ServiceTel::poGetInstance()->getDevicenameStatus());
      }
      else
      {
         ETG_TRACE_USR4(("ServiceBT::onBluetoothOnOffStatus :: service unavalilable"));
      }
   }
   // Post the BT on/off status to ApplicationSwitchClientHandler to enable/disable Phone AppFlyIn.
   POST_MSG((COURIER_MESSAGE_NEW(BtOnOffStatusAppFlyInReq)(bAppflyinstatus)));
}


void ServiceBT::onServiceAvailableError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableError >& error)
{
   ETG_TRACE_USR4(("ServiceBT::onServiceAvailableError"));
}


void ServiceBT::onServiceAvailableStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableStatus >& status)
{
   ETG_TRACE_USR4(("ServiceBT::onServiceAvailableStatus STATUS = %d", status->getE8ServiceAvailable()));
   if (status->getE8ServiceAvailable() == most_BTSet_fi_types_Extended::T_e8_BTServiceAvailable__e8SERVICE_AVAILABLE)
   {
      ETG_TRACE_USR4(("ServiceBT::onServiceAvailableStatus available"));
      m_bServicestatusflag = true;
      _btSetProxy->sendBluetoothOnOffGet(*this);
   }
   else
   {
      ETG_TRACE_USR4(("ServiceBT::onServiceAvailableStatus unavailable"));
      m_bServicestatusflag = false;
   }
}


#endif
}	//namespace core
}	//namespace app
