/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : ApplicationSwitchClientHandler.h
* COMPONENT Name      : AppHmi_Phone
* DESCRIPTION         : DBus client for Application switch intrerface.
* AUTHOR              : Ramesh Kesavan
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/

#ifndef APPLICATIONSWITCH_CLIENT_HANDLER
#define APPLICATIONSWITCH_CLIENT_HANDLER
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/ServiceAvailableIF.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include  "AppHmi_PhoneStateMachineData.h"
#include "AppHmi_PhoneMessages.h"
#include "BTPhoneDefines.h"
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
#include "App/Core/Intercom/IntercomClienthandler.h"
#endif


using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
using namespace Courier;
#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

namespace App {
namespace Core {
class ApplicationSwitchClientHandler : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public RequestApplcationSwitchCallbackIF
   , public RequestShowHideWaitSceneCallbackIF
   , public ActivateDeactivateRVCSceneCallbackIF
   , public Mapout_Activate_DeactivateCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public ActiveRegionIdCallbackIF
   , public SendContextCallbackIF
   , public Sig_ControlPanelButtonPressCallbackIF
{
   public:
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      ApplicationSwitchClientHandler(const std::string& portName);
      virtual ~ApplicationSwitchClientHandler();

      //static ApplicationSwitchClientHandler* poGetInstance();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void onRequestApplcationSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchError >& error);
      virtual void onRequestApplcationSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchResponse >& response);

      virtual void onRequestShowHideWaitSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneError >& error);
      virtual void onRequestShowHideWaitSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneResponse >& response);

      virtual void onActivateDeactivateRVCSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneError >& error);
      virtual void onActivateDeactivateRVCSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneResponse >& response);

      virtual void onMapout_Activate_DeactivateError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_Activate_DeactivateError >& error);
      virtual void onMapout_Activate_DeactivateSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_Activate_DeactivateSignal >& signal);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);
      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error);
      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      virtual void onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error);
      virtual void onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response);

      virtual void onSig_ControlPanelButtonPressError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressError >& error);
      virtual void onSig_ControlPanelButtonPressSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressSignal >& signal);
   public:
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ViewPhoneActivityId)
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      ON_COURIER_MESSAGE(BtOnOffStatusAppFlyInReq)
#endif
      COURIER_MSG_MAP_DELEGATE_END()
      bool onCourierMessage(const ViewPhoneActivityId&);
#ifdef VARIANT_S_FTR_ENABLE_BLUETOOTH_ON_OFF
      bool onCourierMessage(const BtOnOffStatusAppFlyInReq&);
#endif
#ifdef VARIANT_S_FTR_ENABLE_INTERCOM_SUPPORT
      void OnUpdonSig_ActivateContextSignal_Intercom();
#endif
      void displayPhoneContextScene();
      void OnUpdonSig_ActivateContextSignal_Phone();
      void SetPhoneContextStatus(en_phoneContextStatus temp_phoneContextStatus);
      en_phoneContextStatus GetPhoneContextStatus();
      void SetPhoneContextBgReqFlag(bool BgReqFlagStatus);
      bool GetPhoneContextBgReqFlag();
      bool GetPhoneContextRVCStatus();

      void SetCurrentPhoneStatus(en_phoneContextStatus argCurrentPhoneStatus);
      /* Interface to get the current TargetAppID of the whole system HMI */
      uint8 getTargetAppID(void);
      /* Interface to get the current ActivityID of the whole system HMI */
      APPLICATIONSWITCH_TYPES::enActivityIDs getCurrentActivityID(void);
      void restorePhoneApplicationScene(bool EnablePermanentView = false);

   private:
      en_phoneContextStatus m_enPhoneContextStatus;
      bool m_bIsPhoneContextBgRequested;
      en_phoneContextStatus m_enCurrentPhoneStatus;
      bool m_bPhoneContextRVCStatusflag;
      bool m_isPermanentActivityID;
      bool m_bPrevAppflyinState;
      bool m_bAppflyinInitialState;
      APPLICATIONSWITCH_TYPES::enActivityIDs m_entargetActivityID;

      uint8 m_u8TargetAppID;
      APPLICATIONSWITCH_TYPES::enActivityIDs m_enCurrPermanentViewActivityID;
      APPLICATIONSWITCH_TYPES::enActivityIDs m_enCurrIntermediateViewActivityID;
      APPLICATIONSWITCH_TYPES::enActivityIDs  m_enActivityID;

      ApplicationSwitchClientHandler();
      void ProcessExternalSceneTransitionTriggers();
      //static ApplicationSwitchClientHandler* m_poSelfAppSwitchClient;
      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchClient;

      APPLICATIONSWITCH_TYPES::enActivityIDs getActivityIDforCurrentView(void);
      void requestSendContext(uint8  regionId, uint8  sourceAppId, APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId);
};


}
}


#endif //APPLICATIONSWITCH_CLIENT_HANDLER
