/* ***************************************************************************************
* FILE:          CGIAppViewFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(CGI_APP_VIEW_FACTORY_H)
#define CGI_APP_VIEW_FACTORY_H

#include "CgiExtensions/CGIAppViewFactoryBase.h"
#include "CgiExtensions/SceneMapping.h"

class CGIAppViewFactory : public CGIAppViewFactoryBase
{
   public:
      CGIAppViewFactory();

      virtual Courier::View* Create(const Courier::Char* viewId);
      virtual void Destroy(Courier::View* view);
};


class CGIAppViewControllerFactory : public Courier::ViewControllerFactory
{
   public:
      virtual Courier::ViewController* Create(const Courier::Char* viewId);
      virtual void Destroy(Courier::ViewController* viewController);
};


#endif //CGI_APP_VIEW_FACTORY_H
