/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_NavigationMessages.h"
// the views
#include "CGIAppViewController_Navigation.h"

SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Address_DetailedInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Disclaimer),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Favourites),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Fav_AddFavorites),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Fav_SetHome),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Guidance),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Guidance_BlockRouteList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Guidance_ShowRouteList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_LastDestinations),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_LatLongInput),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Map),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Map_ActiveRG),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Map_Move),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MyPOIs_AddressInput),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_NewDestination),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_GuidanceOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_MapOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_MapOptions_OnMap),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_MapOption_MapColor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_MapOption_Others),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_PositionAndGPSInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_RouteOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_RouteOptions_Others),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_TrafficIcons),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_VehicleOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_RouteOptions_Others),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MultiLine_TwoButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_ThreeLine_TwoButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POIDetailedInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POIInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POI_CategoryRoot),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POI_CategorySublevel),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POI_DetailedInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POI_List),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_POI_ListEmpty),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_ReplaceFavorites),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SpellerEdit),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SpellerEdit_FreeText),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Speller_MatchList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_Dest_CalcRoute),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_Dest_VehicleInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_HomeEdit_Info_ThreeLine),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_LatLong_Invalid),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MultiLine_Text),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SingleLine_TwoButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Speller_EU_ABC_Symbol),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Speller_EU_SpecialCharacters),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Speller_LatLong_DialPad),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Navigation_Gadget),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_StreamedMap_Settings),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_StreamedMap_SettingsSubOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MapUpdate_Error),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MapUpdate_Interactive),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MapUpdate_Progress),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_SpeedLimitOption),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_PremiumTraffic),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_TrafficOptions),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MultiLine_text_1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_OPT_PremiumTraffic_Disclaimer),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MapOut_Notification),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_RouteInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_LCVRestrictionInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_FourLine_SingleButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SpeedLockInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_FiveLine_TwoButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_ThreeLine_Text),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SingleLine_SingleButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_XUrgent_Message),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_Sys_ThreeLine_Text),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_ThreeLine_OneButton),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_PremiumTrafficDisabled),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_LCVHardRestrictionInfo_Multiple),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_LCVHardRestrictionConfirm_Multiple),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_LCVHardRestrictionInfo_ActiveRG),
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}
